/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.gis.viewer;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nl.b3p.commons.services.FormUtils;
import nl.b3p.gis.viewer.ViewerCrudAction;
import nl.b3p.gis.viewer.db.Tekstblok;
import nl.b3p.gis.viewer.services.HibernateUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.validator.DynaValidatorForm;
import org.hibernate.classic.Session;

public class ConfigCMSAction
extends ViewerCrudAction {
    private static final Log logger = LogFactory.getLog(ConfigCMSAction.class);

    private Tekstblok getTekstblok(DynaValidatorForm form, boolean createNew) {
        Session sess;
        Tekstblok tb;
        if (createNew) {
            return new Tekstblok();
        }
        Integer id = (Integer)form.get("tekstBlokID");
        if (id != null && id > 0 && (tb = (Tekstblok)(sess = HibernateUtil.getSessionFactory().getCurrentSession()).get(Tekstblok.class, (Serializable)id)) != null) {
            return tb;
        }
        return null;
    }

    private Tekstblok getFirstTekstblok() {
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        List lijst = sess.createQuery("from Tekstblok order by cdate").setMaxResults(1).list();
        if (lijst != null && lijst.size() == 1) {
            return (Tekstblok)lijst.get(0);
        }
        return null;
    }

    protected void createLists(DynaValidatorForm form, HttpServletRequest request) throws Exception {
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        List tekstBlokken = sess.createQuery("from Tekstblok order by cdate").list();
        request.setAttribute("tekstBlokken", (Object)tekstBlokken);
        List cmsPaginas = sess.createQuery("from CMSPagina order by titel").list();
        request.setAttribute("cmsPaginas", (Object)cmsPaginas);
    }

    public ActionForward unspecified(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Tekstblok tb = this.getTekstblok(dynaForm, false);
        if (tb == null) {
            tb = this.getFirstTekstblok();
        }
        this.populateTekstblokForm(tb, dynaForm, request);
        this.prepareMethod(dynaForm, request, "edit", "list");
        this.addDefaultMessage(mapping, request, "acknowledgeMessages");
        return mapping.findForward("success");
    }

    public ActionForward edit(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Tekstblok tb = this.getTekstblok(dynaForm, false);
        if (tb == null) {
            tb = this.getFirstTekstblok();
        }
        this.populateTekstblokForm(tb, dynaForm, request);
        this.prepareMethod(dynaForm, request, "edit", "list");
        this.addDefaultMessage(mapping, request, "acknowledgeMessages");
        return this.getDefaultForward(mapping, request);
    }

    public ActionForward save(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!this.isTokenValid(request)) {
            this.prepareMethod(dynaForm, request, "edit", "list");
            this.addAlternateMessage(mapping, request, "error.token");
            return this.getAlternateForward(mapping, request);
        }
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        ActionErrors errors = dynaForm.validate(mapping, request);
        if (!errors.isEmpty()) {
            this.addMessages(request, (ActionMessages)errors);
            this.prepareMethod(dynaForm, request, "edit", "list");
            this.addAlternateMessage(mapping, request, "error.validation");
            return this.getAlternateForward(mapping, request);
        }
        Tekstblok tb = this.getTekstblok(dynaForm, true);
        if (tb == null) {
            this.prepareMethod(dynaForm, request, "list", "edit");
            this.addAlternateMessage(mapping, request, "error.notfound");
            return this.getAlternateForward(mapping, request);
        }
        this.populateTekstblokObject(dynaForm, tb, request);
        sess.saveOrUpdate((Object)tb);
        sess.flush();
        sess.refresh((Object)tb);
        this.populateTekstblokForm(tb, dynaForm, request);
        this.prepareMethod(dynaForm, request, "edit", "list");
        this.addDefaultMessage(mapping, request, "acknowledgeMessages");
        return mapping.findForward("success");
    }

    public ActionForward delete(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!this.isTokenValid(request)) {
            this.prepareMethod(dynaForm, request, "edit", "list");
            this.addAlternateMessage(mapping, request, "error.token");
            return this.getAlternateForward(mapping, request);
        }
        Session sess = null;
        Tekstblok tb = null;
        try {
            sess = HibernateUtil.getSessionFactory().getCurrentSession();
            tb = this.getTekstblok(dynaForm, false);
            if (tb == null) {
                this.prepareMethod(dynaForm, request, "list", "edit");
                this.addAlternateMessage(mapping, request, "error.notfound");
                return this.getAlternateForward(mapping, request);
            }
            sess.delete((Object)tb);
            sess.flush();
        }
        catch (Exception ex) {
            logger.error((Object)("Fout tijdens verwijderen van tekstblok " + tb.getTitel()), (Throwable)ex);
            this.prepareMethod(dynaForm, request, "list", "edit");
            this.addAlternateMessage(mapping, request, "error.exception");
            return this.getAlternateForward(mapping, request);
        }
        Tekstblok tekstBlok = this.getFirstTekstblok();
        if (tekstBlok != null) {
            this.populateTekstblokForm(tekstBlok, dynaForm, request);
        } else {
            dynaForm.initialize(mapping);
        }
        this.prepareMethod(dynaForm, request, "edit", "list");
        this.addDefaultMessage(mapping, request, "acknowledgeMessages");
        return mapping.findForward("success");
    }

    private void populateTekstblokForm(Tekstblok tb, DynaValidatorForm dynaForm, HttpServletRequest request) {
        if (tb == null) {
            return;
        }
        dynaForm.set("tekstBlokID", (Object)tb.getId());
        dynaForm.set("titel", (Object)tb.getTitel());
        dynaForm.set("tekst", (Object)tb.getTekst());
        dynaForm.set("url", (Object)tb.getUrl());
        dynaForm.set("toonUrl", (Object)tb.getToonUrl());
        dynaForm.set("volgordeNr", (Object)tb.getVolgordeNr());
        dynaForm.set("kleur", (Object)tb.getKleur());
        dynaForm.set("inlogIcon", (Object)tb.getInlogIcon());
        dynaForm.set("hoogte", (Object)tb.getHoogte());
        dynaForm.set("cmsPagina", (Object)tb.getCmsPagina());
    }

    private void populateTekstblokObject(DynaValidatorForm dynaForm, Tekstblok tb, HttpServletRequest request) {
        Integer volgordeNr;
        Integer id = (Integer)dynaForm.get("tekstBlokID");
        if (id != null && id != 0) {
            tb.setId(id);
        }
        tb.setTitel(FormUtils.nullIfEmpty((String)dynaForm.getString("titel")));
        tb.setTekst(FormUtils.nullIfEmpty((String)dynaForm.getString("tekst")));
        tb.setUrl(FormUtils.nullIfEmpty((String)dynaForm.getString("url")));
        Boolean toonUrl = (Boolean)dynaForm.get("toonUrl");
        if (toonUrl != null && toonUrl.booleanValue()) {
            tb.setToonUrl(Boolean.valueOf(true));
        } else {
            tb.setToonUrl(Boolean.valueOf(false));
        }
        tb.setKleur(FormUtils.nullIfEmpty((String)dynaForm.getString("kleur")));
        Boolean inlogIcon = (Boolean)dynaForm.get("inlogIcon");
        if (inlogIcon != null && inlogIcon.booleanValue()) {
            tb.setInlogIcon(Boolean.valueOf(true));
        } else {
            tb.setInlogIcon(Boolean.valueOf(false));
        }
        Integer hoogte = (Integer)dynaForm.get("hoogte");
        if (hoogte != null) {
            tb.setHoogte(hoogte);
        }
        if ((volgordeNr = (Integer)dynaForm.get("volgordeNr")) != null) {
            tb.setVolgordeNr(volgordeNr);
        }
        tb.setAuteur("beheerder");
        Date cdate = new Date();
        tb.setCdate(cdate);
        Integer cmsPagina = (Integer)dynaForm.get("cmsPagina");
        if (cmsPagina != null && cmsPagina > 0) {
            tb.setCmsPagina(cmsPagina);
        } else {
            tb.setCmsPagina(null);
        }
    }
}

