/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.gis.viewer;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nl.b3p.commons.services.FormUtils;
import nl.b3p.gis.viewer.ViewerCrudAction;
import nl.b3p.gis.viewer.db.CMSMenu;
import nl.b3p.gis.viewer.db.CMSMenuItem;
import nl.b3p.gis.viewer.services.HibernateUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.validator.DynaValidatorForm;
import org.hibernate.classic.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigCMSMenuAction
extends ViewerCrudAction {
    private static final Log logger = LogFactory.getLog(ConfigCMSMenuAction.class);

    private CMSMenu getCMSMenu(DynaValidatorForm form, boolean createNew) {
        Session sess;
        CMSMenu cmsMenu;
        if (createNew) {
            return new CMSMenu();
        }
        Integer id = (Integer)form.get("cmsMenuID");
        if (id != null && id > 0 && (cmsMenu = (CMSMenu)(sess = HibernateUtil.getSessionFactory().getCurrentSession()).get(CMSMenu.class, (Serializable)id)) != null) {
            return cmsMenu;
        }
        return null;
    }

    private CMSMenu getFirstCMSMenu() {
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        List lijst = sess.createQuery("from CMSMenu order by cdate").setMaxResults(1).list();
        if (lijst != null && lijst.size() == 1) {
            return (CMSMenu)lijst.get(0);
        }
        return null;
    }

    protected void createLists(DynaValidatorForm form, HttpServletRequest request) throws Exception {
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        List cmsMenus = sess.createQuery("from CMSMenu order by cdate").list();
        request.setAttribute("cmsMenus", (Object)cmsMenus);
        request.setAttribute("cmsMenuItems", this.getAllCMSMenuItems());
    }

    public ActionForward unspecified(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CMSMenu cmsMenu = this.getCMSMenu(dynaForm, false);
        if (cmsMenu == null) {
            cmsMenu = this.getFirstCMSMenu();
        }
        this.populateCMSMenuForm(cmsMenu, dynaForm, request);
        this.prepareMethod(dynaForm, request, "edit", "list");
        this.addDefaultMessage(mapping, request, "acknowledgeMessages");
        return mapping.findForward("success");
    }

    public ActionForward edit(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CMSMenu cmsMenu = this.getCMSMenu(dynaForm, false);
        if (cmsMenu == null) {
            cmsMenu = this.getFirstCMSMenu();
        }
        this.populateCMSMenuForm(cmsMenu, dynaForm, request);
        this.prepareMethod(dynaForm, request, "edit", "list");
        this.addDefaultMessage(mapping, request, "acknowledgeMessages");
        return this.getDefaultForward(mapping, request);
    }

    public ActionForward save(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!this.isTokenValid(request)) {
            this.prepareMethod(dynaForm, request, "edit", "list");
            this.addAlternateMessage(mapping, request, "error.token");
            return this.getAlternateForward(mapping, request);
        }
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        ActionErrors errors = dynaForm.validate(mapping, request);
        if (!errors.isEmpty()) {
            this.addMessages(request, (ActionMessages)errors);
            this.prepareMethod(dynaForm, request, "edit", "list");
            this.addAlternateMessage(mapping, request, "error.validation");
            return this.getAlternateForward(mapping, request);
        }
        CMSMenu cmsMenu = this.getCMSMenu(dynaForm, true);
        if (cmsMenu == null) {
            this.prepareMethod(dynaForm, request, "list", "edit");
            this.addAlternateMessage(mapping, request, "error.notfound");
            return this.getAlternateForward(mapping, request);
        }
        this.populateCMSMenuObject(dynaForm, cmsMenu, request);
        sess.saveOrUpdate((Object)cmsMenu);
        sess.flush();
        String[] cmsMenuItemsAan = dynaForm.getStrings("cmsMenuItemsAan");
        for (int i = 0; i < cmsMenuItemsAan.length; ++i) {
            String cmsMenuItemId = cmsMenuItemsAan[i];
            CMSMenuItem item = (CMSMenuItem)sess.get(CMSMenuItem.class, (Serializable)new Integer(cmsMenuItemId));
            cmsMenu.addMenuItem(item);
        }
        sess.save((Object)cmsMenu);
        sess.flush();
        this.populateCMSMenuForm(cmsMenu, dynaForm, request);
        this.prepareMethod(dynaForm, request, "edit", "list");
        this.addDefaultMessage(mapping, request, "acknowledgeMessages");
        return mapping.findForward("success");
    }

    public ActionForward delete(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!this.isTokenValid(request)) {
            this.prepareMethod(dynaForm, request, "edit", "list");
            this.addAlternateMessage(mapping, request, "error.token");
            return this.getAlternateForward(mapping, request);
        }
        Session sess = null;
        CMSMenu cmsMenu = null;
        try {
            sess = HibernateUtil.getSessionFactory().getCurrentSession();
            cmsMenu = this.getCMSMenu(dynaForm, false);
            if (cmsMenu == null) {
                this.prepareMethod(dynaForm, request, "list", "edit");
                this.addAlternateMessage(mapping, request, "error.notfound");
                return this.getAlternateForward(mapping, request);
            }
            sess.delete((Object)cmsMenu);
            sess.flush();
        }
        catch (Exception ex) {
            logger.error((Object)("Fout tijdens verwijderen van cms menu " + cmsMenu.getTitel()), (Throwable)ex);
            this.prepareMethod(dynaForm, request, "list", "edit");
            this.addAlternateMessage(mapping, request, "error.exception");
            return this.getAlternateForward(mapping, request);
        }
        CMSMenu menu = this.getFirstCMSMenu();
        if (menu != null) {
            this.populateCMSMenuForm(menu, dynaForm, request);
        } else {
            dynaForm.initialize(mapping);
        }
        this.prepareMethod(dynaForm, request, "edit", "list");
        this.addDefaultMessage(mapping, request, "acknowledgeMessages");
        return mapping.findForward("success");
    }

    private void populateCMSMenuForm(CMSMenu cmsMenu, DynaValidatorForm dynaForm, HttpServletRequest request) {
        if (cmsMenu == null) {
            return;
        }
        Integer menuId = cmsMenu.getId();
        dynaForm.set("cmsMenuID", (Object)menuId);
        dynaForm.set("titel", (Object)cmsMenu.getTitel());
        request.setAttribute("cmsMenuItems", this.getAllCMSMenuItems());
        ArrayList<String> cmsMenuItemsAan = new ArrayList<String>();
        List<CMSMenuItem> currentItems = this.getCurrentCMSMenuItems(menuId);
        for (CMSMenuItem menuItem : this.getAllCMSMenuItems()) {
            if (!currentItems.contains(menuItem)) continue;
            cmsMenuItemsAan.add(menuItem.getId().toString());
        }
        dynaForm.set("cmsMenuItemsAan", (Object)cmsMenuItemsAan.toArray(new String[cmsMenuItemsAan.size()]));
    }

    private List<CMSMenuItem> getAllCMSMenuItems() {
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        return sess.createQuery("from CMSMenuItem order by volgordenr").list();
    }

    private void populateCMSMenuObject(DynaValidatorForm dynaForm, CMSMenu cmsMenu, HttpServletRequest request) {
        Integer id = (Integer)dynaForm.get("cmsMenuID");
        if (id != null && id != 0) {
            cmsMenu.setId(id);
        }
        cmsMenu.setTitel(FormUtils.nullIfEmpty((String)dynaForm.getString("titel")));
        cmsMenu.setCdate(new Date());
    }

    private List<CMSMenuItem> getCurrentCMSMenuItems(Integer menuId) {
        List<Object> menuItems = new ArrayList<CMSMenuItem>();
        if (menuId == null || menuId < 1) {
            return menuItems;
        }
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        menuItems = sess.createQuery("select item from CMSMenuItem item where item.id in (select cmsMenuItems.id from CMSMenu menu inner join menu.cmsMenuItems cmsMenuItems where menu.id = :menuId) order by item.volgordenr DESC").setParameter("menuId", (Object)menuId).list();
        return menuItems;
    }
}

