/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.gis.viewer;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nl.b3p.commons.services.FormUtils;
import nl.b3p.commons.struts.ExtendedMethodProperties;
import nl.b3p.gis.viewer.ViewerCrudAction;
import nl.b3p.gis.viewer.db.UserService;
import nl.b3p.gis.viewer.services.GisPrincipal;
import nl.b3p.gis.viewer.services.HibernateUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.validator.DynaValidatorForm;
import org.hibernate.classic.Session;

public class ConfigUserWMSList
extends ViewerCrudAction {
    private static final Log log = LogFactory.getLog(ConfigUserWMSList.class);
    protected static final String MAPPING_COPY = "copy";

    protected Map getActionMethodPropertiesMap() {
        Map map = super.getActionMethodPropertiesMap();
        ExtendedMethodProperties crudProp = null;
        crudProp = new ExtendedMethodProperties(MAPPING_COPY);
        crudProp.setDefaultForwardName("success");
        crudProp.setDefaultMessageKey("message.applicatie.copy.success");
        crudProp.setAlternateForwardName("failure");
        crudProp.setAlternateMessageKey("message.applicatie.copy.failed");
        map.put(MAPPING_COPY, crudProp);
        return map;
    }

    public ActionForward unspecified(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.prepareMethod(dynaForm, request, "edit", "list");
        this.addDefaultMessage(mapping, request, "acknowledgeMessages");
        return mapping.findForward("success");
    }

    protected void createLists(DynaValidatorForm form, HttpServletRequest request) throws Exception {
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        List services = sess.createQuery("from UserService where use_in_list = :uselist order by name").setParameter("uselist", (Object)true).list();
        if (services != null && services.size() > 0) {
            request.setAttribute("services", (Object)services);
        }
    }

    public ActionForward save(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!this.isTokenValid(request)) {
            this.addAlternateMessage(mapping, request, "error.token");
            return this.getAlternateForward(mapping, request);
        }
        UserService service = this.getService(dynaForm, request);
        if (service == null) {
            service = new UserService();
            this.populateObject(dynaForm, service, request);
        } else {
            this.populateObject(dynaForm, service, request);
        }
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        sess.saveOrUpdate((Object)service);
        sess.flush();
        this.populateForm(service, dynaForm, request);
        this.prepareMethod(dynaForm, request, "edit", "list");
        this.addDefaultMessage(mapping, request, "acknowledgeMessages");
        return mapping.findForward("success");
    }

    public ActionForward edit(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        UserService service = this.getService(dynaForm, request);
        this.populateForm(service, dynaForm, request);
        this.prepareMethod(dynaForm, request, "edit", "list");
        this.addDefaultMessage(mapping, request, "acknowledgeMessages");
        return this.getDefaultForward(mapping, request);
    }

    public ActionForward delete(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!this.isTokenValid(request)) {
            this.addAlternateMessage(mapping, request, "error.token");
            return this.getAlternateForward(mapping, request);
        }
        UserService service = this.getService(dynaForm, request);
        if (service != null) {
            Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
            sess.delete((Object)service);
            sess.flush();
        }
        dynaForm.initialize(mapping);
        this.prepareMethod(dynaForm, request, "list", "edit");
        this.addDefaultMessage(mapping, request, "acknowledgeMessages");
        return this.getDefaultForward(mapping, request);
    }

    private UserService getService(DynaValidatorForm dynaForm, HttpServletRequest request) {
        Integer id = (Integer)dynaForm.get("serviceId");
        if (id == null || id < 1) {
            return null;
        }
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        UserService service = (UserService)sess.get(UserService.class, (Serializable)id);
        return service;
    }

    private void populateForm(UserService service, DynaValidatorForm dynaForm, HttpServletRequest request) {
        if (service == null) {
            return;
        }
        dynaForm.set("serviceId", (Object)service.getId());
        dynaForm.set("name", (Object)service.getName());
        dynaForm.set("groupname", (Object)service.getGroupname());
        dynaForm.set("url", (Object)service.getUrl());
        dynaForm.set("sld_url", (Object)service.getSld_url());
    }

    private void populateObject(DynaValidatorForm dynaForm, UserService service, HttpServletRequest request) {
        Integer id = (Integer)dynaForm.get("serviceId");
        if (id != null && id != 0) {
            service.setId(id);
        }
        GisPrincipal user = GisPrincipal.getGisPrincipal((HttpServletRequest)request);
        String beheerderCode = null;
        if (user != null) {
            beheerderCode = user.getCode();
        }
        if (beheerderCode != null && !beheerderCode.equals("")) {
            service.setCode(beheerderCode);
        } else {
            service.setCode("");
        }
        service.setUse_in_list(Boolean.valueOf(true));
        service.setName(FormUtils.nullIfEmpty((String)dynaForm.getString("name")));
        service.setGroupname(FormUtils.nullIfEmpty((String)dynaForm.getString("groupname")));
        service.setUrl(FormUtils.nullIfEmpty((String)dynaForm.getString("url")));
        service.setSld_url(FormUtils.nullIfEmpty((String)dynaForm.getString("sld_url")));
    }
}

