/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.gis.viewer.zoekconfiguratie;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nl.b3p.commons.services.FormUtils;
import nl.b3p.gis.viewer.ConfigZoekConfiguratieAction;
import nl.b3p.gis.viewer.ViewerCrudAction;
import nl.b3p.gis.viewer.services.HibernateUtil;
import nl.b3p.zoeker.configuratie.Attribuut;
import nl.b3p.zoeker.configuratie.Bron;
import nl.b3p.zoeker.configuratie.ResultaatAttribuut;
import nl.b3p.zoeker.configuratie.ZoekAttribuut;
import nl.b3p.zoeker.configuratie.ZoekConfiguratie;
import nl.b3p.zoeker.services.Zoeker;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.validator.DynaValidatorForm;
import org.geotools.data.DataStore;
import org.hibernate.classic.Session;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;

public class ConfigZoekConfiguratieVeldAction
extends ViewerCrudAction {
    private static final Log logger = LogFactory.getLog(ConfigZoekConfiguratieAction.class);
    private static final String ZOEKATTRIBUUTID = "zoekAttribuutId";
    private static final String RESULTAATATTRIBUUTID = "resultaatAttribuutId";
    private static final String ATTRIBUUTTYPE = "attribuutType";

    public ActionForward unspecified(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        Attribuut attr = this.getAttribuut(request, false);
        if (attr != null) {
            this.populateForm(attr, dynaForm);
            if (attr instanceof ResultaatAttribuut) {
                request.setAttribute(ATTRIBUUTTYPE, (Object)"resultaat");
            } else {
                request.setAttribute(ATTRIBUUTTYPE, (Object)"zoek");
            }
            if (attr.getType() != null) {
                request.setAttribute("selType", (Object)attr.getType().toString());
            }
        } else {
            request.setAttribute(ATTRIBUUTTYPE, (Object)request.getParameter(ATTRIBUUTTYPE));
            request.setAttribute("zoekConfiguratieId", (Object)request.getParameter("zoekConfiguratieId"));
        }
        this.createLists(request);
        this.prepareMethod(dynaForm, request, "edit", "list");
        this.addDefaultMessage(mapping, request, "acknowledgeMessages");
        return mapping.findForward("success");
    }

    public ActionForward save(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Attribuut attr = this.populateObject(dynaForm, request);
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        sess.saveOrUpdate((Object)attr);
        sess.flush();
        request.setAttribute("doClose", (Object)true);
        this.prepareMethod(dynaForm, request, "list", "edit");
        this.addDefaultMessage(mapping, request, "acknowledgeMessages");
        return this.getDefaultForward(mapping, request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createLists(HttpServletRequest request) throws IOException, Exception {
        Attribuut a = this.getAttribuut(request, false);
        ZoekConfiguratie zc = null;
        if (a != null) {
            zc = a.getZoekConfiguratie();
        }
        if (zc == null) {
            zc = this.getZoekConfiguratie(request);
        }
        if (zc != null && zc.getBron() != null) {
            DataStore ds = Zoeker.getDataStore((Bron)zc.getBron());
            String ftype = zc.getFeatureType();
            SimpleFeatureType sft = null;
            try {
                sft = ds.getSchema(ftype);
            }
            catch (NullPointerException ex) {
                logger.error((Object)"NullPointerException bij ophalen schema van datastore: ");
            }
            finally {
                if (ds != null) {
                    ds.dispose();
                }
            }
            if (sft != null) {
                List descriptors = sft.getAttributeDescriptors();
                ArrayList<String[]> attributen = new ArrayList<String[]>();
                for (int i = 0; i < descriptors.size(); ++i) {
                    String[] attr = new String[]{((AttributeDescriptor)descriptors.get(i)).getName().toString(), ""};
                    if (((AttributeDescriptor)descriptors.get(i)).getType().getBinding() != null) {
                        String type = ((AttributeDescriptor)descriptors.get(i)).getType().getBinding().getName();
                        attr[1] = type = type.substring(type.lastIndexOf(".") + 1);
                    }
                    attributen.add(attr);
                }
                request.setAttribute("attribuutNamen", attributen);
            }
        }
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        List zoekConfigs = sess.createQuery("from ZoekConfiguratie").list();
        request.setAttribute("inputZoekConfigList", (Object)zoekConfigs);
    }

    private Attribuut populateObject(DynaValidatorForm dynaForm, HttpServletRequest request) {
        Attribuut attr = this.getAttribuut(request, true);
        attr.setAttribuutnaam(dynaForm.getString("attribuutnaam"));
        attr.setLabel(dynaForm.getString("label"));
        attr.setNaam(dynaForm.getString("naam"));
        if (FormUtils.nullIfEmpty((String)dynaForm.getString("type")) != null) {
            attr.setType(new Integer(dynaForm.getString("type")));
        }
        if (FormUtils.nullIfEmpty((String)dynaForm.getString("volgorde")) != null) {
            attr.setVolgorde(new Integer(dynaForm.getString("volgorde")));
        }
        if (FormUtils.nullIfEmpty((String)dynaForm.getString("inputtype")) != null && attr instanceof ZoekAttribuut) {
            ((ZoekAttribuut)attr).setInputtype(new Integer(dynaForm.getString("inputtype")));
        }
        if (FormUtils.nullIfEmpty((String)dynaForm.getString("inputsize")) != null && attr instanceof ZoekAttribuut) {
            ((ZoekAttribuut)attr).setInputsize(new Integer(dynaForm.getString("inputsize")));
        }
        if (FormUtils.nullIfEmpty((String)dynaForm.getString("inputzoekconfiguratie")) != null && attr instanceof ZoekAttribuut) {
            Integer inputZoekConfigId = new Integer(dynaForm.getString("inputzoekconfiguratie"));
            Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
            List zoekConfigs = sess.createQuery("from ZoekConfiguratie where id = :id").setParameter("id", (Object)inputZoekConfigId).list();
            if (zoekConfigs.size() == 1) {
                ((ZoekAttribuut)attr).setInputzoekconfiguratie((ZoekConfiguratie)zoekConfigs.get(0));
            }
        }
        if (FormUtils.nullIfEmpty((String)dynaForm.getString("inputzoekconfiguratie")) == null && attr instanceof ZoekAttribuut) {
            ((ZoekAttribuut)attr).setInputzoekconfiguratie(null);
        }
        if (attr.getId() == null) {
            ZoekConfiguratie zc = this.getZoekConfiguratie(request);
            attr.setZoekConfiguratie(zc);
        }
        attr.setDropDownValues(FormUtils.nullIfEmpty((String)dynaForm.getString("dropDownValues")));
        attr.setOmschrijving(FormUtils.nullIfEmpty((String)dynaForm.getString("omschrijving")));
        return attr;
    }

    private void populateForm(Attribuut a, DynaValidatorForm dynaForm) {
        if (a instanceof ZoekAttribuut) {
            dynaForm.set(ZOEKATTRIBUUTID, (Object)a.getId().toString());
        } else if (a instanceof ResultaatAttribuut) {
            dynaForm.set(RESULTAATATTRIBUUTID, (Object)a.getId().toString());
        }
        dynaForm.set("label", (Object)a.getLabel());
        dynaForm.set("naam", (Object)a.getNaam());
        if (a.getType() != null) {
            dynaForm.set("type", (Object)a.getType().toString());
        }
        if (a.getVolgorde() != null) {
            dynaForm.set("volgorde", (Object)a.getVolgorde().toString());
        }
        if (a instanceof ZoekAttribuut) {
            ZoekAttribuut za = (ZoekAttribuut)a;
            Integer inputtype = za.getInputtype();
            Integer inputsize = za.getInputsize();
            ZoekConfiguratie zc = za.getInputzoekconfiguratie();
            if (inputtype != null) {
                dynaForm.set("inputtype", (Object)inputtype.toString());
            }
            if (inputsize != null) {
                dynaForm.set("inputsize", (Object)inputsize.toString());
            }
            if (zc != null) {
                dynaForm.set("inputzoekconfiguratie", (Object)zc.getId().toString());
            }
        }
        dynaForm.set("attribuutnaam", (Object)a.getAttribuutnaam());
        if (a.getOmschrijving() != null) {
            dynaForm.set("omschrijving", (Object)a.getOmschrijving());
        }
        if (a.getDropDownValues() != null) {
            dynaForm.set("dropDownValues", (Object)a.getDropDownValues());
        }
    }

    private Attribuut getAttribuut(HttpServletRequest request, boolean createNew) {
        ZoekAttribuut attribuut = null;
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        if (FormUtils.nullIfEmpty((String)request.getParameter(ZOEKATTRIBUUTID)) != null) {
            Integer id = new Integer(request.getParameter(ZOEKATTRIBUUTID));
            attribuut = (ZoekAttribuut)sess.get(ZoekAttribuut.class, (Serializable)id);
        } else if (FormUtils.nullIfEmpty((String)request.getParameter(RESULTAATATTRIBUUTID)) != null) {
            Integer id = new Integer(request.getParameter(RESULTAATATTRIBUUTID));
            attribuut = (ResultaatAttribuut)sess.get(ResultaatAttribuut.class, (Serializable)id);
        } else if (createNew) {
            if ("zoek".equalsIgnoreCase(request.getParameter(ATTRIBUUTTYPE))) {
                return new ZoekAttribuut();
            }
            return new ResultaatAttribuut();
        }
        return attribuut;
    }

    private ZoekConfiguratie getZoekConfiguratie(HttpServletRequest request) {
        String zid = request.getParameter("zoekConfiguratieId");
        if (zid != null) {
            Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
            ZoekConfiguratie zc = (ZoekConfiguratie)sess.get(ZoekConfiguratie.class, (Serializable)new Integer(zid));
            return zc;
        }
        return null;
    }
}

