/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.gis.viewer;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nl.b3p.commons.services.FormUtils;
import nl.b3p.commons.struts.ExtendedMethodProperties;
import nl.b3p.gis.utils.ConfigListsUtil;
import nl.b3p.gis.viewer.ViewerCrudAction;
import nl.b3p.gis.viewer.db.Gegevensbron;
import nl.b3p.gis.viewer.db.ThemaData;
import nl.b3p.gis.viewer.services.GisPrincipal;
import nl.b3p.gis.viewer.services.HibernateUtil;
import nl.b3p.zoeker.configuratie.Bron;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.validator.DynaValidatorForm;
import org.hibernate.classic.Session;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ConfigGegevensbronAction
extends ViewerCrudAction {
    private static final Log logger = LogFactory.getLog(ConfigGegevensbronAction.class);
    protected static final String HASTHEMAS_ERROR_KEY = "error.hasthemas";
    protected static final String HASCHILDGEGVNBRON_ERROR_KEY = "error.haschildgb";
    protected static final String ERROR_ISPARENT = "error.gb.isparent";
    public static final String GEGEVENSBRONID = "gegevensbronID";
    protected static final String MAPPING_COPY = "copy";

    protected Map getActionMethodPropertiesMap() {
        Map map = super.getActionMethodPropertiesMap();
        ExtendedMethodProperties crudProp = null;
        crudProp = new ExtendedMethodProperties(MAPPING_COPY);
        crudProp.setDefaultForwardName("success");
        crudProp.setDefaultMessageKey("message.gegevensbron.copy.success");
        crudProp.setAlternateForwardName("failure");
        crudProp.setAlternateMessageKey("message.gegevensbron.copy.failed");
        map.put(MAPPING_COPY, crudProp);
        return map;
    }

    public ActionForward copy(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!this.isTokenValid(request)) {
            this.prepareMethod(dynaForm, request, "edit", "list");
            this.addAlternateMessage(mapping, request, "error.token");
            return this.getAlternateForward(mapping, request);
        }
        ActionErrors errors = dynaForm.validate(mapping, request);
        if (!errors.isEmpty()) {
            this.addMessages(request, (ActionMessages)errors);
            this.prepareMethod(dynaForm, request, "edit", "list");
            this.addAlternateMessage(mapping, request, "error.validation");
            return this.getAlternateForward(mapping, request);
        }
        Gegevensbron gb = this.getGegevensbron(dynaForm, true);
        if (gb == null) {
            this.prepareMethod(dynaForm, request, "list", "edit");
            this.addAlternateMessage(mapping, request, "error.notfound");
            return this.getAlternateForward(mapping, request);
        }
        Gegevensbron kopie = new Gegevensbron();
        kopie.setNaam(gb.getNaam() + " kopie");
        kopie.setBron(gb.getBron());
        kopie.setAdmin_tabel(gb.getAdmin_tabel());
        kopie.setAdmin_pk(gb.getAdmin_pk());
        kopie.setEditable(gb.isEditable());
        if (gb.getVolgordenr() != null && gb.getVolgordenr() > 0) {
            kopie.setVolgordenr(Integer.valueOf(gb.getVolgordenr() + 10));
        } else {
            kopie.setVolgordenr(new Integer(10));
        }
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        sess.save((Object)kopie);
        sess.flush();
        List themaDataItems = sess.createQuery("from ThemaData where gegevensbron = :bron").setParameter("bron", (Object)gb).list();
        if (themaDataItems != null && themaDataItems.size() > 0) {
            for (ThemaData item : themaDataItems) {
                ThemaData clone = (ThemaData)item.clone();
                clone.setGegevensbron(kopie);
                sess.save((Object)clone);
                sess.flush();
            }
        }
        this.populateGegevensbronForm(kopie, dynaForm, request);
        this.prepareMethod(dynaForm, request, "list", "edit");
        this.addDefaultMessage(mapping, request, "acknowledgeMessages");
        return this.getDefaultForward(mapping, request);
    }

    protected Gegevensbron getGegevensbron(DynaValidatorForm form, boolean createNew) {
        Integer id = FormUtils.StringToInteger((String)form.getString(GEGEVENSBRONID));
        Gegevensbron gb = null;
        if (id == null && createNew) {
            gb = new Gegevensbron();
        } else if (id != null) {
            Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
            gb = (Gegevensbron)sess.get(Gegevensbron.class, (Serializable)id);
        }
        return gb;
    }

    protected Gegevensbron getFirstGegevensbron() {
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        List cs = sess.createQuery("from Gegevensbron order by naam").setMaxResults(1).list();
        if (cs != null && cs.size() > 0) {
            return (Gegevensbron)cs.get(0);
        }
        return null;
    }

    protected void createLists(DynaValidatorForm form, HttpServletRequest request) throws Exception {
        super.createLists(form, request);
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        List gegevensbronnen = sess.createQuery("from Gegevensbron order by volgordenr, naam").list();
        request.setAttribute("alleGegevensbronnen", (Object)gegevensbronnen);
        List bronnen = sess.createQuery("from Bron order by naam").list();
        request.setAttribute("listBronnen", (Object)bronnen);
        List tns = new ArrayList();
        Bron b = null;
        GisPrincipal user = GisPrincipal.getGisPrincipal((HttpServletRequest)request);
        String tmp = form.getString("bron");
        Integer bronId = null;
        if (tmp != null) {
            try {
                bronId = new Integer(tmp);
            }
            catch (NumberFormatException nfe) {
                logger.debug((Object)"NumberFormatException: No bronid found in Gegevensbron form.");
            }
        }
        try {
            b = ConfigListsUtil.getBron((org.hibernate.Session)sess, (GisPrincipal)user, bronId);
            tns = ConfigListsUtil.getPossibleFeatures((Bron)b);
        }
        catch (RuntimeException uhe) {
            logger.error((Object)("Gegevensbron " + b.getNaam() + " has an unknown host. Connection url: " + b.getUrl()));
        }
        catch (Exception e) {
            logger.error((Object)("Exception occured creating gegevensbron list: " + e));
        }
        request.setAttribute("listTables", tns);
        String adminTable = null;
        adminTable = FormUtils.nullIfEmpty((String)form.getString("admin_tabel"));
        Gegevensbron gb = this.getGegevensbron(form, false);
        if (adminTable == null && gb != null) {
            adminTable = gb.getAdmin_tabel();
        }
        if (adminTable != null) {
            List atc = ConfigListsUtil.getPossibleAttributes((Bron)b, (String)adminTable);
            request.setAttribute("listAdminTableColumns", (Object)atc);
        }
        request.setAttribute("tree", (Object)this.createJasonObject().toString());
    }

    protected JSONObject createJasonObject() throws JSONException, Exception {
        JSONObject root = new JSONObject();
        root.put("id", (Object)"0");
        root.put("title", (Object)"root");
        root.put("name", (Object)"root");
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        List ctl = sess.createQuery("from Gegevensbron order by volgordenr, naam").list();
        Map rootGbMap = this.getGegevensbronMap(ctl, null);
        List gbMaps = (List)rootGbMap.get("subbronnen");
        root.put("children", (Object)this.getSubBronnen(gbMaps, null));
        return root;
    }

    private JSONArray getSubBronnen(List subBronnen, JSONArray bronnenArray) throws JSONException {
        if (subBronnen == null) {
            return bronnenArray;
        }
        for (Map clMap : subBronnen) {
            Gegevensbron gb = (Gegevensbron)clMap.get("gegevensbron");
            JSONObject jsonGb = new JSONObject();
            jsonGb.put("id", gb.getId().intValue());
            jsonGb.put("title", (Object)gb.getNaam());
            jsonGb.put("name", (Object)gb.getNaam());
            jsonGb.put("volgorde", (Object)gb.getVolgordenr());
            List subsubMaps = (List)clMap.get("subbronnen");
            if (subsubMaps != null && !subsubMaps.isEmpty()) {
                JSONArray childrenArray = new JSONArray();
                childrenArray = this.getSubBronnen(subsubMaps, childrenArray);
                jsonGb.put("children", (Object)childrenArray);
            }
            if (bronnenArray == null) {
                bronnenArray = new JSONArray();
            }
            bronnenArray.put((Object)jsonGb);
        }
        return bronnenArray;
    }

    private Map getGegevensbronMap(List gbList, Gegevensbron rootGb) throws JSONException, Exception {
        if (gbList == null) {
            return null;
        }
        ArrayList<Map> subBronnen = null;
        for (Gegevensbron gb : gbList) {
            Map gbMap;
            if (rootGb != gb.getParent() || (gbMap = this.getGegevensbronMap(gbList, gb)) == null || gbMap.isEmpty()) continue;
            if (subBronnen == null) {
                subBronnen = new ArrayList<Map>();
            }
            subBronnen.add(gbMap);
        }
        HashMap gbNode = new HashMap();
        gbNode.put("subbronnen", subBronnen);
        gbNode.put("gegevensbron", rootGb);
        return gbNode;
    }

    public ActionForward unspecified(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Gegevensbron gb = this.getGegevensbron(dynaForm, false);
        if (gb == null) {
            gb = this.getFirstGegevensbron();
        }
        this.populateGegevensbronForm(gb, dynaForm, request);
        this.prepareMethod(dynaForm, request, "edit", "list");
        this.addDefaultMessage(mapping, request, "acknowledgeMessages");
        return mapping.findForward("success");
    }

    public ActionForward edit(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Gegevensbron gb = this.getGegevensbron(dynaForm, false);
        if (gb == null) {
            gb = this.getFirstGegevensbron();
        }
        this.populateGegevensbronForm(gb, dynaForm, request);
        this.prepareMethod(dynaForm, request, "edit", "list");
        this.addDefaultMessage(mapping, request, "acknowledgeMessages");
        return this.getDefaultForward(mapping, request);
    }

    public ActionForward save(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!this.isTokenValid(request)) {
            this.prepareMethod(dynaForm, request, "edit", "list");
            this.addAlternateMessage(mapping, request, "error.token");
            return this.getAlternateForward(mapping, request);
        }
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        ActionErrors errors = dynaForm.validate(mapping, request);
        if (!errors.isEmpty()) {
            this.addMessages(request, (ActionMessages)errors);
            this.prepareMethod(dynaForm, request, "edit", "list");
            this.addAlternateMessage(mapping, request, "error.validation");
            return this.getAlternateForward(mapping, request);
        }
        Gegevensbron gb = this.getGegevensbron(dynaForm, true);
        if (gb == null) {
            this.prepareMethod(dynaForm, request, "list", "edit");
            this.addAlternateMessage(mapping, request, "error.notfound");
            return this.getAlternateForward(mapping, request);
        }
        String parentIdString = FormUtils.nullIfEmpty((String)dynaForm.getString("parentID"));
        if (parentIdString != null) {
            int parentId = 0;
            try {
                parentId = Integer.parseInt(dynaForm.getString("parentID"));
            }
            catch (NumberFormatException ex) {
                logger.error((Object)"Illegal parent id", (Throwable)ex);
            }
            if (parentId > 0) {
                int rootId = this.getRootParentId(parentId);
                if (gb.getId() != null && gb.getId() == rootId) {
                    this.prepareMethod(dynaForm, request, "list", "edit");
                    this.addAlternateMessage(mapping, request, ERROR_ISPARENT);
                    return this.getAlternateForward(mapping, request);
                }
            }
        }
        this.populateGegevensbronObject(dynaForm, gb, request);
        sess.saveOrUpdate((Object)gb);
        sess.flush();
        sess.refresh((Object)gb);
        this.populateGegevensbronForm(gb, dynaForm, request);
        this.prepareMethod(dynaForm, request, "list", "edit");
        this.addDefaultMessage(mapping, request, "acknowledgeMessages");
        return this.getDefaultForward(mapping, request);
    }

    private int getRootParentId(int id) {
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        Gegevensbron gb = (Gegevensbron)sess.get(Gegevensbron.class, (Serializable)Integer.valueOf(id));
        if (gb.getParent() != null) {
            return this.getRootParentId(gb.getParent().getId());
        }
        return gb.getId();
    }

    public ActionForward delete(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!this.isTokenValid(request)) {
            this.prepareMethod(dynaForm, request, "edit", "list");
            this.addAlternateMessage(mapping, request, "error.token");
            return this.getAlternateForward(mapping, request);
        }
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        Gegevensbron gb = this.getGegevensbron(dynaForm, false);
        if (gb == null) {
            this.prepareMethod(dynaForm, request, "list", "edit");
            this.addAlternateMessage(mapping, request, "error.notfound");
            return this.getAlternateForward(mapping, request);
        }
        int themaSize = 0;
        if (gb.getThemas() != null) {
            themaSize = gb.getThemas().size();
        }
        int childrenSize = 0;
        if (gb.getChildren() != null) {
            childrenSize = gb.getChildren().size();
        }
        if (themaSize > 0) {
            this.prepareMethod(dynaForm, request, "list", "edit");
            this.addAlternateMessage(mapping, request, HASTHEMAS_ERROR_KEY);
            return this.getAlternateForward(mapping, request);
        }
        if (childrenSize > 0) {
            this.prepareMethod(dynaForm, request, "list", "edit");
            this.addAlternateMessage(mapping, request, HASCHILDGEGVNBRON_ERROR_KEY);
            return this.getAlternateForward(mapping, request);
        }
        sess.delete((Object)gb);
        sess.flush();
        Gegevensbron gBron = this.getFirstGegevensbron();
        if (gBron != null) {
            this.populateGegevensbronForm(gBron, dynaForm, request);
        } else {
            dynaForm.initialize(mapping);
        }
        this.prepareMethod(dynaForm, request, "list", "edit");
        this.addDefaultMessage(mapping, request, "acknowledgeMessages");
        return this.getDefaultForward(mapping, request);
    }

    private void populateGegevensbronForm(Gegevensbron gb, DynaValidatorForm dynaForm, HttpServletRequest request) {
        if (gb == null) {
            return;
        }
        dynaForm.set(GEGEVENSBRONID, (Object)Integer.toString(gb.getId()));
        dynaForm.set("naam", (Object)gb.getNaam());
        String valBron = "-1";
        String adminTable = gb.getAdmin_tabel();
        if (adminTable != null && adminTable.length() > 0) {
            valBron = "0";
            if (gb.getBron() != null) {
                valBron = Integer.toString(gb.getBron().getId());
            }
        }
        dynaForm.set("bron", (Object)valBron);
        dynaForm.set("admin_tabel", (Object)gb.getAdmin_tabel());
        dynaForm.set("admin_pk", (Object)gb.getAdmin_pk());
        String val = "";
        if (gb.getParent() != null) {
            val = Integer.toString(gb.getParent().getId());
        }
        dynaForm.set("parentID", (Object)val);
        dynaForm.set("admin_fk", (Object)gb.getAdmin_fk());
        dynaForm.set("admin_query", (Object)gb.getAdmin_query());
        dynaForm.set("admin_tabel_opmerkingen", (Object)gb.getAdmin_tabel_opmerkingen());
        dynaForm.set("editable", (Object)gb.isEditable());
        dynaForm.set("geometryeditable", (Object)gb.isGeometryeditable());
        if (gb.getVolgordenr() != null) {
            dynaForm.set("volgordenr", (Object)FormUtils.IntToString((int)gb.getVolgordenr()));
        }
    }

    private void populateGegevensbronObject(DynaValidatorForm dynaForm, Gegevensbron gb, HttpServletRequest request) {
        gb.setNaam(FormUtils.nullIfEmpty((String)dynaForm.getString("naam")));
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        Bron b = null;
        int bronId = -1;
        try {
            bronId = Integer.parseInt(dynaForm.getString("bron"));
        }
        catch (NumberFormatException nfe) {
            logger.debug((Object)("No bron id found in form, input: " + dynaForm.getString("bron")));
        }
        if (bronId > 0) {
            b = (Bron)sess.get(Bron.class, (Serializable)Integer.valueOf(bronId));
        }
        gb.setBron(b);
        gb.setAdmin_tabel(FormUtils.nullIfEmpty((String)dynaForm.getString("admin_tabel")));
        gb.setAdmin_pk(FormUtils.nullIfEmpty((String)dynaForm.getString("admin_pk")));
        String parentID = FormUtils.nullIfEmpty((String)dynaForm.getString("parentID"));
        if (parentID != null) {
            int mId = 0;
            try {
                mId = Integer.parseInt(dynaForm.getString("parentID"));
            }
            catch (NumberFormatException ex) {
                logger.error((Object)"Illegal parent id", (Throwable)ex);
            }
            Gegevensbron m = (Gegevensbron)sess.get(Gegevensbron.class, (Serializable)new Integer(mId));
            gb.setParent(m);
        } else {
            gb.setParent(null);
        }
        if (dynaForm.getString("volgordenr") != null && dynaForm.getString("volgordenr").length() > 0) {
            gb.setVolgordenr(Integer.valueOf(Integer.parseInt(dynaForm.getString("volgordenr"))));
        } else {
            gb.setVolgordenr(null);
        }
        gb.setAdmin_fk(FormUtils.nullIfEmpty((String)dynaForm.getString("admin_fk")));
        gb.setAdmin_query(FormUtils.nullIfEmpty((String)dynaForm.getString("admin_query")));
        gb.setAdmin_tabel_opmerkingen(FormUtils.nullIfEmpty((String)dynaForm.getString("admin_tabel_opmerkingen")));
        Boolean editable = (Boolean)dynaForm.get("editable");
        gb.setEditable(editable == null ? false : editable);
        Boolean geometryeditable = (Boolean)dynaForm.get("geometryeditable");
        gb.setGeometryeditable(geometryeditable == null ? false : geometryeditable);
    }
}

