/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.gis.viewer;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import nl.b3p.commons.services.FormUtils;
import nl.b3p.commons.struts.ExtendedMethodProperties;
import nl.b3p.gis.viewer.ViewerCrudAction;
import nl.b3p.gis.viewer.db.Clusters;
import nl.b3p.gis.viewer.db.Gegevensbron;
import nl.b3p.gis.viewer.db.Themas;
import nl.b3p.gis.viewer.services.GisPrincipal;
import nl.b3p.gis.viewer.services.HibernateUtil;
import nl.b3p.gis.viewer.services.SpatialUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.validator.DynaValidatorForm;
import org.hibernate.classic.Session;

public class ConfigThemaAction
extends ViewerCrudAction {
    private static final Log logger = LogFactory.getLog(ConfigThemaAction.class);
    private static final String REFRESHLISTS = "refreshLists";

    protected Map getActionMethodPropertiesMap() {
        Map map = super.getActionMethodPropertiesMap();
        ExtendedMethodProperties crudProp = new ExtendedMethodProperties(REFRESHLISTS);
        crudProp.setDefaultForwardName("success");
        crudProp.setAlternateForwardName("failure");
        map.put(REFRESHLISTS, crudProp);
        return map;
    }

    public ActionForward refreshLists(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("success");
    }

    protected Themas getThema(DynaValidatorForm form, boolean createNew, Integer sessionThemaId) {
        Integer id = FormUtils.StringToInteger((String)form.getString("themaID"));
        if (sessionThemaId != null) {
            id = sessionThemaId;
        }
        Themas t = null;
        if (id == null && createNew) {
            t = new Themas();
        } else if (id != null) {
            Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
            t = (Themas)sess.get(Themas.class, (Serializable)id);
        }
        return t;
    }

    protected Themas getFirstThema() {
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        List cs = sess.createQuery("from Themas order by naam").setMaxResults(1).list();
        if (cs != null && cs.size() > 0) {
            return (Themas)cs.get(0);
        }
        return null;
    }

    protected void createLists(DynaValidatorForm dynaForm, HttpServletRequest request) throws Exception {
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        request.setAttribute("allThemas", (Object)sess.createQuery("from Themas order by naam").list());
        request.setAttribute("allClusters", (Object)sess.createQuery("from Clusters where default_cluster=:defaultCluster order by LOWER(naam) asc").setBoolean("defaultCluster", false).list());
        request.setAttribute("listValidGeoms", (Object)SpatialUtil.VALID_GEOMS);
        request.setAttribute("listBronnen", (Object)sess.createQuery("from Gegevensbron order by LOWER(naam) asc").list());
        HttpSession session = request.getSession(true);
        Integer sessionThemaId = (Integer)session.getAttribute("sessionThemaId");
        Themas t = null;
        t = sessionThemaId != null ? this.getThema(dynaForm, false, sessionThemaId) : this.getThema(dynaForm, false, null);
        GisPrincipal user = GisPrincipal.getGisPrincipal((HttpServletRequest)request);
        Integer cId = new Integer(-1);
        try {
            cId = new Integer(dynaForm.getString("gegevensbron"));
        }
        catch (NumberFormatException nfe) {
            logger.debug((Object)("No gegevensbron id found in form, input: " + dynaForm.getString("gegevensbron")));
        }
        if (user != null) {
            List lns = user.getLayers(false, true);
            request.setAttribute("listLayers", (Object)lns);
            List llns = new ArrayList();
            llns = user.getLayers(true, true);
            request.setAttribute("listLegendLayers", llns);
        }
    }

    public ActionForward unspecified(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession(true);
        Integer sessionThemaId = (Integer)session.getAttribute("sessionThemaId");
        Themas t = null;
        t = sessionThemaId != null ? this.getThema(dynaForm, false, sessionThemaId) : this.getThema(dynaForm, false, null);
        if (t == null) {
            t = this.getFirstThema();
        }
        this.populateThemasForm(t, dynaForm, request);
        this.prepareMethod(dynaForm, request, "edit", "list");
        this.addDefaultMessage(mapping, request, "acknowledgeMessages");
        return mapping.findForward("success");
    }

    public ActionForward edit(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Themas t = this.getThema(dynaForm, false, null);
        if (t == null) {
            t = this.getFirstThema();
        }
        if (t != null) {
            HttpSession session = request.getSession(true);
            session.setAttribute("sessionThemaId", (Object)t.getId());
        }
        this.populateThemasForm(t, dynaForm, request);
        this.prepareMethod(dynaForm, request, "edit", "list");
        this.addDefaultMessage(mapping, request, "acknowledgeMessages");
        return this.getDefaultForward(mapping, request);
    }

    public ActionForward save(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!this.isTokenValid(request)) {
            this.prepareMethod(dynaForm, request, "edit", "list");
            this.addAlternateMessage(mapping, request, "error.token");
            return this.getAlternateForward(mapping, request);
        }
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        ActionErrors errors = dynaForm.validate(mapping, request);
        if (!errors.isEmpty()) {
            this.addMessages(request, (ActionMessages)errors);
            this.prepareMethod(dynaForm, request, "edit", "list");
            this.addAlternateMessage(mapping, request, "error.validation");
            return this.getAlternateForward(mapping, request);
        }
        Themas t = this.getThema(dynaForm, true, null);
        if (t == null) {
            this.prepareMethod(dynaForm, request, "list", "edit");
            this.addAlternateMessage(mapping, request, "error.notfound");
            return this.getAlternateForward(mapping, request);
        }
        this.populateThemasObject(dynaForm, t, request);
        sess.saveOrUpdate((Object)t);
        sess.flush();
        sess.refresh((Object)t);
        this.populateThemasForm(t, dynaForm, request);
        this.prepareMethod(dynaForm, request, "list", "edit");
        this.addDefaultMessage(mapping, request, "acknowledgeMessages");
        return this.getDefaultForward(mapping, request);
    }

    public ActionForward delete(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!this.isTokenValid(request)) {
            this.prepareMethod(dynaForm, request, "edit", "list");
            this.addAlternateMessage(mapping, request, "error.token");
            return this.getAlternateForward(mapping, request);
        }
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        Themas t = this.getThema(dynaForm, false, null);
        if (t == null) {
            this.prepareMethod(dynaForm, request, "list", "edit");
            this.addAlternateMessage(mapping, request, "error.notfound");
            return this.getAlternateForward(mapping, request);
        }
        sess.delete((Object)t);
        sess.flush();
        Themas thema = this.getFirstThema();
        if (thema != null) {
            this.populateThemasForm(thema, dynaForm, request);
        } else {
            dynaForm.initialize(mapping);
        }
        this.prepareMethod(dynaForm, request, "list", "edit");
        this.addDefaultMessage(mapping, request, "acknowledgeMessages");
        return this.getDefaultForward(mapping, request);
    }

    private void populateThemasForm(Themas t, DynaValidatorForm dynaForm, HttpServletRequest request) {
        if (t == null) {
            return;
        }
        dynaForm.set("themaID", (Object)Integer.toString(t.getId()));
        dynaForm.set("themaCode", (Object)t.getCode());
        dynaForm.set("naam", (Object)t.getNaam());
        dynaForm.set("metadatalink", (Object)t.getMetadata_link());
        String valBron = "-1";
        Gegevensbron gb = t.getGegevensbron();
        if (gb != null) {
            valBron = Integer.toString(gb.getId());
        }
        dynaForm.set("gegevensbron", (Object)valBron);
        dynaForm.set("belangnr", (Object)FormUtils.IntToString((int)t.getBelangnr()));
        String valCluster = "";
        if (t.getCluster() != null) {
            valCluster = Integer.toString(t.getCluster().getId());
        }
        dynaForm.set("clusterID", (Object)valCluster);
        dynaForm.set("opmerkingen", (Object)t.getOpmerkingen());
        dynaForm.set("analyse_thema", (Object)t.isAnalyse_thema());
        dynaForm.set("locatie_thema", (Object)t.isLocatie_thema());
        dynaForm.set("wms_url", (Object)t.getWms_url());
        dynaForm.set("wms_layers", (Object)t.getWms_layers());
        dynaForm.set("wms_layers_real", (Object)t.getWms_layers_real());
        dynaForm.set("wms_querylayers", (Object)t.getWms_querylayers());
        dynaForm.set("wms_querylayers_real", (Object)t.getWms_querylayers_real());
        dynaForm.set("wms_legendlayer", (Object)t.getWms_legendlayer());
        dynaForm.set("wms_legendlayer_real", (Object)t.getWms_legendlayer_real());
        dynaForm.set("thema_maptip", (Object)t.getMaptipstring());
        dynaForm.set("update_frequentie_in_dagen", (Object)FormUtils.IntegerToString((Integer)t.getUpdate_frequentie_in_dagen()));
        dynaForm.set("view_geomtype", (Object)t.getView_geomtype());
        dynaForm.set("visible", (Object)t.isVisible());
        dynaForm.set("sldattribuut", (Object)t.getSldattribuut());
        dynaForm.set("uitgebreid", (Object)t.isUitgebreid());
        dynaForm.set("layoutadmindata", (Object)t.getLayoutadmindata());
        dynaForm.set("style", (Object)t.getStyle());
        dynaForm.set("info_tekst", (Object)t.getInfo_tekst());
    }

    private void populateThemasObject(DynaValidatorForm dynaForm, Themas t, HttpServletRequest request) {
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        t.setCode(FormUtils.nullIfEmpty((String)dynaForm.getString("themaCode")));
        t.setNaam(FormUtils.nullIfEmpty((String)dynaForm.getString("naam")));
        t.setMetadata_link(FormUtils.nullIfEmpty((String)dynaForm.getString("metadatalink")));
        Gegevensbron gb = null;
        int bronId = -1;
        try {
            bronId = Integer.parseInt(dynaForm.getString("gegevensbron"));
        }
        catch (NumberFormatException nfe) {
            logger.debug((Object)("No gegevensbron id found in form, input: " + dynaForm.getString("gegevensbron")));
        }
        if (bronId > 0) {
            gb = (Gegevensbron)sess.get(Gegevensbron.class, (Serializable)Integer.valueOf(bronId));
        }
        t.setGegevensbron(gb);
        if (dynaForm.getString("belangnr") != null && dynaForm.getString("belangnr").length() > 0) {
            t.setBelangnr(Integer.parseInt(dynaForm.getString("belangnr")));
        } else {
            t.setBelangnr(0);
        }
        t.setOpmerkingen(FormUtils.nullIfEmpty((String)dynaForm.getString("opmerkingen")));
        Boolean b = (Boolean)dynaForm.get("analyse_thema");
        t.setAnalyse_thema(b == null ? false : b);
        b = (Boolean)dynaForm.get("locatie_thema");
        t.setLocatie_thema(b == null ? false : b);
        t.setMaptipstring(FormUtils.nullIfEmpty((String)dynaForm.getString("thema_maptip")));
        t.setWms_url(FormUtils.nullIfEmpty((String)dynaForm.getString("wms_url")));
        t.setWms_layers(FormUtils.nullIfEmpty((String)dynaForm.getString("wms_layers")));
        t.setWms_layers_real(FormUtils.nullIfEmpty((String)dynaForm.getString("wms_layers_real")));
        t.setWms_querylayers(FormUtils.nullIfEmpty((String)dynaForm.getString("wms_querylayers")));
        t.setWms_querylayers_real(FormUtils.nullIfEmpty((String)dynaForm.getString("wms_querylayers_real")));
        t.setWms_legendlayer(FormUtils.nullIfEmpty((String)dynaForm.getString("wms_legendlayer")));
        t.setWms_legendlayer_real(FormUtils.nullIfEmpty((String)dynaForm.getString("wms_legendlayer_real")));
        t.setUpdate_frequentie_in_dagen(FormUtils.StringToInteger((String)dynaForm.getString("update_frequentie_in_dagen")));
        t.setView_geomtype(FormUtils.nullIfEmpty((String)dynaForm.getString("view_geomtype")));
        b = (Boolean)dynaForm.get("visible");
        t.setVisible(b == null ? false : b);
        t.setSldattribuut(FormUtils.nullIfEmpty((String)dynaForm.getString("sldattribuut")));
        b = (Boolean)dynaForm.get("uitgebreid");
        t.setUitgebreid(b == null ? false : b);
        t.setLayoutadmindata(FormUtils.nullIfEmpty((String)dynaForm.getString("layoutadmindata")));
        t.setStyle(FormUtils.nullIfEmpty((String)dynaForm.getString("style")));
        int cId = -1;
        try {
            cId = Integer.parseInt(dynaForm.getString("clusterID"));
        }
        catch (NumberFormatException ex) {
            logger.error((Object)"Illegal Cluster id", (Throwable)ex);
        }
        Clusters c = (Clusters)sess.get(Clusters.class, (Serializable)new Integer(cId));
        t.setCluster(c);
        t.setInfo_tekst(FormUtils.nullIfEmpty((String)dynaForm.getString("info_tekst")));
    }
}

