/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.geotools.data.csv;

import java.io.IOException;
import java.net.URL;
import nl.b3p.geotools.data.csv.CSVFeatureReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.data.AbstractFileDataStore;
import org.geotools.data.FeatureReader;
import org.geotools.data.Query;
import org.opengis.feature.simple.SimpleFeatureType;

public class CSVDataStore
extends AbstractFileDataStore {
    private static final Log log = LogFactory.getLog(CSVDataStore.class);
    private URL url;
    private String typename;
    private FeatureReader featureReader;
    private String srs;
    private char seperator;
    private int column_x;
    private int column_y;
    private boolean checkColumnCount;
    private String encoding;

    public CSVDataStore(URL url, String srs, boolean checkColumnCount, char seperator, int column_x, int column_y, String encoding) throws IOException {
        this.url = url;
        this.typename = CSVDataStore.getURLTypeName(url);
        this.srs = srs;
        this.seperator = seperator;
        this.column_x = column_x;
        this.column_y = column_y;
        this.checkColumnCount = checkColumnCount;
        this.encoding = encoding;
    }

    public String[] getTypeNames() throws IOException {
        return new String[]{CSVDataStore.getURLTypeName(this.url)};
    }

    static String getURLTypeName(URL url) throws IOException {
        String file = url.getFile();
        if (file.length() == 0) {
            return "unknown_csv";
        }
        int i = file.lastIndexOf(47);
        if (i != -1) {
            file = file.substring(i + 1);
        }
        if (file.toLowerCase().endsWith(".csv")) {
            file = file.substring(0, file.length() - 4);
        }
        return file;
    }

    public SimpleFeatureType getSchema(String typeName) throws IOException {
        return this.getSchema();
    }

    public SimpleFeatureType getSchema() throws IOException {
        return (SimpleFeatureType)this.getFeatureReader().getFeatureType();
    }

    public FeatureReader getFeatureReader(String typeName) throws IOException {
        return this.getFeatureReader();
    }

    public FeatureReader getFeatureReader() throws IOException {
        if (this.featureReader == null) {
            try {
                this.featureReader = new CSVFeatureReader(this.url, this.typename, this.srs, this.checkColumnCount, this.seperator, this.column_x, this.column_y, this.encoding);
            }
            catch (Exception e) {
                throw new IOException("CSV parse exception" + e.getLocalizedMessage());
            }
        }
        return this.featureReader;
    }

    protected int getCount(Query query) throws IOException {
        this.getFeatureReader();
        int count = 0;
        while (this.featureReader.hasNext()) {
            this.featureReader.next();
            ++count;
        }
        this.featureReader.close();
        this.featureReader = null;
        return count;
    }
}

