/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.geotools.data.csv;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import nl.b3p.commons.csv.CsvFormatException;
import nl.b3p.commons.csv.CsvInputStream;
import nl.b3p.geotools.data.csv.CSVDataStore;
import org.apache.commons.io.input.CountingInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.data.DataSourceException;
import org.geotools.data.FeatureReader;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.referencing.CRS;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.opengis.feature.IllegalAttributeException;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class CSVFeatureReader
implements FeatureReader {
    private static final Log LOG = LogFactory.getLog(CSVDataStore.class);
    private GeometryFactory gf;
    private SimpleFeatureType ft;
    private Map<String, String[]> metadata = new HashMap<String, String[]>();
    private SimpleFeature feature;
    private CsvInputStream inputstream;
    private int featureId = 0;
    private int column_x = -1;
    private int column_y = -1;
    private int remove_x = -1;
    private int remove_y = -1;
    private final char seperator;
    private final URL url;
    private final boolean checkColumnCount;
    private InputStreamReader inputStreamReader;
    private ListFeatureCollection collList;

    public CSVFeatureReader(URL url, String typeName, String srs, boolean checkColumnCount, char seperator, int column_x, int column_y, String encoding) throws IOException {
        CountingInputStream cis = new CountingInputStream(url.openStream());
        this.inputStreamReader = new InputStreamReader((InputStream)cis, encoding);
        this.inputstream = new CsvInputStream((Reader)this.inputStreamReader);
        this.inputstream.setCheckColumnCount(checkColumnCount);
        this.inputstream.setSeparator(seperator);
        this.seperator = seperator;
        this.url = url;
        this.checkColumnCount = checkColumnCount;
        if (column_x >= 0 && column_y >= 0) {
            this.column_x = column_x;
            this.column_y = column_y;
            if (column_x < column_y) {
                this.remove_x = column_x;
                this.remove_y = column_y - 1;
            } else if (column_x > column_y) {
                this.remove_x = column_x - 1;
                this.remove_y = column_y;
            } else {
                throw new IOException("X column and Y column have the same value.");
            }
        }
        this.createFeatureType(typeName, srs);
        this.gf = new GeometryFactory();
    }

    private void createFeatureType(String typeName, String srs) throws DataSourceException {
        this.collList = null;
        CoordinateReferenceSystem crs = null;
        String[] csMetadata = this.metadata.get("coordinatesystem");
        if (csMetadata != null) {
            String wkt = csMetadata[0];
            try {
                CRSFactory crsFactory = ReferencingFactoryFinder.getCRSFactory(null);
                crs = crsFactory.createFromWKT(wkt);
            }
            catch (Exception e) {
                throw new DataSourceException("Error parsing CoordinateSystem WKT: \"" + wkt + "\"");
            }
        }
        if (srs != null) {
            try {
                crs = CRS.decode((String)srs);
            }
            catch (Exception e) {
                throw new DataSourceException("Error parsing CoordinateSystem srs: \"" + srs + "\"");
            }
        }
        try {
            List columns = null;
            try {
                columns = this.inputstream.readRecordAsList();
            }
            catch (CsvFormatException e) {
                if (e.getMessage().contains(" but found ")) {
                    if (this.seperator == ',') {
                        this.inputStreamReader.close();
                        CountingInputStream cis = new CountingInputStream(this.url.openStream());
                        this.inputStreamReader = new InputStreamReader((InputStream)cis);
                        this.inputstream = new CsvInputStream((Reader)this.inputStreamReader);
                        this.inputstream.setCheckColumnCount(this.checkColumnCount);
                        this.inputstream.setSeparator(';');
                        columns = this.inputstream.readRecordAsList();
                    }
                }
                throw e;
            }
            SimpleFeatureTypeBuilder ftb = new SimpleFeatureTypeBuilder();
            if (columns.size() == 1) {
                String[] values = null;
                switch (this.seperator) {
                    case ',': {
                        values = ((String)columns.get(0)).split(";");
                        this.inputstream.setSeparator(';');
                        break;
                    }
                    case ';': {
                        values = ((String)columns.get(0)).split(",");
                        this.inputstream.setSeparator(',');
                        break;
                    }
                    default: {
                        throw new IOException("Please specify a seperator value, columncount returned 1");
                    }
                }
                if (values.length == 1) {
                    throw new IOException("Invalid septerator ',' & ';' didn't work");
                }
                columns = Arrays.asList(values);
            }
            ftb.setName(typeName);
            ftb.setCRS(crs);
            ftb.add("the_geom", Geometry.class);
            for (int i = 0; i < columns.size(); ++i) {
                if (i == this.column_x || i == this.column_y) continue;
                ftb.add(columns.get(i), String.class);
            }
            this.ft = ftb.buildFeatureType();
            LOG.debug((Object)("built featuretype: " + this.ft));
        }
        catch (Exception e) {
            throw new DataSourceException("Error creating SimpleFeatureType", (Throwable)e);
        }
    }

    public SimpleFeatureType getFeatureType() {
        return this.ft;
    }

    public SimpleFeature next() throws IOException, IllegalAttributeException, NoSuchElementException {
        return this.feature;
    }

    public boolean hasNext() throws IOException {
        try {
            List field = this.inputstream.readRecordAsList();
            if (field == null) {
                return false;
            }
            SimpleFeatureBuilder sfb = new SimpleFeatureBuilder(this.ft);
            if (this.column_x >= 0 && this.column_y >= 0) {
                Coordinate coordinate = new Coordinate(CSVFeatureReader.fixDecimals(field.get(this.column_x)).doubleValue(), CSVFeatureReader.fixDecimals(field.get(this.column_y)).doubleValue());
                field.remove(this.remove_x);
                field.remove(this.remove_y);
                sfb.add((Object)this.gf.createPoint(coordinate));
            } else {
                sfb.add((Object)this.gf.createPoint(new Coordinate(0.0, 0.0)));
            }
            sfb.addAll(field.toArray());
            this.feature = sfb.buildFeature(Integer.toString(this.featureId++));
            LOG.debug((Object)("Created feature: " + this.feature));
            return true;
        }
        catch (CsvFormatException e) {
            throw new IOException(e);
        }
    }

    public void close() throws IOException {
        this.inputStreamReader.close();
        this.collList = null;
    }

    private static Double fixDecimals(Object value2) {
        String value = value2.toString().trim();
        if (value.contains(",")) {
            if (value.contains(".")) {
                value = value.replaceAll("[.]", "");
            }
            value = value.replaceAll("[,]", ".");
        }
        return Double.parseDouble(value);
    }

    public SimpleFeatureCollection getFeatureCollection() throws IOException {
        if (this.collList == null || this.collList.isEmpty()) {
            LOG.debug((Object)"Creating feature collection");
            this.collList = new ListFeatureCollection(this.getFeatureType());
            while (this.hasNext()) {
                this.collList.add(this.next());
            }
        }
        return this.collList;
    }
}

