/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.geotools.data.csv;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import nl.b3p.geotools.data.csv.CSVFeatureReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.data.DefaultServiceInfo;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureWriter;
import org.geotools.data.FileDataStore;
import org.geotools.data.LockingManager;
import org.geotools.data.Query;
import org.geotools.data.ServiceInfo;
import org.geotools.data.Transaction;
import org.geotools.data.collection.CollectionFeatureSource;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.feature.NameImpl;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;

public class CSVDataStore
implements FileDataStore {
    private static final Log log = LogFactory.getLog(CSVDataStore.class);
    private URL url;
    private String typename;
    private FeatureReader featureReader;
    private String srs;
    private char seperator;
    private int column_x;
    private int column_y;
    private boolean checkColumnCount;
    private String encoding;

    public CSVDataStore(URL url, String srs, boolean checkColumnCount, char seperator, int column_x, int column_y, String encoding) throws IOException {
        this.url = url;
        this.typename = CSVDataStore.getURLTypeName(url);
        this.srs = srs;
        this.seperator = seperator;
        this.column_x = column_x;
        this.column_y = column_y;
        this.checkColumnCount = checkColumnCount;
        this.encoding = encoding;
    }

    public String[] getTypeNames() throws IOException {
        return new String[]{CSVDataStore.getURLTypeName(this.url)};
    }

    static String getURLTypeName(URL url) throws IOException {
        String file = url.getFile();
        if (file.length() == 0) {
            return "unknown_csv";
        }
        int i = file.lastIndexOf(47);
        if (i != -1) {
            file = file.substring(i + 1);
        }
        if (file.toLowerCase().endsWith(".csv")) {
            file = file.substring(0, file.length() - 4);
        }
        return file;
    }

    public List<Name> getNames() throws IOException {
        return Arrays.asList(new NameImpl(this.getSchema().getTypeName()));
    }

    public SimpleFeatureType getSchema(Name name) throws IOException {
        return this.getSchema();
    }

    public SimpleFeatureType getSchema(String typeName) throws IOException {
        return this.getSchema();
    }

    public SimpleFeatureType getSchema() throws IOException {
        return (SimpleFeatureType)this.getFeatureReader().getFeatureType();
    }

    public FeatureReader getFeatureReader(String typeName) throws IOException {
        return this.getFeatureReader();
    }

    public FeatureReader<SimpleFeatureType, SimpleFeature> getFeatureReader(Query query, Transaction t) throws IOException {
        return this.getFeatureReader();
    }

    public FeatureReader getFeatureReader() throws IOException {
        if (this.featureReader == null) {
            try {
                this.featureReader = new CSVFeatureReader(this.url, this.typename, this.srs, this.checkColumnCount, this.seperator, this.column_x, this.column_y, this.encoding);
            }
            catch (Exception e) {
                throw new IOException("CSV parse exception" + e.getLocalizedMessage());
            }
        }
        return this.featureReader;
    }

    protected int getCount(Query query) throws IOException {
        this.getFeatureReader();
        int count = 0;
        while (this.featureReader.hasNext()) {
            this.featureReader.next();
            ++count;
        }
        this.featureReader.close();
        this.featureReader = null;
        return count;
    }

    protected List<Name> createTypeNames() throws IOException {
        NameImpl typeName = new NameImpl(this.typename);
        return Collections.singletonList(typeName);
    }

    public SimpleFeatureSource getFeatureSource() throws IOException {
        return this.getFeatureSource(this.typename);
    }

    public SimpleFeatureSource getFeatureSource(String string) throws IOException {
        SimpleFeatureCollection collection = ((CSVFeatureReader)this.getFeatureReader(this.typename)).getFeatureCollection();
        return new CollectionFeatureSource(collection);
    }

    public SimpleFeatureSource getFeatureSource(Name name) throws IOException {
        return this.getFeatureSource(name.getLocalPart());
    }

    public void createSchema(SimpleFeatureType t) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateSchema(SimpleFeatureType sft) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateSchema(Name name, SimpleFeatureType t) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateSchema(String string, SimpleFeatureType sft) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void removeSchema(Name name) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void removeSchema(String string) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriter(Filter filter, Transaction t) throws IOException {
        throw new UnsupportedOperationException("Functie niet ondersteund voor alleen-lezen databron.");
    }

    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriter(Transaction t) throws IOException {
        throw new UnsupportedOperationException("Functie niet ondersteund voor alleen-lezen databron.");
    }

    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriterAppend(Transaction t) throws IOException {
        throw new UnsupportedOperationException("Functie niet ondersteund voor alleen-lezen databron.");
    }

    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriter(String string, Filter filter, Transaction t) throws IOException {
        throw new UnsupportedOperationException("Functie niet ondersteund voor alleen-lezen databron.");
    }

    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriter(String string, Transaction t) throws IOException {
        throw new UnsupportedOperationException("Functie niet ondersteund voor alleen-lezen databron.");
    }

    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriterAppend(String string, Transaction t) throws IOException {
        throw new UnsupportedOperationException("Functie niet ondersteund voor alleen-lezen databron.");
    }

    public LockingManager getLockingManager() {
        throw new UnsupportedOperationException("Functie niet ondersteund voor alleen-lezen databron.");
    }

    public ServiceInfo getInfo() {
        DefaultServiceInfo serviceInfo = new DefaultServiceInfo();
        serviceInfo.setTitle("CSV DataStore");
        try {
            serviceInfo.setSource(this.url.toURI());
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return serviceInfo;
    }

    public void dispose() {
        try {
            this.featureReader.close();
        }
        catch (IOException | NullPointerException exception) {
            // empty catch block
        }
        this.featureReader = null;
    }
}

