/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.geotools.data.csv;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import nl.b3p.geotools.data.csv.CSVDataStore;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.DataStore;
import org.geotools.data.FileDataStore;
import org.geotools.data.FileDataStoreFactorySpi;
import org.geotools.referencing.CRS;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;

public class CSVDataStoreFactory
implements FileDataStoreFactorySpi {
    public static final DataAccessFactory.Param PARAM_URL = new DataAccessFactory.Param("url", URL.class, "url to a .csv file");
    public static final DataAccessFactory.Param PARAM_SRS = new DataAccessFactory.Param("srs", String.class, "override srs");
    public static final DataAccessFactory.Param PARAM_CHECKCOLUMNCOUNT = new DataAccessFactory.Param("check_column_count", Boolean.class, "Check if columncount of a field is valid");
    public static final DataAccessFactory.Param PARAM_SEPERATOR = new DataAccessFactory.Param("seperator", String.class, "value separator");
    public static final DataAccessFactory.Param PARAM_COLUMN_X = new DataAccessFactory.Param("column_x", Integer.class, "X column to use for creating a point geometry");
    public static final DataAccessFactory.Param PARAM_COLUMN_Y = new DataAccessFactory.Param("column_y", Integer.class, "y column to use for creating a point geometry");
    public static final DataAccessFactory.Param PARAM_ENCODING = new DataAccessFactory.Param("encoding", String.class, "The encoding of the csv-file");

    public String getDisplayName() {
        return "CSV File";
    }

    public String getDescription() {
        return "Comma Seperated Values";
    }

    public String[] getFileExtensions() {
        return new String[]{".csv"};
    }

    public boolean canProcess(URL f) {
        return f.getFile().toLowerCase().endsWith(".csv");
    }

    public boolean canProcess(String srs) throws NoSuchAuthorityCodeException, FactoryException {
        return CRS.decode((String)srs) != null;
    }

    public boolean canProcess(Map params) {
        boolean result = false;
        if (params.containsKey(CSVDataStoreFactory.PARAM_URL.key)) {
            try {
                URL url = (URL)PARAM_URL.lookUp(params);
                result = this.canProcess(url);
            }
            catch (IOException url) {
                // empty catch block
            }
        }
        if (result && params.containsKey(CSVDataStoreFactory.PARAM_SRS.key)) {
            try {
                String srs = (String)PARAM_SRS.lookUp(params);
                result = this.canProcess(srs);
            }
            catch (NoSuchAuthorityCodeException noSuchAuthorityCodeException) {
            }
            catch (FactoryException factoryException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return result;
    }

    public boolean isAvailable() {
        return true;
    }

    public DataAccessFactory.Param[] getParametersInfo() {
        return new DataAccessFactory.Param[]{PARAM_URL};
    }

    public Map getImplementationHints() {
        return Collections.EMPTY_MAP;
    }

    public String getTypeName(URL url) throws IOException {
        return CSVDataStore.getURLTypeName(url);
    }

    public FileDataStore createDataStore(URL url) throws IOException {
        HashMap<String, URL> params = new HashMap<String, URL>();
        params.put(CSVDataStoreFactory.PARAM_URL.key, url);
        boolean isLocal = url.getProtocol().equalsIgnoreCase("file");
        if (isLocal && !new File(url.getFile()).exists()) {
            throw new UnsupportedOperationException("Specified CSV file \"" + url + "\" does not exist, this plugin is read-only so no new file will be created");
        }
        return this.createDataStore(params);
    }

    public FileDataStore createDataStore(Map params) throws IOException {
        char seperator;
        if (!this.canProcess(params)) {
            throw new FileNotFoundException("Unable to process CSV file: " + params);
        }
        URL url = (URL)params.get(CSVDataStoreFactory.PARAM_URL.key);
        String srs = (String)params.get(CSVDataStoreFactory.PARAM_SRS.key);
        char c = params.containsKey(CSVDataStoreFactory.PARAM_SEPERATOR.key) ? (((String)params.get(CSVDataStoreFactory.PARAM_SEPERATOR.key)).length() == 1 ? (char)((String)params.get(CSVDataStoreFactory.PARAM_SEPERATOR.key)).charAt(0) : (char)',') : (seperator = ',');
        boolean checkColumnCount = params.containsKey(CSVDataStoreFactory.PARAM_CHECKCOLUMNCOUNT.key) ? (params.get(CSVDataStoreFactory.PARAM_CHECKCOLUMNCOUNT.key) instanceof Boolean ? (Boolean)params.get(CSVDataStoreFactory.PARAM_CHECKCOLUMNCOUNT.key) : (params.get(CSVDataStoreFactory.PARAM_CHECKCOLUMNCOUNT.key) instanceof String ? ((String)params.get(CSVDataStoreFactory.PARAM_CHECKCOLUMNCOUNT.key)).toLowerCase().equals("true") : false)) : false;
        int column_x = params.containsKey(CSVDataStoreFactory.PARAM_COLUMN_X.key) ? (params.get(CSVDataStoreFactory.PARAM_COLUMN_X.key) instanceof Integer ? (Integer)params.get(CSVDataStoreFactory.PARAM_COLUMN_X.key) : (params.get(CSVDataStoreFactory.PARAM_COLUMN_X.key) instanceof String ? Integer.parseInt((String)params.get(CSVDataStoreFactory.PARAM_COLUMN_X.key)) : -1)) : -1;
        int column_y = params.containsKey(CSVDataStoreFactory.PARAM_COLUMN_Y.key) ? (params.get(CSVDataStoreFactory.PARAM_COLUMN_Y.key) instanceof Integer ? (Integer)params.get(CSVDataStoreFactory.PARAM_COLUMN_Y.key) : (params.get(CSVDataStoreFactory.PARAM_COLUMN_Y.key) instanceof String ? Integer.parseInt((String)params.get(CSVDataStoreFactory.PARAM_COLUMN_Y.key)) : -1)) : -1;
        String encoding = null;
        encoding = params.containsKey(CSVDataStoreFactory.PARAM_ENCODING.key) ? (params.get(CSVDataStoreFactory.PARAM_ENCODING.key) instanceof String ? (String)params.get(CSVDataStoreFactory.PARAM_ENCODING.key) : "ISO-8859-1") : "ISO-8859-1";
        return new CSVDataStore(url, srs, checkColumnCount, seperator, column_x, column_y, encoding);
    }

    public DataStore createNewDataStore(Map params) throws IOException {
        throw new UnsupportedOperationException("This plugin is read-only");
    }
}

