/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.geotools.data;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.Triangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum GeometryType {
    UNSUPPORTED(Class.class, "null"),
    ALL(Geometry.class, ""),
    POINT(Point.class, "_p"),
    LINE(LineString.class, "_l"),
    POLYGON(Polygon.class, "_v"),
    MULTIPOINT(MultiPoint.class, "_mp"),
    MULTILINE(MultiLineString.class, "_ml"),
    MULTIPOLYGON(MultiPolygon.class, "_mv"),
    COORDINATE(Coordinate.class, "_c"),
    TRIANGLE(Triangle.class, "_t");

    private Class geomId;
    private String extension;

    private GeometryType(Class geomId, String extension) {
        this.geomId = geomId;
        this.extension = extension;
    }

    public Class getGeometryClass() {
        return this.geomId;
    }

    public String getExtension() {
        return this.extension;
    }

    public static void setExtension(GeometryType type, String extension) {
        type.extension = extension;
    }

    public static String[] getTypeNames(String filename, GeometryType ... types) {
        ArrayList<GeometryType> extensionList;
        if (types.length == 0) {
            extensionList = new ArrayList<GeometryType>(Arrays.asList(GeometryType.values()));
            extensionList.remove((Object)ALL);
            extensionList.remove((Object)UNSUPPORTED);
        } else {
            extensionList = new ArrayList<GeometryType>(Arrays.asList(types));
        }
        String[] typeNames = new String[extensionList.size()];
        for (int i = 0; i < typeNames.length; ++i) {
            typeNames[i] = filename + extensionList.get(i).getExtension();
        }
        return typeNames;
    }

    public static Map getTypeNamesMap(String filename, GeometryType ... types) {
        ArrayList<GeometryType> extensionList;
        if (types.length == 0) {
            extensionList = new ArrayList<GeometryType>(Arrays.asList(GeometryType.values()));
            extensionList.remove((Object)ALL);
            extensionList.remove((Object)UNSUPPORTED);
        } else {
            extensionList = new ArrayList<GeometryType>(Arrays.asList(types));
        }
        HashMap<String, GeometryType> typenameMap = new HashMap<String, GeometryType>();
        for (int i = 0; i < extensionList.size(); ++i) {
            GeometryType geometryType = extensionList.get(i);
            String name = filename + geometryType.getExtension();
            typenameMap.put(name, geometryType);
        }
        return typenameMap;
    }

    public static Class getClassByExtension(String extension) {
        for (GeometryType geomType : GeometryType.values()) {
            if (!geomType.getExtension().equals(extension)) continue;
            return geomType.getGeometryClass();
        }
        return null;
    }

    public static String getExtensionByClass(Geometry typeClass) {
        for (GeometryType geomType : GeometryType.values()) {
            if (!geomType.getGeometryClass().equals(typeClass.getClass())) continue;
            return geomType.getExtension();
        }
        return null;
    }

    public static GeometryType getTypeByClass(Geometry typeClass) {
        for (GeometryType geomType : GeometryType.values()) {
            if (!geomType.getGeometryClass().equals(typeClass.getClass())) continue;
            return geomType;
        }
        return null;
    }

    public static GeometryType getTypeByExtension(String typeExtension) {
        for (GeometryType geomType : GeometryType.values()) {
            if (!geomType.getExtension().equals(typeExtension)) continue;
            return geomType;
        }
        return null;
    }

    public static String stripExtensionFromTypename(String typename, GeometryType type) {
        String ext = type.getExtension();
        if (typename.endsWith(ext)) {
            typename = typename.substring(0, typename.length() - ext.length());
        }
        return typename;
    }
}

