/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.geotools.data.dxf.entities;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import java.awt.geom.Point2D;
import java.io.EOFException;
import java.io.IOException;
import nl.b3p.geotools.data.GeometryType;
import nl.b3p.geotools.data.dxf.entities.DXFEntity;
import nl.b3p.geotools.data.dxf.header.DXFLayer;
import nl.b3p.geotools.data.dxf.parser.DXFCodeValuePair;
import nl.b3p.geotools.data.dxf.parser.DXFGroupCode;
import nl.b3p.geotools.data.dxf.parser.DXFLineNumberReader;
import nl.b3p.geotools.data.dxf.parser.DXFParseException;
import nl.b3p.geotools.data.dxf.parser.DXFUnivers;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DXFPoint
extends DXFEntity {
    private static final Log log = LogFactory.getLog(DXFPoint.class);
    public Point2D.Double _point = new Point2D.Double(0.0, 0.0);

    public DXFPoint(DXFPoint newPoint) {
        this(newPoint._point.x, newPoint._point.y, newPoint.getColor(), newPoint.getRefLayer(), 0, newPoint.getThickness());
        this.setType(newPoint.getType());
        this.setStartingLineNumber(newPoint.getStartingLineNumber());
        this.setUnivers(newPoint.getUnivers());
    }

    public DXFPoint(Point2D.Double p, int c, DXFLayer l, int visibility, float thickness) {
        super(c, l, visibility, null, thickness);
        if (p == null) {
            p = new Point2D.Double(0.0, 0.0);
        }
        this._point = p;
        this.setName("DXFPoint");
    }

    public DXFPoint(Point2D.Double p) {
        super(-1, null, 0, null, 1.0);
        if (p == null) {
            p = new Point2D.Double(0.0, 0.0);
        }
        this._point = p;
        this.setName("DXFPoint");
    }

    public DXFPoint() {
        super(-1, null, 0, null, 1.0);
        this.setName("DXFPoint");
    }

    public DXFPoint(double x, double y, int c, DXFLayer l, int visibility, double thickness) {
        super(c, l, visibility, null, 1.0);
        this._point = new Point2D.Double(x, y);
        this.setName("DXFPoint");
    }

    public void setX(double x) {
        this._point.x = x;
    }

    public void setY(double y) {
        this._point.y = y;
    }

    public double X() {
        return this._point.getX();
    }

    public double Y() {
        return this._point.getY();
    }

    public static DXFPoint read(DXFLineNumberReader br, DXFUnivers univers) throws NumberFormatException, IOException {
        DXFLayer l = null;
        int visibility = 0;
        int c = -1;
        double x = 0.0;
        double y = 0.0;
        double thickness = 0.0;
        int sln = br.getLineNumber();
        log.debug((Object)(">>Enter at line: " + sln));
        DXFCodeValuePair cvp = null;
        DXFGroupCode gc = null;
        boolean doLoop = true;
        block12: while (doLoop) {
            cvp = new DXFCodeValuePair();
            try {
                gc = cvp.read(br);
            }
            catch (DXFParseException ex) {
                throw new IOException("DXF parse error" + ex.getLocalizedMessage());
            }
            catch (EOFException e) {
                doLoop = false;
                break;
            }
            switch (gc) {
                case TYPE: {
                    String type = cvp.getStringValue();
                    br.reset();
                    doLoop = false;
                    continue block12;
                }
                case LAYER_NAME: {
                    l = univers.findLayer(cvp.getStringValue());
                    continue block12;
                }
                case X_1: {
                    x = cvp.getDoubleValue();
                    continue block12;
                }
                case Y_1: {
                    y = cvp.getDoubleValue();
                    continue block12;
                }
                case COLOR: {
                    c = cvp.getShortValue();
                    continue block12;
                }
                case VISIBILITY: {
                    visibility = cvp.getShortValue();
                    continue block12;
                }
                case THICKNESS: {
                    thickness = cvp.getDoubleValue();
                    continue block12;
                }
            }
        }
        DXFPoint e = new DXFPoint(x, y, c, l, visibility, thickness);
        e.setType(GeometryType.POINT);
        e.setStartingLineNumber(sln);
        e.setUnivers(univers);
        log.debug((Object)e.toString(x, y, visibility, c, thickness));
        log.debug((Object)(">>Exit at line: " + br.getLineNumber()));
        return e;
    }

    public Geometry getGeometry() {
        if (this.geometry == null) {
            this.updateGeometry();
        }
        return super.getGeometry();
    }

    public void updateGeometry() {
        this.geometry = this.getUnivers().getGeometryFactory().createPoint(this.toCoordinate());
    }

    public Coordinate toCoordinate() {
        if (this._point == null) {
            this.addError("coordinate can not be created.");
            return null;
        }
        return this.rotateAndPlace(new Coordinate(this._point.getX(), this._point.getY()));
    }

    public String toString(double x, double y, int visibility, int c, double thickness) {
        StringBuffer s = new StringBuffer();
        s.append("DXFPoint [");
        s.append("x: ");
        s.append(x + ", ");
        s.append("y: ");
        s.append(y + ", ");
        s.append("visibility: ");
        s.append(visibility + ", ");
        s.append("color: ");
        s.append(c + ", ");
        s.append("thickness: ");
        s.append(thickness);
        s.append("]");
        return s.toString();
    }

    public DXFEntity translate(double x, double y) {
        this._point.x += x;
        this._point.y += y;
        return this;
    }

    public DXFEntity clone() {
        return new DXFPoint(this);
    }
}

