/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.geotools.data.dxf.entities;

import java.io.EOFException;
import java.io.IOException;
import java.util.Vector;
import nl.b3p.geotools.data.GeometryType;
import nl.b3p.geotools.data.dxf.entities.DXFPoint;
import nl.b3p.geotools.data.dxf.entities.DXFPolyline;
import nl.b3p.geotools.data.dxf.entities.DXFVertex;
import nl.b3p.geotools.data.dxf.header.DXFLayer;
import nl.b3p.geotools.data.dxf.header.DXFLineType;
import nl.b3p.geotools.data.dxf.parser.DXFCodeValuePair;
import nl.b3p.geotools.data.dxf.parser.DXFGroupCode;
import nl.b3p.geotools.data.dxf.parser.DXFLineNumberReader;
import nl.b3p.geotools.data.dxf.parser.DXFParseException;
import nl.b3p.geotools.data.dxf.parser.DXFUnivers;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DXFSpLine
extends DXFPolyline {
    private static final Log log = LogFactory.getLog(DXFSpLine.class);
    public DXFPoint _a = new DXFPoint();
    public DXFPoint _b = new DXFPoint();

    public DXFSpLine(DXFPolyline newPolyLine) {
        super(newPolyLine);
        this.setName("DXFSpLine");
    }

    public DXFSpLine(String name, int flag, int c, DXFLayer l, Vector<DXFVertex> v, int visibility, DXFLineType lineType, double thickness) {
        super(name, flag, c, l, v, visibility, lineType, thickness);
        this.setName("DXFSpLine");
    }

    public static DXFSpLine read(DXFLineNumberReader br, DXFUnivers univers) throws IOException {
        DXFLayer l = null;
        boolean flag = false;
        int visibility = 0;
        int c = -1;
        String name = "";
        DXFLineType lineType = null;
        Vector<DXFVertex> lv = new Vector<DXFVertex>();
        int sln = br.getLineNumber();
        log.debug((Object)(">>Enter at line: " + sln));
        DXFCodeValuePair cvp = null;
        DXFGroupCode gc = null;
        boolean doLoop = true;
        block9: while (doLoop) {
            cvp = new DXFCodeValuePair();
            try {
                gc = cvp.read(br);
            }
            catch (DXFParseException ex) {
                throw new IOException("DXF parse error" + ex.getLocalizedMessage());
            }
            catch (EOFException e) {
                doLoop = false;
                break;
            }
            switch (gc) {
                case TYPE: {
                    br.reset();
                    doLoop = false;
                    continue block9;
                }
                case LAYER_NAME: {
                    l = univers.findLayer(cvp.getStringValue());
                    continue block9;
                }
                case X_1: {
                    double x = cvp.getDoubleValue();
                    lv.add(new DXFVertex(x, -1.0, 1.0, c, l, visibility));
                }
                case Y_1: {
                    int lastIndex = lv.size() - 1;
                    DXFVertex lastCoord = lv.get(lastIndex);
                    lastCoord.setY(cvp.getDoubleValue());
                    lv.set(lastIndex, lastCoord);
                    continue block9;
                }
            }
        }
        DXFSpLine e = new DXFSpLine(name, 4, c, l, lv, visibility, lineType, 1.0);
        e.setType(GeometryType.LINE);
        e.setStartingLineNumber(sln);
        e.setUnivers(univers);
        log.debug((Object)e.toString(lv.get(0).X(), lv.get(0).Y(), lv.get(lv.size() - 1).X(), lv.get(lv.size() - 1).Y(), c, visibility));
        log.debug((Object)(">Exit at line: " + br.getLineNumber()));
        return e;
    }

    public String toString(double x1, double y1, double x2, double y2, int c, int visibility) {
        StringBuffer s = new StringBuffer();
        s.append("DXFSpLine [");
        s.append("start x: ");
        s.append(x1 + ", ");
        s.append("start y: ");
        s.append(y1 + ", ");
        s.append("end x: ");
        s.append(x2 + ", ");
        s.append("end y: ");
        s.append(y2 + ", ");
        s.append("color: ");
        s.append(c + ", ");
        s.append("visibility: ");
        s.append(visibility);
        s.append("]");
        return s.toString();
    }
}

