/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.geotools.data.dxf.header;

import java.io.EOFException;
import java.io.IOException;
import java.util.Vector;
import nl.b3p.geotools.data.dxf.header.DXFBlock;
import nl.b3p.geotools.data.dxf.parser.DXFCodeValuePair;
import nl.b3p.geotools.data.dxf.parser.DXFConstants;
import nl.b3p.geotools.data.dxf.parser.DXFGroupCode;
import nl.b3p.geotools.data.dxf.parser.DXFLineNumberReader;
import nl.b3p.geotools.data.dxf.parser.DXFParseException;
import nl.b3p.geotools.data.dxf.parser.DXFUnivers;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DXFBlocks
implements DXFConstants {
    private static final Log log = LogFactory.getLog(DXFBlocks.class);
    public Vector<DXFBlock> theBlocks = new Vector();

    public DXFBlocks() {
        this.theBlocks = new Vector();
    }

    public DXFBlocks(Vector<DXFBlock> blocks) {
        if (blocks == null) {
            blocks = new Vector();
        }
        this.theBlocks = blocks;
    }

    public static DXFBlocks readBlocks(DXFLineNumberReader br, DXFUnivers univers) throws IOException {
        Vector<DXFBlock> sBlocks = new Vector<DXFBlock>();
        int sln = br.getLineNumber();
        log.debug((Object)(">Enter at line: " + sln));
        DXFCodeValuePair cvp = null;
        DXFGroupCode gc = null;
        boolean doLoop = true;
        block6: while (doLoop) {
            cvp = new DXFCodeValuePair();
            try {
                gc = cvp.read(br);
            }
            catch (DXFParseException ex) {
                throw new IOException("DXF parse error" + ex.getLocalizedMessage());
            }
            catch (EOFException e) {
                doLoop = false;
                break;
            }
            switch (gc) {
                case TYPE: {
                    String type = cvp.getStringValue();
                    if (type.equals("ENDSEC")) {
                        doLoop = false;
                        continue block6;
                    }
                    if (!type.equals("BLOCK")) continue block6;
                    DXFBlock block = DXFBlock.read(br, univers);
                    if (univers.isFilteredInsert(block._name)) continue block6;
                    sBlocks.add(block);
                    continue block6;
                }
            }
        }
        DXFBlocks e = new DXFBlocks(sBlocks);
        log.debug((Object)e.toString(sBlocks.size()));
        log.debug((Object)(">Exit at line: " + br.getLineNumber()));
        return e;
    }

    public String toString(int numEntities) {
        StringBuffer s = new StringBuffer();
        s.append("DXFBlocks [");
        s.append("numEntities: ");
        s.append(numEntities);
        s.append("]");
        return s.toString();
    }
}

