/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.geotools.data.dxf.header;

import java.io.EOFException;
import java.io.IOException;
import java.util.Vector;
import nl.b3p.geotools.data.dxf.header.DXFLayer;
import nl.b3p.geotools.data.dxf.header.DXFLineType;
import nl.b3p.geotools.data.dxf.parser.DXFCodeValuePair;
import nl.b3p.geotools.data.dxf.parser.DXFConstants;
import nl.b3p.geotools.data.dxf.parser.DXFGroupCode;
import nl.b3p.geotools.data.dxf.parser.DXFLineNumberReader;
import nl.b3p.geotools.data.dxf.parser.DXFParseException;
import nl.b3p.geotools.data.dxf.parser.DXFUnivers;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DXFTables
implements DXFConstants {
    private static final Log log = LogFactory.getLog(DXFTables.class);
    public static final double defaultThickness = 1.0;
    public Vector<DXFLayer> theLayers = new Vector();
    public Vector<DXFLineType> theLineTypes = new Vector();

    public DXFTables() {
    }

    public DXFTables(Vector<DXFLayer> sLayers, Vector<DXFLineType> sLineTypes) {
        this.theLayers = sLayers;
        this.theLineTypes = sLineTypes;
    }

    public static DXFTables readTables(DXFLineNumberReader br, DXFUnivers univers) throws IOException {
        Vector<DXFLayer> sLayers = new Vector<DXFLayer>();
        Vector<DXFLineType> sLineTypes = new Vector<DXFLineType>();
        int sln = br.getLineNumber();
        log.debug((Object)(">Enter at line: " + sln));
        DXFCodeValuePair cvp = null;
        DXFGroupCode gc = null;
        boolean doLoop = true;
        block6: while (doLoop) {
            cvp = new DXFCodeValuePair();
            try {
                gc = cvp.read(br);
            }
            catch (DXFParseException ex) {
                throw new IOException("DXF parse error" + ex.getLocalizedMessage());
            }
            catch (EOFException e) {
                doLoop = false;
                break;
            }
            switch (gc) {
                case TYPE: {
                    String type = cvp.getStringValue();
                    if (type.equals("ENDSEC")) {
                        doLoop = false;
                        continue block6;
                    }
                    if (!type.equals("TABLE")) continue block6;
                    DXFTables.readTable(br, sLayers, sLineTypes, univers);
                    continue block6;
                }
            }
        }
        DXFTables e = new DXFTables(sLayers, sLineTypes);
        log.debug((Object)e.toString(sLayers.size(), sLineTypes.size()));
        log.debug((Object)(">Exit at line: " + br.getLineNumber()));
        return e;
    }

    public static void readTable(DXFLineNumberReader br, Vector<DXFLayer> sLayers, Vector<DXFLineType> sLineTypes, DXFUnivers univers) throws IOException {
        int sln = br.getLineNumber();
        log.debug((Object)(">>Enter at line: " + sln));
        DXFCodeValuePair cvp = null;
        DXFGroupCode gc = null;
        boolean doLoop = true;
        block6: while (doLoop) {
            cvp = new DXFCodeValuePair();
            try {
                gc = cvp.read(br);
            }
            catch (DXFParseException ex) {
                throw new IOException("DXF parse error" + ex.getLocalizedMessage());
            }
            catch (EOFException e) {
                doLoop = false;
                break;
            }
            switch (gc) {
                case TYPE: {
                    String type = cvp.getStringValue();
                    if (type.equals("ENDSEC")) {
                        br.reset();
                        doLoop = false;
                        continue block6;
                    }
                    if (type.equals("ENDTAB")) {
                        doLoop = false;
                        continue block6;
                    }
                    if (type.equals("LAYER")) {
                        DXFLayer layer = DXFLayer.read(br);
                        sLayers.add(layer);
                        continue block6;
                    }
                    if (type.equals("LTYPE")) {
                        DXFLineType lt = DXFLineType.read(br);
                        sLineTypes.add(lt);
                        continue block6;
                    }
                    if (!type.equals("BLOCK_RECORD")) continue block6;
                    log.info((Object)("Blockrecord at " + br.getLineNumber()));
                    continue block6;
                }
            }
        }
    }

    public String toString(int numLayers, int numLineTypes) {
        StringBuffer s = new StringBuffer();
        s.append("DXFTables [");
        s.append("numLayers: ");
        s.append(numLayers + ", ");
        s.append("numLineTypes: ");
        s.append(numLineTypes);
        s.append("]");
        return s.toString();
    }
}

