/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.geotools.data.dxf;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import nl.b3p.geotools.data.GeometryType;
import nl.b3p.geotools.data.dxf.DXFFeatureReader;
import nl.b3p.geotools.data.dxf.parser.DXFParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.data.AbstractFileDataStore;
import org.geotools.data.FeatureReader;
import org.geotools.data.ServiceInfo;
import org.opengis.feature.simple.SimpleFeatureType;

public class DXFDataStore
extends AbstractFileDataStore {
    private static final Log log = LogFactory.getLog(DXFDataStore.class);
    private URL url;
    private FeatureReader featureReader;
    private String srs;
    private String strippedFileName;
    private String typeName;
    private ArrayList dxfInsertsFilter = new ArrayList();

    public DXFDataStore(URL url, String srs) throws IOException {
        this.url = url;
        this.strippedFileName = DXFDataStore.getURLTypeName(url);
        this.srs = srs;
    }

    public String[] getTypeNames() throws IOException {
        return GeometryType.getTypeNames(this.strippedFileName, GeometryType.ALL);
    }

    static String getURLTypeName(URL url) throws IOException {
        String file = url.getFile();
        if (file.length() == 0) {
            return "unknown_dxf";
        }
        int i = file.lastIndexOf(47);
        if (i != -1) {
            file = file.substring(i + 1);
        }
        if (file.toLowerCase().endsWith(".dxf")) {
            file = file.substring(0, file.length() - 4);
        }
        file = file.replaceAll(" ", "_");
        return file;
    }

    public void addDXFInsertFilter(String[] filteredNames) {
        this.dxfInsertsFilter.addAll(Arrays.asList(filteredNames));
    }

    public void addDXFInsertFilter(String filteredName) {
        this.dxfInsertsFilter.add(filteredName);
    }

    public SimpleFeatureType getSchema(String typeName) throws IOException {
        return (SimpleFeatureType)this.getFeatureReader(typeName).getFeatureType();
    }

    public SimpleFeatureType getSchema() throws IOException {
        if (this.typeName == null) {
            log.warn((Object)"Typename is null, probably because of using getFeatureSource().\n\tPlease use getFeatureSource(typename)");
        }
        return this.getSchema(this.typeName);
    }

    public FeatureReader getFeatureReader(String typeName) throws IOException {
        this.resetFeatureReader(typeName);
        return this.featureReader;
    }

    public FeatureReader getFeatureReader() throws IOException {
        if (this.featureReader == null) {
            this.resetFeatureReader(this.typeName);
        }
        return this.featureReader;
    }

    public void resetFeatureReader(String typeName) throws IOException {
        if (typeName == null) {
            log.error((Object)"No typeName given for featureReader");
        } else {
            this.typeName = typeName;
            String extension = typeName.replaceFirst(this.strippedFileName, "");
            GeometryType geometryType = GeometryType.getTypeByExtension(extension);
            if (this.featureReader == null) {
                try {
                    this.featureReader = new DXFFeatureReader(this.url, typeName, this.srs, geometryType, this.dxfInsertsFilter);
                }
                catch (DXFParseException e) {
                    throw new IOException("DXF parse exception" + e.getLocalizedMessage());
                }
            } else {
                ((DXFFeatureReader)this.featureReader).updateTypeFilter(typeName, geometryType, this.srs);
            }
        }
    }

    public ServiceInfo getInfo() {
        try {
            return ((DXFFeatureReader)this.getFeatureReader()).getInfo();
        }
        catch (IOException ex) {
            return null;
        }
    }
}

