/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.geotools.data.dxf.entities;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LinearRing;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import nl.b3p.geotools.data.GeometryType;
import nl.b3p.geotools.data.dxf.entities.DXFEntity;
import nl.b3p.geotools.data.dxf.entities.DXFPoint;
import nl.b3p.geotools.data.dxf.header.DXFLayer;
import nl.b3p.geotools.data.dxf.header.DXFLineType;
import nl.b3p.geotools.data.dxf.parser.DXFCodeValuePair;
import nl.b3p.geotools.data.dxf.parser.DXFGroupCode;
import nl.b3p.geotools.data.dxf.parser.DXFLineNumberReader;
import nl.b3p.geotools.data.dxf.parser.DXFParseException;
import nl.b3p.geotools.data.dxf.parser.DXFUnivers;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DXFCircle
extends DXFEntity {
    private static final Log log = LogFactory.getLog(DXFCircle.class);
    public DXFPoint _point = new DXFPoint();
    public double _radius = 0.0;

    public DXFCircle(DXFCircle newCircle) {
        this(new DXFPoint(newCircle._point._point.x, newCircle._point._point.y, newCircle.getColor(), newCircle.getRefLayer(), 0, newCircle.getThickness()), newCircle._radius, newCircle.getLineType(), newCircle.getColor(), newCircle.getRefLayer(), 0, newCircle.getThickness());
        this.setType(newCircle.getType());
        this.setStartingLineNumber(newCircle.getStartingLineNumber());
        this.setUnivers(newCircle.getUnivers());
    }

    public DXFCircle(DXFPoint p, double r, DXFLineType lineType, int c, DXFLayer l, int visibility, double thickness) {
        super(c, l, visibility, lineType, thickness);
        this._point = p;
        this._radius = r;
        this.setName("DXFCircle");
    }

    public static DXFCircle read(DXFLineNumberReader br, DXFUnivers univers) throws NumberFormatException, IOException {
        int visibility = 0;
        int c = 0;
        double x = 0.0;
        double y = 0.0;
        double r = 0.0;
        double thickness = 1.0;
        DXFLayer l = null;
        DXFLineType lineType = null;
        int sln = br.getLineNumber();
        log.debug((Object)(">>Enter at line: " + sln));
        DXFCodeValuePair cvp = null;
        DXFGroupCode gc = null;
        boolean doLoop = true;
        block14: while (doLoop) {
            cvp = new DXFCodeValuePair();
            try {
                gc = cvp.read(br);
            }
            catch (DXFParseException ex) {
                throw new IOException("DXF parse error" + ex.getLocalizedMessage());
            }
            catch (EOFException e) {
                doLoop = false;
                break;
            }
            switch (gc) {
                case TYPE: {
                    String type = cvp.getStringValue();
                    br.reset();
                    doLoop = false;
                    continue block14;
                }
                case LINETYPE_NAME: {
                    lineType = univers.findLType(cvp.getStringValue());
                    continue block14;
                }
                case LAYER_NAME: {
                    l = univers.findLayer(cvp.getStringValue());
                    continue block14;
                }
                case THICKNESS: {
                    thickness = cvp.getDoubleValue();
                    continue block14;
                }
                case VISIBILITY: {
                    visibility = cvp.getShortValue();
                    continue block14;
                }
                case COLOR: {
                    c = cvp.getShortValue();
                    continue block14;
                }
                case X_1: {
                    x = cvp.getDoubleValue();
                    continue block14;
                }
                case Y_1: {
                    y = cvp.getDoubleValue();
                    continue block14;
                }
                case DOUBLE_1: {
                    r = cvp.getDoubleValue();
                    continue block14;
                }
            }
        }
        DXFCircle e = new DXFCircle(new DXFPoint(x, y, c, l, visibility, 1.0), r, lineType, c, l, visibility, thickness);
        e.setType(GeometryType.POLYGON);
        e.setStartingLineNumber(sln);
        e.setUnivers(univers);
        log.debug((Object)e.toString(x, y, c, visibility, thickness));
        log.debug((Object)(">>Exit at line: " + br.getLineNumber()));
        return e;
    }

    public Coordinate[] toCoordinateArray() {
        if (this._point == null || this._point._point == null || this._radius <= 0.0) {
            this.addError("coordinate array can not be created.");
            return null;
        }
        ArrayList<Object> lc = new ArrayList<Object>();
        double startAngle = 0.0;
        double endAngle = Math.PI * 2;
        double segAngle = Math.PI * 2 / this._radius;
        if (this._radius < 16.0) {
            segAngle = 0.39269908169872414;
        }
        double angle = startAngle;
        while (true) {
            double x = this._point._point.getX() + this._radius * Math.cos(angle);
            double y = this._point._point.getY() + this._radius * Math.sin(angle);
            Coordinate c = new Coordinate(x, y);
            lc.add(c);
            if (angle >= endAngle) break;
            if (!((angle += segAngle) > endAngle)) continue;
            angle = endAngle;
        }
        if (!((Coordinate)lc.get(0)).equals(lc.get(lc.size() - 1))) {
            lc.set(lc.size() - 1, lc.get(0));
        }
        return this.rotateAndPlace(lc.toArray(new Coordinate[0]));
    }

    public Geometry getGeometry() {
        if (this.geometry == null) {
            this.updateGeometry();
        }
        return super.getGeometry();
    }

    public void updateGeometry() {
        Coordinate[] ca = this.toCoordinateArray();
        if (ca != null && ca.length > 1) {
            LinearRing lr = this.getUnivers().getGeometryFactory().createLinearRing(ca);
            this.geometry = this.getUnivers().getGeometryFactory().createPolygon(lr, null);
        } else {
            this.addError("coordinate array faulty, size: " + (ca == null ? 0 : ca.length));
        }
    }

    public String toString(double x, double y, int c, int visibility, double thickness) {
        StringBuffer s = new StringBuffer();
        s.append("DXFCircle [");
        s.append("x: ");
        s.append(x + ", ");
        s.append("y: ");
        s.append(y + ", ");
        s.append("color: ");
        s.append(c + ", ");
        s.append("visibility: ");
        s.append(visibility + ", ");
        s.append("thickness: ");
        s.append(thickness);
        s.append("]");
        return s.toString();
    }

    public DXFEntity translate(double x, double y) {
        this._point._point.x += x;
        this._point._point.y += y;
        return this;
    }

    public DXFEntity clone() {
        return new DXFCircle(this);
    }
}

