/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.geotools.data.dxf.entities;

import java.io.EOFException;
import java.io.IOException;
import nl.b3p.geotools.data.GeometryType;
import nl.b3p.geotools.data.dxf.entities.DXFEntity;
import nl.b3p.geotools.data.dxf.entities.DXFPoint;
import nl.b3p.geotools.data.dxf.header.DXFBlock;
import nl.b3p.geotools.data.dxf.header.DXFBlockReference;
import nl.b3p.geotools.data.dxf.header.DXFLayer;
import nl.b3p.geotools.data.dxf.header.DXFLineType;
import nl.b3p.geotools.data.dxf.parser.DXFCodeValuePair;
import nl.b3p.geotools.data.dxf.parser.DXFGroupCode;
import nl.b3p.geotools.data.dxf.parser.DXFLineNumberReader;
import nl.b3p.geotools.data.dxf.parser.DXFParseException;
import nl.b3p.geotools.data.dxf.parser.DXFUnivers;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DXFInsert
extends DXFBlockReference {
    private static final Log log = LogFactory.getLog(DXFInsert.class);
    public DXFPoint _point = new DXFPoint();
    public double _angle = 0.0;

    public DXFInsert(DXFInsert newInsert) {
        this(newInsert._point._point.x, newInsert._point._point.y, newInsert._blockName, newInsert._refBlock, newInsert.getRefLayer(), 0, newInsert.getColor(), newInsert.getLineType(), newInsert._angle);
        this.setType(newInsert.getType());
        this.setStartingLineNumber(newInsert.getStartingLineNumber());
        this.setUnivers(newInsert.getUnivers());
    }

    public DXFInsert(double x, double y, String nomBlock, DXFBlock refBlock, DXFLayer l, int visibility, int c, DXFLineType lineType, double angle) {
        super(c, l, visibility, lineType, nomBlock, refBlock);
        this._point = new DXFPoint(x, y, c, null, visibility, 1.0);
        this._angle = angle;
        this.setName("DXFInsert");
    }

    public static DXFInsert read(DXFLineNumberReader br, DXFUnivers univers) throws IOException {
        String nomBlock = "";
        DXFInsert m = null;
        DXFLayer l = null;
        double x = 0.0;
        double y = 0.0;
        int visibility = 0;
        int c = -1;
        DXFBlock refBlock = null;
        DXFLineType lineType = null;
        double angle = 0.0;
        int sln = br.getLineNumber();
        log.debug((Object)(">>Enter at line: " + sln));
        DXFCodeValuePair cvp = null;
        DXFGroupCode gc = null;
        boolean doLoop = true;
        block14: while (doLoop) {
            cvp = new DXFCodeValuePair();
            try {
                gc = cvp.read(br);
            }
            catch (DXFParseException ex) {
                throw new IOException("DXF parse error" + ex.getLocalizedMessage());
            }
            catch (EOFException e) {
                doLoop = false;
                break;
            }
            switch (gc) {
                case TYPE: {
                    String type = cvp.getStringValue();
                    br.reset();
                    doLoop = false;
                    continue block14;
                }
                case LAYER_NAME: {
                    l = univers.findLayer(cvp.getStringValue());
                    continue block14;
                }
                case NAME: {
                    nomBlock = cvp.getStringValue();
                    continue block14;
                }
                case X_1: {
                    x = cvp.getDoubleValue();
                    continue block14;
                }
                case Y_1: {
                    y = cvp.getDoubleValue();
                    continue block14;
                }
                case ANGLE_1: {
                    angle = cvp.getDoubleValue();
                    continue block14;
                }
                case COLOR: {
                    c = cvp.getShortValue();
                    continue block14;
                }
                case VISIBILITY: {
                    visibility = cvp.getShortValue();
                    continue block14;
                }
                case LINETYPE_NAME: {
                    lineType = univers.findLType(cvp.getStringValue());
                    continue block14;
                }
            }
        }
        m = new DXFInsert(x, y, nomBlock, refBlock, l, visibility, c, lineType, angle);
        m.setType(GeometryType.POINT);
        m.setStartingLineNumber(sln);
        m.setUnivers(univers);
        univers.addRefBlockForUpdate(m);
        log.debug((Object)m.toString(x, y, visibility, c, lineType));
        log.debug((Object)(">>Exit at line: " + br.getLineNumber()));
        return m;
    }

    public String toString(double x, double y, int visibility, int c, DXFLineType lineType) {
        StringBuffer s = new StringBuffer();
        s.append("DXFInsert [");
        s.append("x: ");
        s.append(x + ", ");
        s.append("y: ");
        s.append(y + ", ");
        s.append("visibility: ");
        s.append(visibility + ", ");
        s.append("color: ");
        s.append(c + ", ");
        s.append("line type: ");
        if (lineType != null) {
            s.append(lineType._name);
        }
        s.append("]");
        return s.toString();
    }

    public DXFEntity translate(double x, double y) {
        this._point._point.x += x;
        this._point._point.y += y;
        return this;
    }

    public DXFEntity clone() {
        return new DXFInsert(this);
    }
}

