/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.geotools.data.dxf.entities;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import java.io.EOFException;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.regex.Pattern;
import nl.b3p.geotools.data.GeometryType;
import nl.b3p.geotools.data.dxf.entities.DXFEntity;
import nl.b3p.geotools.data.dxf.header.DXFLayer;
import nl.b3p.geotools.data.dxf.header.DXFLineType;
import nl.b3p.geotools.data.dxf.parser.DXFCodeValuePair;
import nl.b3p.geotools.data.dxf.parser.DXFGroupCode;
import nl.b3p.geotools.data.dxf.parser.DXFLineNumberReader;
import nl.b3p.geotools.data.dxf.parser.DXFParseException;
import nl.b3p.geotools.data.dxf.parser.DXFUnivers;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DXFText
extends DXFEntity {
    private static final Log log = LogFactory.getLog(DXFText.class);
    private Double x = null;
    private Double y = null;

    public DXFText(DXFText newText) {
        this(newText.getColor(), newText.getRefLayer(), 0, newText.getLineType(), 0.0);
        this.setStartingLineNumber(newText.getStartingLineNumber());
        this.setType(newText.getType());
        this.setUnivers(newText.getUnivers());
    }

    public DXFText(int c, DXFLayer l, int visibility, DXFLineType lineType, double thickness) {
        super(c, l, visibility, lineType, thickness);
    }

    public Double getX() {
        return this.x;
    }

    public void setX(Double x) {
        this.x = x;
    }

    public Double getY() {
        return this.y;
    }

    public void setY(Double y) {
        this.y = y;
    }

    public static DXFText read(DXFLineNumberReader br, DXFUnivers univers, boolean isMText) throws IOException {
        DXFText t = new DXFText(0, null, 0, null, 1.0);
        t.setUnivers(univers);
        t.setName(isMText ? "DXFMText" : "DXFText");
        t.setTextrotation(0.0);
        t.setStartingLineNumber(br.getLineNumber());
        DXFCodeValuePair cvp = null;
        DXFGroupCode gc = null;
        Double directionX = null;
        Double directionY = null;
        String textposhor = "left";
        String textposver = "bottom";
        boolean doLoop = true;
        block43: while (doLoop) {
            cvp = new DXFCodeValuePair();
            try {
                gc = cvp.read(br);
            }
            catch (DXFParseException ex) {
                throw new IOException("DXF parse error" + ex.getLocalizedMessage());
            }
            catch (EOFException e) {
                doLoop = false;
                break;
            }
            switch (gc) {
                case TYPE: {
                    br.reset();
                    doLoop = false;
                    continue block43;
                }
                case X_1: {
                    t.setX(cvp.getDoubleValue());
                    continue block43;
                }
                case Y_1: {
                    t.setY(cvp.getDoubleValue());
                    continue block43;
                }
                case TEXT: {
                    t.setText(DXFText.processOrStripTextCodes(cvp.getStringValue()));
                    continue block43;
                }
                case ANGLE_1: {
                    t.setTextrotation(cvp.getDoubleValue());
                    continue block43;
                }
                case X_2: {
                    directionX = cvp.getDoubleValue();
                    continue block43;
                }
                case Y_2: {
                    directionY = cvp.getDoubleValue();
                    continue block43;
                }
                case THICKNESS: {
                    t.setThickness(cvp.getDoubleValue());
                    continue block43;
                }
                case DOUBLE_1: {
                    t.setTextheight(cvp.getDoubleValue());
                    continue block43;
                }
                case INT_2: {
                    switch (cvp.getShortValue()) {
                        case 1: {
                            textposver = "top";
                            textposhor = "left";
                            break;
                        }
                        case 2: {
                            textposver = "top";
                            textposhor = "center";
                            break;
                        }
                        case 3: {
                            textposver = "top";
                            textposhor = "right";
                            break;
                        }
                        case 4: {
                            textposver = "middle";
                            textposhor = "left";
                            break;
                        }
                        case 5: {
                            textposver = "middle";
                            textposhor = "center";
                            break;
                        }
                        case 6: {
                            textposver = "middle";
                            textposhor = "right";
                            break;
                        }
                        case 7: {
                            textposver = "bottom";
                            textposhor = "left";
                            break;
                        }
                        case 8: {
                            textposver = "bottom";
                            textposhor = "center";
                            break;
                        }
                        case 9: {
                            textposver = "bottom";
                            textposhor = "right";
                        }
                    }
                    continue block43;
                }
                case INT_3: {
                    switch (cvp.getShortValue()) {
                        case 0: {
                            textposhor = "left";
                            break;
                        }
                        case 1: {
                            textposhor = "center";
                            break;
                        }
                        case 2: {
                            textposhor = "right";
                            break;
                        }
                        case 3: 
                        case 4: 
                        case 5: {
                            textposhor = "center";
                        }
                    }
                    continue block43;
                }
                case INT_4: {
                    switch (cvp.getShortValue()) {
                        case 0: {
                            textposver = "bottom";
                            break;
                        }
                        case 1: {
                            textposver = "bottom";
                            break;
                        }
                        case 2: {
                            textposver = "middle";
                            break;
                        }
                        case 3: {
                            textposver = "top";
                        }
                    }
                    continue block43;
                }
                case LAYER_NAME: {
                    t._refLayer = univers.findLayer(cvp.getStringValue());
                    continue block43;
                }
                case COLOR: {
                    t.setColor(cvp.getShortValue());
                    continue block43;
                }
                case VISIBILITY: {
                    t.setVisible(cvp.getShortValue() == 0);
                    continue block43;
                }
            }
        }
        t.setTextposvertical(textposver);
        t.setTextposhorizontal(textposhor);
        if (isMText && directionX != null && directionY != null) {
            t.setTextrotation(DXFText.calculateRotationFromDirectionVector(directionX, directionY));
            if (log.isDebugEnabled()) {
                log.debug((Object)MessageFormat.format("MTEXT entity at line number %d: text pos (%.4f,%.4f), direction vector (%.4f,%.4f), calculated text rotation %.2f degrees", t.getStartingLineNumber(), t.getX(), t.getY(), directionX, directionY, t.getTextrotation()));
            }
        }
        t.setType(GeometryType.POINT);
        return t;
    }

    private static String processOrStripTextCodes(String text) {
        if (text == null) {
            return null;
        }
        text = text.replaceAll("%%[cC]", "\u00c3\u02dc");
        text = text.replaceAll("\\\\[Pp]", "\r\n");
        text = text.replaceAll("\\\\[Ll~]", "");
        text = text.replaceAll(Pattern.quote("\\\\"), "\\");
        text = text.replaceAll(Pattern.quote("\\{"), "{");
        text = text.replaceAll(Pattern.quote("\\}"), "}");
        text = text.replaceAll("\\\\[CcFfHhTtQqWwAa].*;", "");
        return text;
    }

    private static double calculateRotationFromDirectionVector(double x, double y) {
        double rotation;
        double length = Math.sqrt(x * x + y * y);
        if (length == 0.0) {
            rotation = 0.0;
        } else {
            double theta = Math.acos(x / length);
            if (x <= 0.0 && y <= 0.0 || x >= 0.0 && y <= 0.0) {
                theta = -(theta - Math.PI * 2);
            }
            if (Math.abs(360.0 - (rotation = theta * 57.29577951308232)) < 1.0E-4) {
                rotation = 0.0;
            }
        }
        return rotation;
    }

    public Geometry getGeometry() {
        if (this.geometry == null) {
            this.updateGeometry();
        }
        return this.geometry;
    }

    public void updateGeometry() {
        if (this.x != null && this.y != null) {
            Coordinate c = this.rotateAndPlace(new Coordinate(this.x.doubleValue(), this.y.doubleValue()));
            this.setGeometry((Geometry)this.getUnivers().getGeometryFactory().createPoint(c));
        } else {
            this.setGeometry(null);
        }
    }

    public DXFEntity translate(double x, double y) {
        DXFText dXFText = this;
        dXFText.x = dXFText.x + x;
        dXFText = this;
        dXFText.y = dXFText.y + y;
        return this;
    }

    public DXFEntity clone() {
        return new DXFText(this);
    }
}

