/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.geotools.data.dxf.header;

import java.io.EOFException;
import java.io.IOException;
import java.util.Vector;
import nl.b3p.geotools.data.dxf.entities.DXFEntity;
import nl.b3p.geotools.data.dxf.header.DXFBlock;
import nl.b3p.geotools.data.dxf.header.DXFLayer;
import nl.b3p.geotools.data.dxf.parser.DXFCodeValuePair;
import nl.b3p.geotools.data.dxf.parser.DXFColor;
import nl.b3p.geotools.data.dxf.parser.DXFGroupCode;
import nl.b3p.geotools.data.dxf.parser.DXFLineNumberReader;
import nl.b3p.geotools.data.dxf.parser.DXFParseException;
import nl.b3p.geotools.data.dxf.parser.DXFUnivers;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DXFBlockRecord
extends DXFBlock {
    private static final Log log = LogFactory.getLog(DXFBlock.class);

    public DXFBlockRecord(double x, double y, int flag, String name, Vector<DXFEntity> ent, int c, DXFLayer l) {
        super(x, y, flag, name, ent, c, l);
    }

    public static DXFBlockRecord read(DXFLineNumberReader br, DXFUnivers univers) throws IOException {
        Vector<DXFEntity> sEnt = new Vector<DXFEntity>();
        String name = "";
        double x = 0.0;
        double y = 0.0;
        int flag = 0;
        DXFLayer l = null;
        int sln = br.getLineNumber();
        log.debug((Object)(">Enter at line: " + sln));
        DXFCodeValuePair cvp = null;
        DXFGroupCode gc = null;
        boolean doLoop = true;
        block7: while (doLoop) {
            cvp = new DXFCodeValuePair();
            try {
                gc = cvp.read(br);
            }
            catch (DXFParseException ex) {
                throw new IOException("DXF parse error" + ex.getLocalizedMessage());
            }
            catch (EOFException e) {
                doLoop = false;
                break;
            }
            switch (gc) {
                case TYPE: {
                    String type = cvp.getStringValue();
                    if ("ENDBLK".equals(type)) {
                        doLoop = false;
                        continue block7;
                    }
                    if (!"ENDSEC".equals(type)) continue block7;
                    doLoop = false;
                    br.reset();
                    continue block7;
                }
                case NAME: {
                    name = cvp.getStringValue();
                    continue block7;
                }
            }
        }
        DXFBlockRecord e = new DXFBlockRecord(x, y, flag, name, sEnt, DXFColor.getDefaultColorIndex(), l);
        log.debug((Object)e.toString(x, y, flag, name, sEnt.size(), DXFColor.getDefaultColorIndex()));
        log.debug((Object)(">Exit at line: " + br.getLineNumber()));
        return e;
    }
}

