/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.geotools.data.dxf.header;

import java.io.EOFException;
import java.io.IOException;
import java.util.Vector;
import nl.b3p.geotools.data.dxf.parser.DXFCodeValuePair;
import nl.b3p.geotools.data.dxf.parser.DXFGroupCode;
import nl.b3p.geotools.data.dxf.parser.DXFLineNumberReader;
import nl.b3p.geotools.data.dxf.parser.DXFParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DXFLineType {
    private static final Log log = LogFactory.getLog(DXFLineType.class);
    public static final String DEFAULT_NAME = "default";
    public String _name = "DXFLineType";
    public String _value = "";
    public float _length = 0.0f;
    public float _count = 0.0f;
    public Vector<Float> _spacing = new Vector();

    public DXFLineType() {
    }

    public DXFLineType(String nom, String value, float length, float count, Vector<Float> spacing) {
        this._name = nom;
        this._value = value;
        this._length = length;
        this._count = count;
        if (spacing != null) {
            this._spacing = spacing;
        }
    }

    public static DXFLineType read(DXFLineNumberReader br) throws IOException {
        String value = "";
        String name = "";
        Vector<Float> spacing = new Vector<Float>();
        float count = 0.0f;
        float length = 0.0f;
        int sln = br.getLineNumber();
        log.debug((Object)(">Enter at line: " + sln));
        DXFCodeValuePair cvp = null;
        DXFGroupCode gc = null;
        boolean doLoop = true;
        block11: while (doLoop) {
            cvp = new DXFCodeValuePair();
            try {
                gc = cvp.read(br);
            }
            catch (DXFParseException ex) {
                throw new IOException("DXF parse error" + ex.getLocalizedMessage());
            }
            catch (EOFException e) {
                doLoop = false;
                break;
            }
            switch (gc) {
                case TYPE: 
                case VARIABLE_NAME: {
                    br.reset();
                    doLoop = false;
                    continue block11;
                }
                case NAME: {
                    name = cvp.getStringValue();
                    continue block11;
                }
                case TEXT_OR_NAME_2: {
                    value = cvp.getStringValue();
                    continue block11;
                }
                case INT_4: {
                    count = cvp.getShortValue();
                    continue block11;
                }
                case DOUBLE_1: {
                    length = (float)cvp.getDoubleValue();
                    continue block11;
                }
                case REPEATED_DOUBLE_VALUE: {
                    spacing.add(Float.valueOf((float)cvp.getDoubleValue()));
                    continue block11;
                }
            }
        }
        log.debug((Object)(">Exit at line: " + br.getLineNumber()));
        if (value.equals("") && name.equals("")) {
            return null;
        }
        DXFLineType e = new DXFLineType(name, value, length, count, spacing);
        log.debug((Object)e.toString(name, value, length, count));
        return e;
    }

    public String toString(String name, String value, float length, float count) {
        StringBuffer s = new StringBuffer();
        s.append("DXFLineType [");
        s.append("name: ");
        s.append(name + ", ");
        s.append("value: ");
        s.append(value + ", ");
        s.append("length: ");
        s.append(length + ", ");
        s.append("count: ");
        s.append(count);
        s.append("]");
        return s.toString();
    }
}

