/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.geotools.data.dxf;

import com.vividsolutions.jts.geom.Geometry;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import nl.b3p.geotools.data.GeometryType;
import nl.b3p.geotools.data.dxf.entities.DXFEntity;
import nl.b3p.geotools.data.dxf.entities.DXFInsert;
import nl.b3p.geotools.data.dxf.parser.DXFLineNumberReader;
import nl.b3p.geotools.data.dxf.parser.DXFParseException;
import nl.b3p.geotools.data.dxf.parser.DXFUnivers;
import org.apache.commons.io.input.CountingInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.data.DataSourceException;
import org.geotools.data.DefaultServiceInfo;
import org.geotools.data.FeatureReader;
import org.geotools.data.ServiceInfo;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.referencing.CRS;
import org.geotools.referencing.NamedIdentifier;
import org.opengis.feature.IllegalAttributeException;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class DXFFeatureReader
implements FeatureReader {
    private static final Log LOG = LogFactory.getLog(DXFFeatureReader.class);
    private SimpleFeatureType ft;
    private Iterator<DXFEntity> entityIterator;
    private GeometryType geometryType = null;
    private SimpleFeature cache;
    private DXFUnivers theUnivers;
    private int featureID = 0;
    private ListFeatureCollection listFC;
    private Boolean hasNext = null;

    public DXFFeatureReader(URL url, String typeName, String srs, GeometryType geometryType, ArrayList dxfInsertsFilter) throws IOException, DXFParseException {
        CountingInputStream cis = null;
        BufferedReader lnr = null;
        try {
            cis = new CountingInputStream(url.openStream());
            lnr = new DXFLineNumberReader(new InputStreamReader((InputStream)cis));
            this.theUnivers = new DXFUnivers(dxfInsertsFilter);
            this.theUnivers.read((DXFLineNumberReader)lnr);
        }
        catch (IOException ioe) {
            LOG.error((Object)"Error reading data in datastore: ", (Throwable)ioe);
            throw ioe;
        }
        finally {
            if (lnr != null) {
                lnr.close();
            }
            if (cis != null) {
                cis.close();
            }
        }
        this.updateTypeFilter(typeName, geometryType, srs);
    }

    public void updateTypeFilter(String typeName, GeometryType geometryType, String srs) {
        this.geometryType = geometryType;
        this.entityIterator = this.theUnivers.theEntities.iterator();
        this.hasNext = null;
        try {
            this.createFeatureType(typeName, srs);
        }
        catch (DataSourceException ex) {
            LOG.error((Object)ex.getLocalizedMessage());
        }
    }

    private void createFeatureType(String typeName, String srs) throws DataSourceException {
        this.listFC = null;
        CoordinateReferenceSystem crs = null;
        try {
            crs = CRS.decode((String)srs);
        }
        catch (Exception e) {
            throw new DataSourceException("Error parsing CoordinateSystem srs: \"" + srs + "\"");
        }
        int SRID = -1;
        if (crs != null) {
            try {
                Set ident = crs.getIdentifiers();
                if (ident != null && !ident.isEmpty()) {
                    String code = ((NamedIdentifier)ident.toArray()[0]).getCode();
                    SRID = Integer.parseInt(code);
                }
            }
            catch (Exception e) {
                LOG.error((Object)"SRID could not be determined from crs!");
            }
        }
        LOG.info((Object)("SRID used by SimpleFeature reader: " + SRID));
        try {
            SimpleFeatureTypeBuilder ftb = new SimpleFeatureTypeBuilder();
            ftb.setName(typeName);
            ftb.setSRS(srs);
            ftb.add("the_geom", Geometry.class);
            ftb.add("layer", String.class);
            ftb.add("name", String.class);
            ftb.add("text", String.class);
            ftb.add("textposhorizontal", String.class);
            ftb.add("textposvertical", String.class);
            ftb.add("textheight", Double.class);
            ftb.add("textrotation", Double.class);
            ftb.add("color", String.class);
            ftb.add("linetype", String.class);
            ftb.add("thickness", Double.class);
            ftb.add("visible", Integer.class);
            ftb.add("linenumber", Integer.class);
            ftb.add("error", String.class);
            this.ft = ftb.buildFeatureType();
            LOG.debug((Object)("Created featuretype: " + this.ft));
        }
        catch (Exception e) {
            throw new DataSourceException("Error creating SimpleFeatureType: " + typeName, (Throwable)e);
        }
    }

    public SimpleFeatureType getFeatureType() {
        return this.ft;
    }

    public SimpleFeature next() throws IOException, IllegalAttributeException, NoSuchElementException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.hasNext = null;
        return this.cache;
    }

    public boolean hasNext() throws IOException {
        if (this.hasNext != null) {
            return this.hasNext;
        }
        if (!this.entityIterator.hasNext()) {
            this.hasNext = false;
        } else {
            Geometry g = null;
            DXFEntity entry = null;
            try {
                entry = null;
                boolean passedFilter = false;
                while (!(passedFilter = this.passedFilter(entry = this.entityIterator.next())) && this.entityIterator.hasNext()) {
                }
                if (passedFilter) {
                    g = entry.getGeometry();
                    this.cache = SimpleFeatureBuilder.build((SimpleFeatureType)this.ft, (Object[])new Object[]{g, entry.getRefLayerName(), entry.getName(), entry.getText(), entry.getTextposhorizontal(), entry.getTextposvertical(), entry.getTextheight(), entry.getTextrotation(), entry.getColorRGB(), entry.getLineTypeName(), entry.getThickness(), entry.isVisible() ? 1 : 0, entry.getStartingLineNumber(), entry.getErrorDescription()}, (String)Integer.toString(this.featureID++));
                    this.hasNext = true;
                    LOG.debug((Object)("Created feature: " + this.cache));
                } else {
                    this.hasNext = false;
                }
            }
            catch (IllegalAttributeException ex) {
                throw new IOException("Error accessing attribute", ex);
            }
        }
        return this.hasNext;
    }

    private boolean passedFilter(DXFEntity entry) {
        if (entry == null) {
            return false;
        }
        boolean isEqual = entry.getType().equals((Object)this.geometryType) || this.geometryType.equals((Object)GeometryType.ALL) && !entry.getType().equals((Object)GeometryType.UNSUPPORTED);
        try {
            if (entry.getGeometry() != null && !entry.getGeometry().isValid()) {
                if (isEqual) {
                    LOG.info((Object)("Invalid " + (Object)((Object)entry.getType()) + " found while parsing table"));
                }
                return false;
            }
            if (entry.getErrorDescription() != null && entry instanceof DXFInsert) {
                return false;
            }
        }
        catch (Exception ex) {
            LOG.error((Object)("Skipping geometry; problem with " + entry.getName() + ": " + ex.getLocalizedMessage()));
            return false;
        }
        return isEqual;
    }

    public ServiceInfo getInfo() {
        DefaultServiceInfo serviceInfo = new DefaultServiceInfo();
        serviceInfo.setTitle("DXF FeatureReader");
        serviceInfo.setDescription(this.theUnivers == null ? "Univers is null" : this.theUnivers.getInfo());
        return serviceInfo;
    }

    public void close() throws IOException {
        this.listFC = null;
    }

    public SimpleFeatureCollection getFeatureCollection() throws IOException {
        if (this.listFC == null || this.listFC.isEmpty()) {
            LOG.debug((Object)"Creating feature collection");
            this.listFC = new ListFeatureCollection(this.getFeatureType());
            while (this.hasNext()) {
                this.listFC.add(this.next());
            }
        }
        return this.listFC;
    }
}

