/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.geotools.data.dxf.entities;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import nl.b3p.geotools.data.GeometryType;
import nl.b3p.geotools.data.dxf.entities.DXFEntity;
import nl.b3p.geotools.data.dxf.entities.DXFPoint;
import nl.b3p.geotools.data.dxf.header.DXFLayer;
import nl.b3p.geotools.data.dxf.header.DXFLineType;
import nl.b3p.geotools.data.dxf.parser.DXFCodeValuePair;
import nl.b3p.geotools.data.dxf.parser.DXFGroupCode;
import nl.b3p.geotools.data.dxf.parser.DXFLineNumberReader;
import nl.b3p.geotools.data.dxf.parser.DXFParseException;
import nl.b3p.geotools.data.dxf.parser.DXFUnivers;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DXFArc
extends DXFEntity {
    private static final Log log = LogFactory.getLog(DXFArc.class);
    public DXFPoint _point = new DXFPoint();
    public double _radius = 0.0;
    protected double _angle1 = 0.0;
    protected double _angle2 = 0.0;

    public DXFArc(DXFArc newArc) {
        this(newArc.getAngle1(), newArc.getAngle2(), newArc._point, newArc._radius, newArc.getLineType(), newArc.getColor(), newArc.getRefLayer(), 0, newArc.getThickness());
        this.setType(newArc.getType());
        this.setStartingLineNumber(newArc.getStartingLineNumber());
        this.setUnivers(newArc.getUnivers());
    }

    public DXFArc(double a1, double a2, DXFPoint p, double r, DXFLineType lineType, int c, DXFLayer l, int visibility, double thickness) {
        super(c, l, visibility, lineType, thickness);
        this._point = p;
        this._radius = r;
        this._angle1 = a1;
        this._angle2 = a2;
        this.setThickness(thickness);
        this.setName("DXFArc");
    }

    public double getAngle1() {
        return this._angle1;
    }

    public double getAngle2() {
        return this._angle2;
    }

    public static DXFArc read(DXFLineNumberReader br, DXFUnivers univers) throws NumberFormatException, IOException {
        double x = 0.0;
        double y = 0.0;
        double r = 0.0;
        double a1 = 0.0;
        double a2 = 0.0;
        double thickness = 0.0;
        int visibility = 0;
        int c = 0;
        DXFLineType lineType = null;
        DXFLayer l = null;
        int sln = br.getLineNumber();
        log.debug((Object)(">>Enter at line: " + sln));
        DXFCodeValuePair cvp = null;
        DXFGroupCode gc = null;
        boolean doLoop = true;
        block16: while (doLoop) {
            cvp = new DXFCodeValuePair();
            try {
                gc = cvp.read(br);
            }
            catch (DXFParseException ex) {
                throw new IOException("DXF parse error" + ex.getLocalizedMessage());
            }
            catch (EOFException e) {
                doLoop = false;
                break;
            }
            switch (gc) {
                case TYPE: {
                    String type = cvp.getStringValue();
                    br.reset();
                    doLoop = false;
                    continue block16;
                }
                case LAYER_NAME: {
                    l = univers.findLayer(cvp.getStringValue());
                    continue block16;
                }
                case COLOR: {
                    c = cvp.getShortValue();
                    continue block16;
                }
                case LINETYPE_NAME: {
                    lineType = univers.findLType(cvp.getStringValue());
                    continue block16;
                }
                case DOUBLE_1: {
                    r = cvp.getDoubleValue();
                    continue block16;
                }
                case X_1: {
                    x = cvp.getDoubleValue();
                    continue block16;
                }
                case Y_1: {
                    y = cvp.getDoubleValue();
                    continue block16;
                }
                case ANGLE_1: {
                    a1 = cvp.getDoubleValue();
                    continue block16;
                }
                case ANGLE_2: {
                    a2 = cvp.getDoubleValue();
                    continue block16;
                }
                case VISIBILITY: {
                    visibility = cvp.getShortValue();
                    continue block16;
                }
                case THICKNESS: {
                    thickness = cvp.getDoubleValue();
                    continue block16;
                }
            }
        }
        DXFArc e = new DXFArc(a1, a2, new DXFPoint(x, y, c, null, visibility, 1.0), r, lineType, c, l, visibility, thickness);
        e.setType(GeometryType.LINE);
        e.setStartingLineNumber(sln);
        e.setUnivers(univers);
        log.debug((Object)e.toString(c, r, x, y, a1, a2, visibility, thickness));
        log.debug((Object)(">>Exit at line: " + br.getLineNumber()));
        return e;
    }

    public Coordinate[] toCoordinateArray() {
        if (this._point == null || this._point._point == null || this._radius <= 0.0 || this._angle1 == this._angle2) {
            this.addError("coordinate array can not be created.");
            return null;
        }
        ArrayList<Coordinate> lc = new ArrayList<Coordinate>();
        double startAngle = this._angle1 * Math.PI / 180.0;
        double endAngle = this._angle2 * Math.PI / 180.0;
        double segAngle = Math.PI * 2 / this._radius;
        if (this._radius < 16.0) {
            segAngle = 0.39269908169872414;
        }
        double angle = startAngle;
        while (true) {
            double x = this._point.X() + this._radius * Math.cos(angle);
            double y = this._point.Y() + this._radius * Math.sin(angle);
            Coordinate c = new Coordinate(x, y);
            lc.add(c);
            if (angle >= endAngle) break;
            if (!((angle += segAngle) > endAngle)) continue;
            angle = endAngle;
        }
        return this.rotateAndPlace(lc.toArray(new Coordinate[0]));
    }

    @Override
    public Geometry getGeometry() {
        if (this.geometry == null) {
            this.updateGeometry();
        }
        return super.getGeometry();
    }

    @Override
    public void updateGeometry() {
        Coordinate[] ca = this.toCoordinateArray();
        if (ca != null && ca.length > 1) {
            this.geometry = this.getUnivers().getGeometryFactory().createLineString(ca);
        } else {
            this.addError("coordinate array faulty, size: " + (ca == null ? 0 : ca.length));
        }
    }

    public String toString(int c, double r, double x, double y, double a1, double a2, int visibility, double thickness) {
        StringBuffer s = new StringBuffer();
        s.append("DXFArc [");
        s.append("color: ");
        s.append(c + ", ");
        s.append("r: ");
        s.append(r + ", ");
        s.append("x: ");
        s.append(x + ", ");
        s.append("y: ");
        s.append(y + ", ");
        s.append("a1: ");
        s.append(a1 + ", ");
        s.append("a2: ");
        s.append(a2 + ", ");
        s.append("visibility: ");
        s.append(visibility + ", ");
        s.append("thickness: ");
        s.append(thickness);
        s.append("]");
        return s.toString();
    }

    @Override
    public DXFEntity translate(double x, double y) {
        this._point._point.x += x;
        this._point._point.y += y;
        return this;
    }

    @Override
    public DXFEntity clone() {
        return new DXFArc(this);
    }
}

