/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.geotools.data.dxf.entities;

import com.vividsolutions.jts.algorithm.Angle;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import nl.b3p.geotools.data.GeometryType;
import nl.b3p.geotools.data.dxf.header.DXFBlockReference;
import nl.b3p.geotools.data.dxf.header.DXFLayer;
import nl.b3p.geotools.data.dxf.header.DXFLineType;
import nl.b3p.geotools.data.dxf.parser.DXFColor;
import nl.b3p.geotools.data.dxf.parser.DXFConstants;
import nl.b3p.geotools.data.dxf.parser.DXFUnivers;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class DXFEntity
implements DXFConstants {
    private static final Log log = LogFactory.getLog(DXFEntity.class);
    protected GeometryType geometryType;
    protected String _name = null;
    protected String _text = null;
    protected String _textposhorizontal = null;
    protected String _textposvertical = null;
    protected Double _textheight = null;
    protected Double _textrotation = null;
    protected DXFLayer _refLayer;
    protected int _color;
    protected DXFLineType _lineType;
    protected double _thickness;
    protected boolean visible = true;
    protected int startingLineNumber = -1;
    protected String errorDescription = null;
    protected Geometry geometry = null;
    protected DXFUnivers univers;
    private double _entRotationAngle = 0.0;
    protected Coordinate _entBase = new Coordinate(0.0, 0.0);

    public DXFEntity(DXFEntity newEntity) {
        this(newEntity.getColor(), newEntity.getRefLayer(), 1, newEntity.getLineType(), newEntity.getThickness());
    }

    public DXFEntity(int c, DXFLayer l, int visibility, DXFLineType lineType, double thickness) {
        this._refLayer = l;
        if (lineType == null || !lineType._name.equalsIgnoreCase("BYLAYER") || this._refLayer != null) {
            // empty if block
        }
        this._lineType = lineType;
        if (!(this instanceof DXFBlockReference) && !(this instanceof DXFLayer) && (c < 0 || c == 255 && this._refLayer != null)) {
            c = this._refLayer == null ? DXFColor.getDefaultColorIndex() : this._refLayer._color;
        }
        this._color = c;
        this._thickness = thickness;
        this.visible = visibility == 0;
    }

    public void setBase(Coordinate coord) {
        this._entBase = coord;
    }

    public void setAngle(double angle) {
        this._entRotationAngle = angle;
    }

    public abstract DXFEntity translate(double var1, double var3);

    protected Coordinate rotateAndPlace(Coordinate coord) {
        Coordinate[] array = new Coordinate[]{coord};
        return this.rotateAndPlace(array)[0];
    }

    protected Coordinate[] rotateAndPlace(Coordinate[] coordarray) {
        for (int i = 0; i < coordarray.length; ++i) {
            coordarray[i] = this.rotateCoordDegrees(coordarray[i], this._entRotationAngle);
            coordarray[i].x += this._entBase.x;
            coordarray[i].y += this._entBase.y;
        }
        return coordarray;
    }

    private Coordinate rotateCoordDegrees(Coordinate coord, double angle) {
        angle = Angle.toRadians((double)angle);
        angle = Angle.angle((Coordinate)coord) + angle;
        Coordinate newCoord = new Coordinate(coord);
        double radius = Math.sqrt(Math.pow(coord.x, 2.0) + Math.pow(coord.y, 2.0));
        newCoord.x = radius * Math.cos(angle);
        newCoord.y = radius * Math.sin(angle);
        return newCoord;
    }

    public abstract DXFEntity clone();

    public Geometry getGeometry() {
        if (this.geometry == null) {
            this.updateGeometry();
        }
        return this.geometry;
    }

    public void updateGeometry() {
        this.geometry = this.getUnivers().getErrorGeometry();
        this.addError("error geometry created for: " + this.getClass().toString());
    }

    public String getName() {
        return this._name;
    }

    public void setName(String _name) {
        this._name = _name;
    }

    public String getText() {
        return this._text;
    }

    public void setText(String _text) {
        this._text = _text;
    }

    public Double getTextheight() {
        return this._textheight;
    }

    public void setTextheight(Double _textheight) {
        this._textheight = _textheight;
    }

    public String getTextposhorizontal() {
        return this._textposhorizontal;
    }

    public void setTextposhorizontal(String _textposhorizontal) {
        this._textposhorizontal = _textposhorizontal;
    }

    public String getTextposvertical() {
        return this._textposvertical;
    }

    public void setTextposvertical(String _textposvertical) {
        this._textposvertical = _textposvertical;
    }

    public Double getTextrotation() {
        return this._textrotation;
    }

    public void setTextrotation(Double _textrotation) {
        this._textrotation = _textrotation;
    }

    public String getErrorDescription() {
        return this.errorDescription;
    }

    public int getStartingLineNumber() {
        return this.startingLineNumber;
    }

    public void setStartingLineNumber(int startingLineNumber) {
        this.startingLineNumber = startingLineNumber;
    }

    public GeometryType getType() {
        return this.geometryType;
    }

    public void setType(GeometryType geometryType) {
        this.geometryType = geometryType;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public DXFLineType getLineType() {
        return this._lineType;
    }

    public String getLineTypeName() {
        if (this._lineType == null) {
            return "default";
        }
        return this._lineType._name;
    }

    public void setLineType(DXFLineType lineType) {
        this._lineType = lineType;
    }

    public int getColor() {
        return this._color;
    }

    public String getColorRGB() {
        return DXFColor.getColorRGB(this._color);
    }

    public void setColor(int color) {
        this._color = color;
    }

    public DXFLayer getRefLayer() {
        return this._refLayer;
    }

    public String getRefLayerName() {
        if (this._refLayer == null) {
            return "default";
        }
        return this._refLayer.getName();
    }

    public void setRefLayer(DXFLayer refLayer) {
        this._refLayer = refLayer;
    }

    public double getThickness() {
        return this._thickness;
    }

    public void setThickness(double thickness) {
        this._thickness = thickness;
    }

    public DXFUnivers getUnivers() {
        return this.univers;
    }

    public void setUnivers(DXFUnivers univers) {
        this.univers = univers;
    }

    public void addError(String msg) {
        this.errorDescription = this.errorDescription == null ? "entry starting line " + this.getStartingLineNumber() + ": " + msg : this.errorDescription + "; " + msg;
    }

    public void setErrorDescription(String errorDescription) {
        this.errorDescription = errorDescription;
    }

    public void setGeometry(Geometry geometry) {
        this.geometry = geometry;
    }
}

