/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.geotools.data.dxf.entities;

import java.awt.geom.Point2D;
import nl.b3p.geotools.data.dxf.entities.DXFEntity;
import nl.b3p.geotools.data.dxf.entities.DXFPoint;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DXFLwVertex
extends DXFPoint {
    private static final Log log = LogFactory.getLog(DXFLwVertex.class);
    double _bulge;

    public DXFLwVertex(Point2D.Double p, double bulge) {
        super(p);
        this._bulge = bulge;
        this.setName("DXFLwVertex");
    }

    public DXFLwVertex(double x, double y, double bulge) {
        super(new Point2D.Double(x, y));
        this._bulge = bulge;
        this.setName("DXFLwVertex");
    }

    public DXFLwVertex(DXFLwVertex orig, boolean bis) {
        super(orig._point.x, orig._point.y, orig.getColor(), orig.getRefLayer(), 0, 1.0);
        this._bulge = orig._bulge;
        this.setName("DXFLwVertex");
    }

    public double getBulge() {
        return this._bulge;
    }

    public String toString(double b, double x, double y) {
        StringBuffer s = new StringBuffer();
        s.append("DXFLwVertex [");
        s.append("bulge: ");
        s.append(b + ", ");
        s.append("x: ");
        s.append(x + ", ");
        s.append("y: ");
        s.append(y);
        s.append("]");
        return s.toString();
    }

    public static double GetBulgeFromEndPoints(Point2D center, Point2D arcStart, Point2D arcEnd) {
        Point2D.Double v1 = new Point2D.Double(arcStart.getX() - center.getX(), arcStart.getY() - center.getY());
        Point2D.Double yaxis = new Point2D.Double(-((Point2D)v1).getY(), ((Point2D)v1).getX());
        Point2D.Double v2 = new Point2D.Double(arcEnd.getX() - center.getX(), arcEnd.getY() - center.getY());
        double x = ((Point2D)v1).getX() * ((Point2D)v2).getX() + ((Point2D)v1).getY() * ((Point2D)v2).getY();
        double y = ((Point2D)yaxis).getX() * ((Point2D)v2).getX() + ((Point2D)yaxis).getY() * ((Point2D)v2).getY();
        double angle = Math.atan2(y, x);
        return Math.tan(angle / 4.0);
    }

    @Override
    public DXFEntity clone() {
        return new DXFLwVertex(this, true);
    }
}

