/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.geotools.data.dxf.header;

import java.awt.geom.Point2D;
import java.io.EOFException;
import java.io.IOException;
import nl.b3p.geotools.data.dxf.entities.DXFPoint;
import nl.b3p.geotools.data.dxf.parser.DXFCodeValuePair;
import nl.b3p.geotools.data.dxf.parser.DXFConstants;
import nl.b3p.geotools.data.dxf.parser.DXFGroupCode;
import nl.b3p.geotools.data.dxf.parser.DXFLineNumberReader;
import nl.b3p.geotools.data.dxf.parser.DXFParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DXFHeader
implements DXFConstants {
    private static final Log log = LogFactory.getLog(DXFHeader.class);
    public DXFPoint _LIMMIN;
    public DXFPoint _LIMMAX;
    public DXFPoint _EXTMIN;
    public DXFPoint _EXTMAX;
    public int _FILLMODE;
    public String _ACADVER;
    public int _SRID;

    public DXFHeader() {
        this._LIMMIN = new DXFPoint(new Point2D.Double(0.0, 0.0));
        this._LIMMAX = new DXFPoint(new Point2D.Double(100.0, 100.0));
        this._EXTMIN = new DXFPoint(new Point2D.Double(100.0, 100.0));
        this._EXTMAX = new DXFPoint(new Point2D.Double(50.0, 50.0));
        this._FILLMODE = 0;
        this._ACADVER = "AC1006";
        this._SRID = 28992;
    }

    public DXFHeader(DXFPoint limmin, DXFPoint limmax, DXFPoint extmin, DXFPoint extmax, int fillmode, String version, int srid) {
        this._LIMMIN = limmin;
        this._LIMMAX = limmax;
        this._EXTMIN = extmin;
        this._EXTMAX = extmax;
        this._FILLMODE = fillmode;
        this._ACADVER = version;
        this._SRID = srid;
    }

    public static DXFHeader read(DXFLineNumberReader br) throws IOException {
        Point2D.Double limmin = null;
        Point2D.Double limmax = null;
        Point2D.Double extmin = null;
        Point2D.Double extmax = null;
        int fillmode = 0;
        String version = "AC1006";
        int srid = 28992;
        int sln = br.getLineNumber();
        log.debug((Object)(">Enter at line: " + sln));
        DXFCodeValuePair cvp = null;
        DXFGroupCode gc = null;
        boolean doLoop = true;
        block18: while (doLoop) {
            cvp = new DXFCodeValuePair();
            try {
                gc = cvp.read(br);
            }
            catch (DXFParseException ex) {
                throw new IOException("DXF parse error" + ex.getLocalizedMessage());
            }
            catch (EOFException e) {
                doLoop = false;
                break;
            }
            switch (gc) {
                case TYPE: {
                    String type = cvp.getStringValue();
                    if (!type.equals("ENDSEC")) continue block18;
                    doLoop = false;
                    continue block18;
                }
                case VARIABLE_NAME: {
                    String type;
                    String variableName = cvp.getStringValue();
                    double x = 0.0;
                    double y = 0.0;
                    short tfillmode = 0;
                    String tversion = null;
                    boolean doLoop2 = true;
                    block19: while (doLoop2) {
                        cvp = new DXFCodeValuePair();
                        try {
                            gc = cvp.read(br);
                        }
                        catch (DXFParseException ex) {
                            throw new IOException("DXF parse error" + ex.getLocalizedMessage());
                        }
                        catch (EOFException e) {
                            doLoop2 = false;
                            doLoop = false;
                            break;
                        }
                        switch (gc) {
                            case TYPE: {
                                type = cvp.getStringValue();
                                if (!type.equals("ENDSEC")) continue block19;
                                doLoop = false;
                                doLoop2 = false;
                                continue block19;
                            }
                            case VARIABLE_NAME: {
                                doLoop2 = false;
                                br.reset();
                                continue block19;
                            }
                            case X_1: {
                                x = cvp.getDoubleValue();
                                continue block19;
                            }
                            case Y_1: {
                                y = cvp.getDoubleValue();
                                continue block19;
                            }
                            case TEXT: {
                                tversion = cvp.getStringValue();
                                continue block19;
                            }
                            case INT_1: {
                                tfillmode = cvp.getShortValue();
                                continue block19;
                            }
                        }
                    }
                    if (variableName.equals("$LIMMIN")) {
                        limmin = new Point2D.Double(x, y);
                        continue block18;
                    }
                    if (variableName.equals("$LIMMAX")) {
                        limmax = new Point2D.Double(x, y);
                        continue block18;
                    }
                    if (variableName.equals("$EXTMIN")) {
                        extmin = new Point2D.Double(x, y);
                        continue block18;
                    }
                    if (variableName.equals("$EXTMAX")) {
                        extmax = new Point2D.Double(x, y);
                        continue block18;
                    }
                    if (variableName.equals("$ACADVER")) {
                        version = tversion;
                        continue block18;
                    }
                    if (!variableName.equals("$FILLMODE")) continue block18;
                    fillmode = tfillmode;
                    continue block18;
                }
            }
        }
        DXFHeader e = new DXFHeader(new DXFPoint(limmin, -1, null, 1, 1.0f), new DXFPoint(limmax, -1, null, 1, 1.0f), new DXFPoint(extmin, -1, null, 1, 1.0f), new DXFPoint(extmax, -1, null, 1, 1.0f), fillmode, version, srid);
        log.debug((Object)e.toString(limmin, limmax, extmin, extmax, fillmode, version, srid));
        log.debug((Object)(">Exit at line: " + br.getLineNumber()));
        return e;
    }

    public String toString(Point2D.Double limmin, Point2D.Double limmax, Point2D.Double extmin, Point2D.Double extmax, int fillmode, String version, int srid) {
        StringBuffer s = new StringBuffer();
        s.append("DXFHeader [");
        s.append("limmin: ");
        s.append(limmin + ", ");
        s.append("limmax: ");
        s.append(limmax + ", ");
        s.append("extmin: ");
        s.append(extmin + ", ");
        s.append("extmax: ");
        s.append(extmax + ", ");
        s.append("fillmode: ");
        s.append(fillmode + ",");
        s.append("srid: ");
        s.append(srid + ",");
        s.append("version: ");
        s.append(version);
        s.append("]");
        return s.toString();
    }
}

