/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.geotools.data.dxf.entities;

import java.io.EOFException;
import java.io.IOException;
import nl.b3p.geotools.data.GeometryType;
import nl.b3p.geotools.data.dxf.entities.DXFEntity;
import nl.b3p.geotools.data.dxf.entities.DXFPoint;
import nl.b3p.geotools.data.dxf.header.DXFLayer;
import nl.b3p.geotools.data.dxf.header.DXFLineType;
import nl.b3p.geotools.data.dxf.parser.DXFCodeValuePair;
import nl.b3p.geotools.data.dxf.parser.DXFGroupCode;
import nl.b3p.geotools.data.dxf.parser.DXFLineNumberReader;
import nl.b3p.geotools.data.dxf.parser.DXFParseException;
import nl.b3p.geotools.data.dxf.parser.DXFUnivers;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;

public class DXFLine
extends DXFEntity {
    private static final Log log = LogFactory.getLog(DXFLine.class);
    public DXFPoint _a = new DXFPoint();
    public DXFPoint _b = new DXFPoint();

    public DXFLine(DXFLine newLine) {
        this(new DXFPoint(newLine._a._point.x, newLine._a._point.y, newLine.getColor(), null, 0, newLine.getThickness()), new DXFPoint(newLine._b._point.x, newLine._b._point.y, newLine.getColor(), null, 0, newLine.getThickness()), newLine.getColor(), newLine.getRefLayer(), newLine.getLineType(), newLine.getThickness(), 0);
        this.setType(newLine.getType());
        this.setStartingLineNumber(newLine.getStartingLineNumber());
        this.setUnivers(newLine.getUnivers());
    }

    public DXFLine(DXFPoint a, DXFPoint b, int c, DXFLayer l, DXFLineType lineType, double thickness, int visibility) {
        super(c, l, visibility, lineType, thickness);
        this._a = a;
        this._b = b;
        this.setName("DXFLine");
    }

    public static DXFLine read(DXFLineNumberReader br, DXFUnivers univers) throws IOException {
        DXFLayer l = null;
        double x1 = 0.0;
        double y1 = 0.0;
        double x2 = 0.0;
        double y2 = 0.0;
        double thickness = 0.0;
        DXFLineType lineType = null;
        int visibility = 1;
        int c = -1;
        int sln = br.getLineNumber();
        log.debug((Object)(">>Enter at line: " + sln));
        DXFCodeValuePair cvp = null;
        DXFGroupCode gc = null;
        boolean doLoop = true;
        block15: while (doLoop) {
            cvp = new DXFCodeValuePair();
            try {
                gc = cvp.read(br);
            }
            catch (DXFParseException ex) {
                throw new IOException("DXF parse error" + ex.getLocalizedMessage());
            }
            catch (EOFException e) {
                doLoop = false;
                break;
            }
            switch (gc) {
                case TYPE: {
                    String type = cvp.getStringValue();
                    br.reset();
                    doLoop = false;
                    continue block15;
                }
                case X_1: {
                    x1 = cvp.getDoubleValue();
                    continue block15;
                }
                case Y_1: {
                    y1 = cvp.getDoubleValue();
                    continue block15;
                }
                case X_2: {
                    x2 = cvp.getDoubleValue();
                    continue block15;
                }
                case Y_2: {
                    y2 = cvp.getDoubleValue();
                    continue block15;
                }
                case LAYER_NAME: {
                    l = univers.findLayer(cvp.getStringValue());
                    continue block15;
                }
                case COLOR: {
                    c = cvp.getShortValue();
                    continue block15;
                }
                case LINETYPE_NAME: {
                    lineType = univers.findLType(cvp.getStringValue());
                    continue block15;
                }
                case THICKNESS: {
                    thickness = cvp.getDoubleValue();
                    continue block15;
                }
                case VISIBILITY: {
                    visibility = cvp.getShortValue();
                    continue block15;
                }
            }
        }
        DXFLine e = new DXFLine(new DXFPoint(x1, y1, c, l, visibility, 1.0), new DXFPoint(x2, y2, c, l, visibility, 1.0), c, l, lineType, thickness, visibility);
        e.setType(GeometryType.LINE);
        e.setStartingLineNumber(sln);
        e.setUnivers(univers);
        log.debug((Object)e.toString(x1, y1, x2, y2, c, visibility, thickness));
        log.debug((Object)(">Exit at line: " + br.getLineNumber()));
        return e;
    }

    public Coordinate[] toCoordinateArray() {
        if (this._a == null || this._b == null) {
            this.addError("coordinate array can not be created.");
            return null;
        }
        return this.rotateAndPlace(new Coordinate[]{this._a.toCoordinate(), this._b.toCoordinate()});
    }

    @Override
    public Geometry getGeometry() {
        if (this.geometry == null) {
            this.updateGeometry();
        }
        return super.getGeometry();
    }

    @Override
    public void updateGeometry() {
        Coordinate[] ca = this.toCoordinateArray();
        if (ca != null && ca.length > 1) {
            this.geometry = this.getUnivers().getGeometryFactory().createLineString(ca);
        } else {
            this.addError("coordinate array faulty, size: " + (ca == null ? 0 : ca.length));
        }
    }

    public String toString(double x1, double y1, double x2, double y2, int c, int visibility, double thickness) {
        StringBuffer s = new StringBuffer();
        s.append("DXFLine [");
        s.append("x1: ");
        s.append(x1 + ", ");
        s.append("y1: ");
        s.append(y1 + ", ");
        s.append("x2: ");
        s.append(x2 + ", ");
        s.append("y2: ");
        s.append(y2 + ", ");
        s.append("color: ");
        s.append(c + ", ");
        s.append("visibility: ");
        s.append(visibility + ", ");
        s.append("thickness: ");
        s.append(thickness);
        s.append("]");
        return s.toString();
    }

    @Override
    public DXFEntity translate(double x, double y) {
        this._a._point.x += x;
        this._a._point.y += y;
        this._b._point.x += x;
        this._b._point.y += y;
        return this;
    }

    @Override
    public DXFEntity clone() {
        return new DXFLine(this);
    }
}

