/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.geotools.data.dxf.parser;

import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import java.util.Vector;
import nl.b3p.geotools.data.GeometryType;
import nl.b3p.geotools.data.dxf.entities.DXFEntity;
import nl.b3p.geotools.data.dxf.entities.DXFInsert;
import nl.b3p.geotools.data.dxf.entities.DXFPoint;
import nl.b3p.geotools.data.dxf.header.DXFBlock;
import nl.b3p.geotools.data.dxf.header.DXFBlockReference;
import nl.b3p.geotools.data.dxf.header.DXFBlocks;
import nl.b3p.geotools.data.dxf.header.DXFEntities;
import nl.b3p.geotools.data.dxf.header.DXFHeader;
import nl.b3p.geotools.data.dxf.header.DXFLayer;
import nl.b3p.geotools.data.dxf.header.DXFLineType;
import nl.b3p.geotools.data.dxf.header.DXFTables;
import nl.b3p.geotools.data.dxf.parser.DXFCodeValuePair;
import nl.b3p.geotools.data.dxf.parser.DXFColor;
import nl.b3p.geotools.data.dxf.parser.DXFConstants;
import nl.b3p.geotools.data.dxf.parser.DXFGroupCode;
import nl.b3p.geotools.data.dxf.parser.DXFLineNumberReader;
import nl.b3p.geotools.data.dxf.parser.DXFParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.PrecisionModel;

public class DXFUnivers
implements DXFConstants {
    private static final Log log = LogFactory.getLog(DXFUnivers.class);
    public static final PrecisionModel precisionModel = new PrecisionModel(PrecisionModel.FLOATING);
    public static final int NUM_OF_SEGMENTS = 16;
    public static final double MIN_ANGLE = 0.39269908169872414;
    private Vector<DXFBlockReference> _entForUpdate = new Vector();
    public Vector<DXFTables> theTables = new Vector();
    public Vector<DXFBlock> theBlocks = new Vector();
    public Vector<DXFEntity> theEntities = new Vector();
    private DXFHeader _header;
    private GeometryFactory geometryFactory = null;
    private Geometry errorGeometry = null;
    private HashMap insertsFound = new HashMap();
    private ArrayList dxfInsertsFilter;
    private String info = "";

    public DXFUnivers(ArrayList dxfInsertsFilter) {
        this.dxfInsertsFilter = dxfInsertsFilter;
    }

    public boolean isFilteredInsert(String blockName) {
        return this.dxfInsertsFilter.contains(blockName);
    }

    public void read(DXFLineNumberReader br) throws IOException {
        DXFCodeValuePair cvp = null;
        DXFGroupCode gc = null;
        boolean doLoop = true;
        block6: while (doLoop) {
            cvp = new DXFCodeValuePair();
            try {
                gc = cvp.read(br);
            }
            catch (DXFParseException ex) {
                throw new IOException("DXF parse error" + ex.getLocalizedMessage());
            }
            catch (EOFException e) {
                doLoop = false;
                break;
            }
            switch (gc) {
                case TYPE: {
                    String type = cvp.getStringValue();
                    if (!type.equals("SECTION")) continue block6;
                    this.readSection(br);
                    continue block6;
                }
            }
        }
        this.updateRefBlock();
    }

    public void readSection(DXFLineNumberReader br) throws IOException {
        DXFCodeValuePair cvp = null;
        DXFGroupCode gc = null;
        HashMap<String, Integer> unsupportedEntitiesCounts = new HashMap<String, Integer>();
        boolean doLoop = true;
        block7: while (doLoop) {
            cvp = new DXFCodeValuePair();
            try {
                gc = cvp.read(br);
            }
            catch (DXFParseException ex) {
                throw new IOException("DXF parse error" + ex.getLocalizedMessage());
            }
            catch (EOFException e) {
                doLoop = false;
                break;
            }
            switch (gc) {
                case TYPE: {
                    String type = cvp.getStringValue();
                    if (!type.equals("ENDSEC")) continue block7;
                    doLoop = false;
                    continue block7;
                }
                case NAME: {
                    String name = cvp.getStringValue();
                    if (name.equals("HEADER")) {
                        this._header = DXFHeader.read(br);
                        if (this._header._EXTMAX == null || this._header._EXTMIN == null) {
                            this._header = new DXFHeader();
                        }
                        this.geometryFactory = new GeometryFactory(precisionModel, this._header._SRID);
                        continue block7;
                    }
                    if (name.equals("TABLES")) {
                        DXFTables at = DXFTables.readTables(br, this);
                        this.theTables.add(at);
                        continue block7;
                    }
                    if (name.equals("BLOCKS")) {
                        DXFBlocks ab = DXFBlocks.readBlocks(br, this);
                        this.theBlocks.addAll(ab.theBlocks);
                        continue block7;
                    }
                    if (!name.equals("ENTITIES")) continue block7;
                    DXFEntities dxfes = DXFEntities.readEntities(br, this);
                    this.theEntities.addAll(dxfes.theEntities);
                    for (Map.Entry<String, Integer> entry : dxfes.unsupportedEntitiesCounts.entrySet()) {
                        Integer count = (Integer)unsupportedEntitiesCounts.get(entry.getKey());
                        if (count == null) {
                            count = 0;
                        }
                        count = count + entry.getValue();
                        unsupportedEntitiesCounts.put(entry.getKey(), count);
                    }
                    continue block7;
                }
            }
        }
        if (unsupportedEntitiesCounts.isEmpty()) {
            log.debug((Object)"No unsupported entities found in this section");
        } else {
            log.info((Object)"Unsupported entities found:");
            TreeSet types = new TreeSet(unsupportedEntitiesCounts.keySet());
            for (String type : types) {
                int c = (Integer)unsupportedEntitiesCounts.get(type);
                log.info((Object)(" " + type + ": " + c + " time" + (c > 1 ? "s" : "")));
            }
        }
    }

    public DXFBlock findBlock(String nom) {
        DXFBlock b = null;
        for (int i = 0; i < this.theBlocks.size(); ++i) {
            if (!this.theBlocks.elementAt((int)i)._name.equals(nom)) continue;
            this.insertsFound.put(nom, true);
            return this.theBlocks.elementAt(i);
        }
        return b;
    }

    public DXFLayer findLayer(String nom) {
        DXFLayer l = null;
        for (int i = 0; i < this.theTables.size(); ++i) {
            for (int j = 0; j < this.theTables.elementAt((int)i).theLayers.size(); ++j) {
                if (!this.theTables.elementAt((int)i).theLayers.elementAt(j).getName().equals(nom)) continue;
                l = this.theTables.elementAt((int)i).theLayers.elementAt(j);
                return l;
            }
        }
        l = new DXFLayer(nom, DXFColor.getDefaultColorIndex());
        if (this.theTables.size() < 1) {
            this.theTables.add(new DXFTables());
        }
        this.theTables.elementAt((int)0).theLayers.add(l);
        return l;
    }

    public DXFLineType findLType(String name) {
        for (int i = 0; i < this.theTables.size(); ++i) {
            for (int j = 0; j < this.theTables.elementAt((int)i).theLineTypes.size(); ++j) {
                if (!this.theTables.elementAt((int)i).theLineTypes.elementAt((int)j)._name.equals(name)) continue;
                return this.theTables.elementAt((int)i).theLineTypes.elementAt(j);
            }
        }
        return null;
    }

    public void addRefBlockForUpdate(DXFBlockReference obj) {
        this._entForUpdate.add(obj);
    }

    public void updateRefBlock() {
        DXFBlockReference bro = null;
        int numInserts = 0;
        for (int i = 0; i < this._entForUpdate.size(); ++i) {
            DXFBlock b;
            bro = this._entForUpdate.get(i);
            boolean isInsert = false;
            if (bro instanceof DXFInsert) {
                ++numInserts;
                isInsert = true;
            }
            if (!this.insertsFound.containsKey(bro._blockName)) {
                this.insertsFound.put(bro._blockName, false);
            }
            if ((b = this.findBlock(bro._blockName)) != null && bro.getType() != GeometryType.UNSUPPORTED) {
                Vector<DXFEntity> refBlockEntities;
                double x = b._point.X();
                double y = b._point.Y();
                if (isInsert) {
                    DXFPoint entPoint = ((DXFInsert)bro)._point;
                    x = entPoint._point.getX();
                    y = entPoint._point.getY();
                }
                if ((refBlockEntities = b.theEntities) != null) {
                    Iterator<DXFEntity> it = refBlockEntities.iterator();
                    while (it.hasNext()) {
                        DXFEntity e;
                        DXFEntity dXFEntity = e = isInsert ? it.next().clone() : it.next();
                        if (isInsert) {
                            e.setBase(((DXFInsert)bro)._point.toCoordinate());
                            e.setAngle(((DXFInsert)bro)._angle);
                        }
                        e.updateGeometry();
                        this.theEntities.add(e);
                    }
                }
            } else {
                log.error((Object)("Can not update refblock: " + bro.getName() + " - " + bro._blockName + " at " + bro.getStartingLineNumber()));
            }
            if (isInsert) continue;
            this.theEntities.remove(bro);
        }
        if (this._entForUpdate.size() > 0) {
            this.info = this.info + "Num of Blocks: " + this._entForUpdate.size() + " of which Inserts: " + numInserts + "\n";
            HashMap<String, Integer> list = new HashMap<String, Integer>();
            for (int i = 0; i < this._entForUpdate.size(); ++i) {
                if (!(this._entForUpdate.get(i) instanceof DXFInsert)) continue;
                DXFInsert fg = (DXFInsert)this._entForUpdate.get(i);
                String name = fg._blockName;
                if (!list.containsKey(name)) {
                    list.put(name, 1);
                    continue;
                }
                list.put(name, (Integer)list.get(name) + 1);
            }
            ArrayList arrayList = new ArrayList(list.keySet());
            Collections.sort(arrayList);
            for (String key : arrayList) {
                String value = Integer.toString((Integer)list.get(key));
                String found = (Boolean)this.insertsFound.get(key) != false ? "" : (this.isFilteredInsert(key) ? "Filtered" : "Missing");
                key = DXFUnivers.makeTabs(key, 31);
                value = DXFUnivers.makeTabs(value, 12);
                this.info = this.info + key + value + found + "\n";
            }
        }
        this._entForUpdate.removeAllElements();
    }

    public String getInfo() {
        return this.info;
    }

    public GeometryFactory getGeometryFactory() {
        if (this.geometryFactory == null) {
            this.geometryFactory = new GeometryFactory(precisionModel);
        }
        return this.geometryFactory;
    }

    public void setGeometryFactory(GeometryFactory geometryFactory) {
        this.geometryFactory = geometryFactory;
    }

    public Geometry getErrorGeometry() {
        if (this.errorGeometry == null && this.geometryFactory != null) {
            this.errorGeometry = this.geometryFactory.createPoint(new Coordinate(0.0, 0.0));
        }
        return this.errorGeometry;
    }

    public void setErrorGeometry(Geometry errorGeometry) {
        this.errorGeometry = errorGeometry;
    }

    public static String makeTabs(String text, int length) {
        for (int i = text.length() - 1; i < length; ++i) {
            text = text + " ";
        }
        return text;
    }
}

