/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.geotools.data.dxf.parser;

import java.io.IOException;
import nl.b3p.geotools.data.dxf.parser.DXFGroupCode;
import nl.b3p.geotools.data.dxf.parser.DXFLineNumberReader;
import nl.b3p.geotools.data.dxf.parser.DXFParseException;
import nl.b3p.geotools.data.dxf.parser.DXFValueType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DXFCodeValuePair {
    private static final Log log = LogFactory.getLog(DXFCodeValuePair.class);
    private DXFGroupCode gc;
    private short shortValue = 0;
    private int intValue = 0;
    private String stringValue = null;
    private boolean booleanValue = false;
    private double doubleValue = 0.0;
    private long longValue = 0L;
    private String handleHexValue = null;
    private String idHexValue = null;
    private String binHexValue = null;

    public DXFGroupCode read(DXFLineNumberReader br) throws IOException, DXFParseException {
        int gcInt;
        br.mark();
        String regel = br.readLine();
        try {
            gcInt = Integer.parseInt(regel);
        }
        catch (NumberFormatException nfe) {
            throw new DXFParseException(br, "Unknown Group Code: " + regel);
        }
        this.gc = DXFGroupCode.getGroupCode(gcInt);
        regel = br.readLine();
        switch (this.gc.toType()) {
            case STRING: {
                this.stringValue = regel;
                break;
            }
            case HANDLEHEX: {
                this.handleHexValue = regel;
                break;
            }
            case IDHEX: {
                this.idHexValue = regel;
                break;
            }
            case BINHEX: {
                this.binHexValue = regel;
                break;
            }
            case SHORT: {
                this.shortValue = Short.parseShort(regel);
                break;
            }
            case INTEGER: {
                this.intValue = Integer.parseInt(regel);
                break;
            }
            case LONG: {
                this.longValue = Long.parseLong(regel);
                break;
            }
            case BOOLEAN: {
                this.booleanValue = Boolean.parseBoolean(regel);
                break;
            }
            case DOUBLE: {
                this.doubleValue = Double.parseDouble(regel);
                break;
            }
            default: {
                throw new DXFParseException(br, "Unknown value type for Group Code: " + (Object)((Object)this.gc));
            }
        }
        return this.gc;
    }

    public DXFGroupCode getGc() {
        return this.gc;
    }

    private IllegalArgumentException wrongTypeException(String askedType) {
        return new IllegalArgumentException("Wrong value type requested (" + askedType + ") for group code #" + this.gc.toInt() + " which is of type " + (Object)((Object)this.gc.toType()));
    }

    public short getShortValue() throws IllegalArgumentException {
        if (!DXFValueType.SHORT.equals((Object)this.gc.toType())) {
            throw this.wrongTypeException("short");
        }
        return this.shortValue;
    }

    public int getIntValue() throws IllegalArgumentException {
        if (!DXFValueType.INTEGER.equals((Object)this.gc.toType())) {
            throw this.wrongTypeException("integer");
        }
        return this.intValue;
    }

    public String getStringValue() throws IllegalArgumentException {
        if (!DXFValueType.STRING.equals((Object)this.gc.toType())) {
            throw this.wrongTypeException("string");
        }
        return this.stringValue;
    }

    public boolean isBooleanValue() throws IllegalArgumentException {
        if (!DXFValueType.BOOLEAN.equals((Object)this.gc.toType())) {
            throw this.wrongTypeException("boolean");
        }
        return this.booleanValue;
    }

    public double getDoubleValue() throws IllegalArgumentException {
        if (!DXFValueType.DOUBLE.equals((Object)this.gc.toType())) {
            throw this.wrongTypeException("double");
        }
        return this.doubleValue;
    }

    public long getLongValue() throws IllegalArgumentException {
        if (!DXFValueType.LONG.equals((Object)this.gc.toType())) {
            throw this.wrongTypeException("long");
        }
        return this.longValue;
    }

    public String getHandleHexValue() throws IllegalArgumentException {
        if (!DXFValueType.HANDLEHEX.equals((Object)this.gc.toType())) {
            throw this.wrongTypeException("handlehex");
        }
        return this.handleHexValue;
    }

    public String getIdHexValue() throws IllegalArgumentException {
        if (!DXFValueType.IDHEX.equals((Object)this.gc.toType())) {
            throw this.wrongTypeException("idhex");
        }
        return this.idHexValue;
    }

    public String getBinHexValue() throws IllegalArgumentException {
        if (!DXFValueType.BINHEX.equals((Object)this.gc.toType())) {
            throw new Error("Wrong Value Type for Group Code!");
        }
        return this.binHexValue;
    }
}

