/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.geotools.data.dxf.entities;

import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import nl.b3p.geotools.data.GeometryType;
import nl.b3p.geotools.data.dxf.entities.DXFEntity;
import nl.b3p.geotools.data.dxf.entities.DXFVertex;
import nl.b3p.geotools.data.dxf.header.DXFLayer;
import nl.b3p.geotools.data.dxf.header.DXFLineType;
import nl.b3p.geotools.data.dxf.parser.DXFCodeValuePair;
import nl.b3p.geotools.data.dxf.parser.DXFGroupCode;
import nl.b3p.geotools.data.dxf.parser.DXFLineNumberReader;
import nl.b3p.geotools.data.dxf.parser.DXFParseException;
import nl.b3p.geotools.data.dxf.parser.DXFUnivers;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LinearRing;

public class DXFPolyline
extends DXFEntity {
    private static final Log log = LogFactory.getLog(DXFPolyline.class);
    public String _id;
    public int _flag = 0;
    public Vector<DXFVertex> theVertex = new Vector();

    public DXFPolyline(DXFPolyline newPolyLine) {
        super(newPolyLine.getColor(), newPolyLine.getRefLayer(), 0, newPolyLine.getLineType(), newPolyLine.getThickness());
        this._id = newPolyLine._id;
        for (int i = 0; i < newPolyLine.theVertex.size(); ++i) {
            this.theVertex.add(new DXFVertex(newPolyLine.theVertex.elementAt(i)));
        }
        this._flag = newPolyLine._flag;
        this.setType(newPolyLine.getType());
        this.setStartingLineNumber(newPolyLine.getStartingLineNumber());
        this.setUnivers(newPolyLine.getUnivers());
        this.setName("DXFPolyline");
    }

    public DXFPolyline(String name, int flag, int c, DXFLayer l, Vector<DXFVertex> v, int visibility, DXFLineType lineType, double thickness) {
        super(c, l, visibility, lineType, thickness);
        this._id = name;
        if (v == null) {
            v = new Vector();
        }
        this.theVertex = v;
        this._flag = flag;
        this.setName("DXFPolyline");
    }

    public static DXFPolyline read(DXFLineNumberReader br, DXFUnivers univers) throws IOException {
        String name = "";
        int visibility = 0;
        int flag = 0;
        int c = -1;
        DXFLineType lineType = null;
        Vector<DXFVertex> lv = new Vector<DXFVertex>();
        DXFLayer l = null;
        int sln = br.getLineNumber();
        log.debug((Object)(">>Enter at line: " + sln));
        DXFCodeValuePair cvp = null;
        DXFGroupCode gc = null;
        boolean doLoop = true;
        block12: while (doLoop) {
            cvp = new DXFCodeValuePair();
            try {
                gc = cvp.read(br);
            }
            catch (DXFParseException ex) {
                throw new IOException("DXF parse error " + ex.getLocalizedMessage());
            }
            catch (EOFException e) {
                doLoop = false;
                break;
            }
            switch (gc) {
                case TYPE: {
                    String type = cvp.getStringValue();
                    if ("SEQEND".equals(type)) {
                        doLoop = false;
                        continue block12;
                    }
                    if ("VERTEX".equals(type)) {
                        lv.add(DXFVertex.read(br, univers));
                        continue block12;
                    }
                    br.reset();
                    doLoop = false;
                    continue block12;
                }
                case NAME: {
                    name = cvp.getStringValue();
                    continue block12;
                }
                case LAYER_NAME: {
                    l = univers.findLayer(cvp.getStringValue());
                    continue block12;
                }
                case LINETYPE_NAME: {
                    lineType = univers.findLType(cvp.getStringValue());
                    continue block12;
                }
                case COLOR: {
                    c = cvp.getShortValue();
                    continue block12;
                }
                case INT_1: {
                    flag = cvp.getShortValue();
                    continue block12;
                }
                case VISIBILITY: {
                    visibility = cvp.getShortValue();
                    continue block12;
                }
            }
        }
        DXFPolyline e = new DXFPolyline(name, flag, c, l, lv, visibility, lineType, 1.0);
        if ((flag & 1) == 1) {
            e.setType(GeometryType.POLYGON);
        } else {
            e.setType(GeometryType.LINE);
        }
        e.setStartingLineNumber(sln);
        e.setUnivers(univers);
        log.debug((Object)e.toString(name, flag, lv.size(), c, visibility, 1.0));
        log.debug((Object)(">>Exit at line: " + br.getLineNumber()));
        return e;
    }

    public String toString(String name, int flag, int numVert, int c, int visibility, double thickness) {
        StringBuffer s = new StringBuffer();
        s.append("DXFPolyline [");
        s.append("name: ");
        s.append(name + ", ");
        s.append("flag: ");
        s.append(flag + ", ");
        s.append("numVert: ");
        s.append(numVert + ", ");
        s.append("color: ");
        s.append(c + ", ");
        s.append("visibility: ");
        s.append(visibility + ", ");
        s.append("thickness: ");
        s.append(thickness);
        s.append("]");
        return s.toString();
    }

    @Override
    public Geometry getGeometry() {
        if (this.geometry == null) {
            this.updateGeometry();
        }
        return super.getGeometry();
    }

    @Override
    public void updateGeometry() {
        Coordinate[] ca = this.toCoordinateArray();
        if (ca != null && ca.length > 1) {
            if (this.getType() == GeometryType.POLYGON) {
                LinearRing lr = this.getUnivers().getGeometryFactory().createLinearRing(ca);
                this.geometry = this.getUnivers().getGeometryFactory().createPolygon(lr, null);
            } else {
                this.geometry = this.getUnivers().getGeometryFactory().createLineString(ca);
            }
        } else {
            this.addError("coordinate array faulty, size: " + (ca == null ? 0 : ca.length));
        }
    }

    public Coordinate[] toCoordinateArray() {
        Coordinate lastc;
        Coordinate firstc;
        if (this.theVertex == null) {
            this.addError("coordinate array can not be created.");
            return null;
        }
        Iterator<DXFVertex> it = this.theVertex.iterator();
        ArrayList<Coordinate> lc = new ArrayList<Coordinate>();
        while (it.hasNext()) {
            DXFVertex v = it.next();
            lc.add(v.toCoordinate());
        }
        if (this.getType() == GeometryType.POLYGON && lc.size() >= 2 && !(firstc = (Coordinate)lc.get(0)).equals2D(lastc = (Coordinate)lc.get(lc.size() - 1))) {
            lc.add(firstc);
        }
        return this.rotateAndPlace(lc.toArray(new Coordinate[0]));
    }

    @Override
    public DXFEntity translate(double x, double y) {
        for (DXFVertex vertex : this.theVertex) {
            vertex._point.x += x;
            vertex._point.y += y;
        }
        return this;
    }

    @Override
    public DXFEntity clone() {
        return new DXFPolyline(this);
    }
}

