/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.geotools.data.dxf.header;

import java.io.EOFException;
import java.io.IOException;
import java.util.Vector;
import nl.b3p.geotools.data.dxf.entities.DXFEntity;
import nl.b3p.geotools.data.dxf.parser.DXFCodeValuePair;
import nl.b3p.geotools.data.dxf.parser.DXFConstants;
import nl.b3p.geotools.data.dxf.parser.DXFGroupCode;
import nl.b3p.geotools.data.dxf.parser.DXFLineNumberReader;
import nl.b3p.geotools.data.dxf.parser.DXFParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DXFLayer
extends DXFEntity
implements DXFConstants {
    private static final Log log = LogFactory.getLog(DXFLayer.class);
    public static final String DEFAULT_NAME = "default";
    public int _flag = 0;
    public Vector<DXFEntity> theEnt = new Vector();

    public DXFLayer(String nom, int c) {
        super(c, null, 0, null, 1.0);
        this.setName(nom);
    }

    public DXFLayer(String nom, int c, int flag) {
        super(c, null, 0, null, 1.0);
        this.setName(nom);
        this._flag = flag;
    }

    @Override
    public void setVisible(boolean bool) {
        super.setVisible(bool);
        for (int i = 0; i < this.theEnt.size(); ++i) {
            this.theEnt.get(i).setVisible(bool);
        }
    }

    public static DXFLayer read(DXFLineNumberReader br) throws NumberFormatException, IOException {
        String name = "";
        int f = 0;
        int color = 0;
        DXFCodeValuePair cvp = null;
        DXFGroupCode gc = null;
        int sln = br.getLineNumber();
        log.debug((Object)(">>Enter at line: " + sln));
        boolean doLoop = true;
        block9: while (doLoop) {
            cvp = new DXFCodeValuePair();
            try {
                gc = cvp.read(br);
            }
            catch (DXFParseException ex) {
                throw new IOException("DXF parse error" + ex.getLocalizedMessage());
            }
            catch (EOFException e) {
                doLoop = false;
                break;
            }
            switch (gc) {
                case TYPE: 
                case VARIABLE_NAME: {
                    br.reset();
                    doLoop = false;
                    continue block9;
                }
                case NAME: {
                    name = cvp.getStringValue();
                    continue block9;
                }
                case COLOR: {
                    color = cvp.getShortValue();
                    continue block9;
                }
                case INT_1: {
                    f = cvp.getShortValue();
                    continue block9;
                }
            }
        }
        DXFLayer l = new DXFLayer(name, color, f);
        if (color < 0) {
            l.setVisible(false);
        }
        log.debug((Object)l.toString(name, color, f));
        log.debug((Object)(">Exit at line: " + br.getLineNumber()));
        return l;
    }

    public String toString(String name, int color, int f) {
        StringBuffer s = new StringBuffer();
        s.append("DXFLayer [");
        s.append("name: ");
        s.append(name + ", ");
        s.append("color: ");
        s.append(color + ", ");
        s.append("f: ");
        s.append(f);
        s.append("]");
        return s.toString();
    }

    @Override
    public DXFEntity translate(double x, double y) {
        return this;
    }

    @Override
    public DXFEntity clone() {
        return this;
    }
}

