/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.geotools.data.dxf.parser;

import nl.b3p.geotools.data.dxf.entities.DXFEntity;
import nl.b3p.geotools.data.dxf.parser.DXFLineNumberReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DXFParseException
extends Exception {
    private static final Log log = LogFactory.getLog(DXFParseException.class);
    private String message;

    public DXFParseException(DXFLineNumberReader reader, String message) {
        this.message = "line " + reader.getLineNumber() + ": " + message;
    }

    public DXFParseException(DXFEntity entry, String message) {
        this.message = "entry starting at line " + entry.getStartingLineNumber() + ": " + message;
    }

    public DXFParseException(DXFEntity entry, String message, Exception cause) {
        super(cause);
        this.message = "entry starting at line " + entry.getStartingLineNumber() + ": " + message;
    }

    @Override
    public String getMessage() {
        return this.message;
    }
}

