/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.geotools.data.dxf;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import nl.b3p.geotools.data.GeometryType;
import nl.b3p.geotools.data.dxf.DXFFeatureReader;
import nl.b3p.geotools.data.dxf.parser.DXFParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureWriter;
import org.geotools.data.FileDataStore;
import org.geotools.data.LockingManager;
import org.geotools.data.Query;
import org.geotools.data.ServiceInfo;
import org.geotools.data.Transaction;
import org.geotools.data.collection.CollectionFeatureSource;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.feature.NameImpl;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;

public class DXFDataStore
implements FileDataStore {
    private static final Log LOG = LogFactory.getLog(DXFDataStore.class);
    private final URL url;
    private FeatureReader featureReader;
    private final String srs;
    private final String strippedFileName;
    public String typeName;
    private final ArrayList dxfInsertsFilter = new ArrayList();

    static String getURLTypeName(URL url) throws IOException {
        String file = url.getFile();
        if (file.length() == 0) {
            return "unknown_dxf";
        }
        int i = file.lastIndexOf(47);
        if (i != -1) {
            file = file.substring(i + 1);
        }
        if (file.toLowerCase().endsWith(".dxf")) {
            file = file.substring(0, file.length() - 4);
        }
        file = file.replaceAll(" ", "_");
        return file;
    }

    public DXFDataStore(URL url, String srs) throws IOException {
        this.url = url;
        this.strippedFileName = DXFDataStore.getURLTypeName(url);
        this.srs = srs;
    }

    public String[] getTypeNames() throws IOException {
        return GeometryType.getTypeNames(this.strippedFileName, GeometryType.ALL);
    }

    public void addDXFInsertFilter(String[] filteredNames) {
        this.dxfInsertsFilter.addAll(Arrays.asList(filteredNames));
    }

    public void addDXFInsertFilter(String filteredName) {
        this.dxfInsertsFilter.add(filteredName);
    }

    public SimpleFeatureType getSchema(Name name) throws IOException {
        return this.getSchema(name.getLocalPart());
    }

    public SimpleFeatureType getSchema(String typeName) throws IOException {
        return (SimpleFeatureType)this.getFeatureReader(typeName).getFeatureType();
    }

    public SimpleFeatureType getSchema() throws IOException {
        if (this.typeName == null) {
            LOG.warn((Object)"Typename is null, probably because of using getFeatureSource(). Please use getFeatureSource(typename)");
        }
        return this.getSchema(this.typeName);
    }

    public FeatureReader getFeatureReader(String typeName) throws IOException {
        this.resetFeatureReader(typeName);
        return this.featureReader;
    }

    public FeatureReader getFeatureReader() throws IOException {
        if (this.featureReader == null) {
            this.resetFeatureReader(this.typeName);
        }
        return this.featureReader;
    }

    public FeatureReader<SimpleFeatureType, SimpleFeature> getFeatureReader(Query query, Transaction transaction) throws IOException {
        return this.getFeatureReader();
    }

    public void resetFeatureReader(String typeName) throws IOException {
        if (typeName == null) {
            LOG.error((Object)"No typeName given for featureReader");
        } else {
            this.typeName = typeName;
            String extension = typeName.replaceFirst(this.strippedFileName, "");
            GeometryType geometryType = GeometryType.getTypeByExtension(extension);
            if (this.featureReader == null) {
                try {
                    this.featureReader = new DXFFeatureReader(this.url, typeName, this.srs, geometryType, this.dxfInsertsFilter);
                }
                catch (DXFParseException e) {
                    throw new IOException("DXF parse exception" + e.getLocalizedMessage());
                }
            } else {
                ((DXFFeatureReader)this.featureReader).updateTypeFilter(typeName, geometryType, this.srs);
            }
        }
    }

    public List<Name> getNames() throws IOException {
        return Arrays.asList(new NameImpl(this.getSchema().getTypeName()));
    }

    public SimpleFeatureSource getFeatureSource() throws IOException {
        return this.getFeatureSource(this.typeName);
    }

    public SimpleFeatureSource getFeatureSource(String typeName) throws IOException {
        SimpleFeatureCollection collection = ((DXFFeatureReader)this.getFeatureReader(typeName)).getFeatureCollection();
        return new CollectionFeatureSource(collection);
    }

    public SimpleFeatureSource getFeatureSource(Name name) throws IOException {
        return this.getFeatureSource(name.getLocalPart());
    }

    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriter(Filter filter, Transaction transaction) throws IOException {
        throw new UnsupportedOperationException("Functie niet ondersteund voor alleen-lezen databron.");
    }

    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriter(Transaction transaction) throws IOException {
        throw new UnsupportedOperationException("Functie niet ondersteund voor alleen-lezen databron.");
    }

    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriterAppend(Transaction transaction) throws IOException {
        throw new UnsupportedOperationException("Functie niet ondersteund voor alleen-lezen databron.");
    }

    public void updateSchema(SimpleFeatureType featureType) throws IOException {
        throw new UnsupportedOperationException("Functie niet ondersteund voor alleen-lezen databron.");
    }

    public void updateSchema(String typeName, SimpleFeatureType featureType) throws IOException {
        throw new UnsupportedOperationException("Functie niet ondersteund voor alleen-lezen databron.");
    }

    public void updateSchema(Name typeName, SimpleFeatureType featureType) throws IOException {
        throw new UnsupportedOperationException("Functie niet ondersteund voor alleen-lezen databron.");
    }

    public void removeSchema(String typeName) throws IOException {
        throw new UnsupportedOperationException("Functie niet ondersteund voor alleen-lezen databron.");
    }

    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriter(String typeName, Filter filter, Transaction transaction) throws IOException {
        throw new UnsupportedOperationException("Functie niet ondersteund voor alleen-lezen databron.");
    }

    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriter(String typeName, Transaction transaction) throws IOException {
        throw new UnsupportedOperationException("Functie niet ondersteund voor alleen-lezen databron.");
    }

    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriterAppend(String typeName, Transaction transaction) throws IOException {
        throw new UnsupportedOperationException("Functie niet ondersteund voor alleen-lezen databron.");
    }

    public LockingManager getLockingManager() {
        throw new UnsupportedOperationException("Functie niet ondersteund voor alleen-lezen databron.");
    }

    public void createSchema(SimpleFeatureType featureType) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void removeSchema(Name typeName) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ServiceInfo getInfo() {
        try {
            return ((DXFFeatureReader)this.getFeatureReader()).getInfo();
        }
        catch (IOException ex) {
            LOG.warn((Object)"Ophalen service info voor DXF is mislukt.", (Throwable)ex);
            return null;
        }
    }

    public void dispose() {
        try {
            this.featureReader.close();
        }
        catch (IOException | NullPointerException ex) {
            LOG.debug((Object)"Mogelijk probleem met sluiten van featureReader", (Throwable)ex);
        }
        this.featureReader = null;
    }
}

