/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.geotools.data.dxf.entities;

import java.io.EOFException;
import java.io.IOException;
import nl.b3p.geotools.data.GeometryType;
import nl.b3p.geotools.data.dxf.entities.DXFEntity;
import nl.b3p.geotools.data.dxf.entities.DXFPoint;
import nl.b3p.geotools.data.dxf.header.DXFBlock;
import nl.b3p.geotools.data.dxf.header.DXFBlockReference;
import nl.b3p.geotools.data.dxf.header.DXFLayer;
import nl.b3p.geotools.data.dxf.header.DXFLineType;
import nl.b3p.geotools.data.dxf.parser.DXFCodeValuePair;
import nl.b3p.geotools.data.dxf.parser.DXFGroupCode;
import nl.b3p.geotools.data.dxf.parser.DXFLineNumberReader;
import nl.b3p.geotools.data.dxf.parser.DXFParseException;
import nl.b3p.geotools.data.dxf.parser.DXFUnivers;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DXFDimension
extends DXFBlockReference {
    private static final Log log = LogFactory.getLog(DXFDimension.class);
    public double _angle = 0.0;
    public String _dimension = "<>";
    public DXFPoint _point_WCS = new DXFPoint();

    public DXFDimension(DXFDimension newDimension) {
        this(newDimension._angle, newDimension._dimension, newDimension._point_WCS._point.x, newDimension._point_WCS._point.y, newDimension._refBlock, newDimension._blockName, newDimension.getRefLayer(), 0, newDimension.getColor(), newDimension.getLineType());
        this.setType(newDimension.getType());
        this.setStartingLineNumber(newDimension.getStartingLineNumber());
        this.setUnivers(newDimension.getUnivers());
    }

    public DXFDimension(double a, String dim, double x, double y, DXFBlock refBlock, String nomBlock, DXFLayer l, int visibility, int c, DXFLineType lineType) {
        super(c, l, visibility, null, nomBlock, refBlock);
        this._angle = a;
        this._dimension = dim;
        this._point_WCS = new DXFPoint(x, y, c, null, visibility, 1.0);
        this.setName("DXFDimension");
    }

    public static DXFDimension read(DXFLineNumberReader br, DXFUnivers univers) throws IOException {
        String dimension = "";
        String nomBlock = "";
        DXFDimension d = null;
        DXFLayer l = null;
        DXFBlock refBlock = null;
        double angle = 0.0;
        double x = 0.0;
        double y = 0.0;
        int visibility = 0;
        int c = -1;
        DXFLineType lineType = null;
        int sln = br.getLineNumber();
        log.debug((Object)(">>Enter at line: " + sln));
        DXFCodeValuePair cvp = null;
        DXFGroupCode gc = null;
        boolean doLoop = true;
        block15: while (doLoop) {
            cvp = new DXFCodeValuePair();
            try {
                gc = cvp.read(br);
            }
            catch (DXFParseException ex) {
                throw new IOException("DXF parse error" + ex.getLocalizedMessage());
            }
            catch (EOFException e) {
                doLoop = false;
                break;
            }
            switch (gc) {
                case TYPE: {
                    String type = cvp.getStringValue();
                    br.reset();
                    doLoop = false;
                    continue block15;
                }
                case LAYER_NAME: {
                    l = univers.findLayer(cvp.getStringValue());
                    continue block15;
                }
                case TEXT: {
                    dimension = cvp.getStringValue();
                    continue block15;
                }
                case ANGLE_1: {
                    angle = cvp.getDoubleValue();
                    continue block15;
                }
                case NAME: {
                    nomBlock = cvp.getStringValue();
                    continue block15;
                }
                case LINETYPE_NAME: {
                    lineType = univers.findLType(cvp.getStringValue());
                    continue block15;
                }
                case X_1: {
                    x = cvp.getDoubleValue();
                    continue block15;
                }
                case Y_1: {
                    y = cvp.getDoubleValue();
                    continue block15;
                }
                case VISIBILITY: {
                    visibility = cvp.getShortValue();
                    continue block15;
                }
                case COLOR: {
                    c = cvp.getShortValue();
                    continue block15;
                }
            }
        }
        d = new DXFDimension(angle, dimension, x, y, refBlock, nomBlock, l, visibility, c, lineType);
        d.setType(GeometryType.UNSUPPORTED);
        d.setStartingLineNumber(sln);
        d.setUnivers(univers);
        univers.addRefBlockForUpdate(d);
        log.debug((Object)d.toString(dimension, angle, nomBlock, x, y, visibility, c));
        log.debug((Object)(">>Exit at line: " + br.getLineNumber()));
        return d;
    }

    @Override
    public void updateGeometry() {
    }

    public String toString(String dimension, double angle, String nomBlock, double x, double y, int visibility, int c) {
        StringBuffer s = new StringBuffer();
        s.append("DXFDimension [");
        s.append("dimension: ");
        s.append(dimension + ", ");
        s.append("angle: ");
        s.append(angle + ", ");
        s.append("nameBlock: ");
        s.append(nomBlock + ", ");
        s.append("x: ");
        s.append(x + ", ");
        s.append("y: ");
        s.append(y + ", ");
        s.append("visibility: ");
        s.append(visibility + ", ");
        s.append("color: ");
        s.append(c);
        s.append("]");
        return s.toString();
    }

    @Override
    public DXFEntity translate(double x, double y) {
        this._point_WCS._point.x += x;
        this._point_WCS._point.y += y;
        return this;
    }

    @Override
    public DXFEntity clone() {
        return new DXFDimension(this);
    }
}

