/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.geotools.data.dxf.entities;

import java.io.EOFException;
import java.io.IOException;
import nl.b3p.geotools.data.GeometryType;
import nl.b3p.geotools.data.dxf.entities.DXFEntity;
import nl.b3p.geotools.data.dxf.entities.DXFPoint;
import nl.b3p.geotools.data.dxf.header.DXFLayer;
import nl.b3p.geotools.data.dxf.header.DXFLineType;
import nl.b3p.geotools.data.dxf.parser.DXFCodeValuePair;
import nl.b3p.geotools.data.dxf.parser.DXFGroupCode;
import nl.b3p.geotools.data.dxf.parser.DXFLineNumberReader;
import nl.b3p.geotools.data.dxf.parser.DXFParseException;
import nl.b3p.geotools.data.dxf.parser.DXFUnivers;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LinearRing;

public class DXFEllipse
extends DXFEntity {
    private static final Log log = LogFactory.getLog(DXFEllipse.class);
    public DXFPoint _centre = new DXFPoint();
    public DXFPoint _point = new DXFPoint();
    public double _ratio = 0.0;
    public double _start = 0.0;
    public double _end = 0.0;

    public DXFEllipse(DXFEllipse newEllipse) {
        this(new DXFPoint(newEllipse._centre._point.x, newEllipse._centre._point.y, newEllipse.getColor(), null, 0, newEllipse.getThickness()), new DXFPoint(newEllipse._point._point.x, newEllipse._point._point.y, newEllipse.getColor(), null, 0, newEllipse.getThickness()), newEllipse._ratio, newEllipse._start, newEllipse._end, newEllipse.getColor(), newEllipse.getRefLayer(), 0, newEllipse.getLineType());
        this.setType(newEllipse.getType());
        this.setStartingLineNumber(newEllipse.getStartingLineNumber());
        this.setUnivers(newEllipse.getUnivers());
    }

    public DXFEllipse(DXFPoint centre, DXFPoint p, double r, double s, double e, int c, DXFLayer l, int visibility, DXFLineType typeLine) {
        super(c, l, visibility, typeLine, 1.0);
        this._centre = centre;
        this._point = p;
        this._ratio = r;
        this._end = e;
        this._start = s;
        this.setName("DXFEllipse");
    }

    public static DXFEllipse read(DXFLineNumberReader br, DXFUnivers univers) throws NumberFormatException, IOException {
        int visibility = 0;
        int c = 0;
        double x = 0.0;
        double y = 0.0;
        double x1 = 0.0;
        double y1 = 0.0;
        double r = 0.0;
        double s = 0.0;
        double e = 0.0;
        DXFLayer l = null;
        DXFLineType lineType = null;
        int sln = br.getLineNumber();
        log.debug((Object)(">>Enter at line: " + sln));
        DXFCodeValuePair cvp = null;
        DXFGroupCode gc = null;
        boolean doLoop = true;
        block17: while (doLoop) {
            cvp = new DXFCodeValuePair();
            try {
                gc = cvp.read(br);
            }
            catch (DXFParseException ex) {
                throw new IOException("DXF parse error" + ex.getLocalizedMessage());
            }
            catch (EOFException eofe) {
                doLoop = false;
                break;
            }
            switch (gc) {
                case TYPE: {
                    String type = cvp.getStringValue();
                    br.reset();
                    doLoop = false;
                    continue block17;
                }
                case LAYER_NAME: {
                    l = univers.findLayer(cvp.getStringValue());
                    continue block17;
                }
                case LINETYPE_NAME: {
                    lineType = univers.findLType(cvp.getStringValue());
                    continue block17;
                }
                case VISIBILITY: {
                    visibility = cvp.getShortValue();
                    continue block17;
                }
                case COLOR: {
                    c = cvp.getShortValue();
                    continue block17;
                }
                case DOUBLE_1: {
                    r = cvp.getDoubleValue();
                    continue block17;
                }
                case DOUBLE_2: {
                    s = cvp.getDoubleValue();
                    continue block17;
                }
                case DOUBLE_3: {
                    e = cvp.getDoubleValue();
                    continue block17;
                }
                case X_1: {
                    x = cvp.getDoubleValue();
                    continue block17;
                }
                case Y_1: {
                    y = cvp.getDoubleValue();
                    continue block17;
                }
                case X_2: {
                    x1 = cvp.getDoubleValue();
                    continue block17;
                }
                case Y_2: {
                    y1 = cvp.getDoubleValue();
                    continue block17;
                }
            }
        }
        DXFEllipse m = new DXFEllipse(new DXFPoint(x, y, c, l, visibility, 1.0), new DXFPoint(x1, y1, c, l, visibility, 1.0), r, s, e, c, l, visibility, lineType);
        m.setType(GeometryType.POLYGON);
        m.setStartingLineNumber(sln);
        m.setUnivers(univers);
        log.debug((Object)m.toString(visibility, c, r, s, e, x, y, x1, y1));
        log.debug((Object)(">>Exit at line: " + br.getLineNumber()));
        return m;
    }

    public Coordinate[] toCoordinateArray() {
        this.addError("coordinate array can not be created.");
        return null;
    }

    @Override
    public Geometry getGeometry() {
        if (this.geometry == null) {
            this.updateGeometry();
        }
        return super.getGeometry();
    }

    @Override
    public void updateGeometry() {
        Coordinate[] ca = this.toCoordinateArray();
        if (ca != null && ca.length > 1) {
            LinearRing lr = this.getUnivers().getGeometryFactory().createLinearRing(ca);
            this.geometry = this.getUnivers().getGeometryFactory().createPolygon(lr, null);
        } else {
            this.addError("coordinate array faulty, size: " + (ca == null ? 0 : ca.length));
        }
    }

    public String toString(int visibility, int c, double r, double t, double e, double x, double y, double x1, double y1) {
        StringBuffer s = new StringBuffer();
        s.append("DXFEllipse [");
        s.append("visibility: ");
        s.append(visibility + ", ");
        s.append("color: ");
        s.append(c + ", ");
        s.append("r: ");
        s.append(r + ", ");
        s.append("s: ");
        s.append(t + ", ");
        s.append("e: ");
        s.append(e + ", ");
        s.append("x: ");
        s.append(x + ", ");
        s.append("y: ");
        s.append(y + ", ");
        s.append("x1: ");
        s.append(x1 + ", ");
        s.append("y1: ");
        s.append(y1);
        s.append("]");
        return s.toString();
    }

    @Override
    public DXFEntity translate(double x, double y) {
        this._point._point.x += x;
        this._point._point.y += y;
        this._centre._point.x += x;
        this._centre._point.y += y;
        return this;
    }

    @Override
    public DXFEntity clone() {
        return new DXFEllipse(this);
    }
}

