/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.geotools.data.dxf.entities;

import java.io.EOFException;
import java.io.IOException;
import nl.b3p.geotools.data.GeometryType;
import nl.b3p.geotools.data.dxf.entities.DXFPoint;
import nl.b3p.geotools.data.dxf.header.DXFLayer;
import nl.b3p.geotools.data.dxf.parser.DXFCodeValuePair;
import nl.b3p.geotools.data.dxf.parser.DXFGroupCode;
import nl.b3p.geotools.data.dxf.parser.DXFLineNumberReader;
import nl.b3p.geotools.data.dxf.parser.DXFParseException;
import nl.b3p.geotools.data.dxf.parser.DXFUnivers;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DXFVertex
extends DXFPoint {
    private static final Log log = LogFactory.getLog(DXFVertex.class);
    protected double _bulge = 0.0;

    public DXFVertex(DXFVertex newVertex) {
        this(newVertex._point.x, newVertex._point.y, newVertex._bulge, newVertex.getColor(), newVertex.getRefLayer(), 0);
        this.setType(newVertex.getType());
        this.setStartingLineNumber(newVertex.getStartingLineNumber());
        this.setUnivers(newVertex.getUnivers());
    }

    public DXFVertex(double x, double y, double b, int c, DXFLayer l, int visibility) {
        super(x, y, c, l, visibility, 1.0);
        this.setName("DXFVertex");
        this._bulge = b;
    }

    public static DXFVertex read(DXFLineNumberReader br, DXFUnivers univers) throws IOException {
        DXFLayer l = null;
        int visibility = 0;
        int c = -1;
        double x = 0.0;
        double y = 0.0;
        double b = 0.0;
        int sln = br.getLineNumber();
        log.debug((Object)(">>Enter at line: " + sln));
        DXFCodeValuePair cvp = null;
        DXFGroupCode gc = null;
        boolean doLoop = true;
        block12: while (doLoop) {
            cvp = new DXFCodeValuePair();
            try {
                gc = cvp.read(br);
            }
            catch (DXFParseException ex) {
                throw new IOException("DXF parse error" + ex.getLocalizedMessage());
            }
            catch (EOFException e) {
                doLoop = false;
                break;
            }
            switch (gc) {
                case TYPE: {
                    String type = cvp.getStringValue();
                    br.reset();
                    doLoop = false;
                    continue block12;
                }
                case LAYER_NAME: {
                    l = univers.findLayer(cvp.getStringValue());
                    continue block12;
                }
                case DOUBLE_3: {
                    b = cvp.getDoubleValue();
                    continue block12;
                }
                case X_1: {
                    x = cvp.getDoubleValue();
                    continue block12;
                }
                case Y_1: {
                    y = cvp.getDoubleValue();
                    continue block12;
                }
                case COLOR: {
                    c = cvp.getShortValue();
                    continue block12;
                }
                case VISIBILITY: {
                    visibility = cvp.getShortValue();
                    continue block12;
                }
            }
        }
        DXFVertex e = new DXFVertex(x, y, b, c, l, visibility);
        e.setType(GeometryType.POINT);
        e.setStartingLineNumber(sln);
        e.setUnivers(univers);
        log.debug((Object)e.toString(b, x, y, c, visibility));
        log.debug((Object)(">Exit at line: " + br.getLineNumber()));
        return e;
    }

    public String toString(double b, double x, double y, int c, int visibility) {
        StringBuffer s = new StringBuffer();
        s.append("DXFVertex [");
        s.append("bulge: ");
        s.append(b + ", ");
        s.append("x: ");
        s.append(x + ", ");
        s.append("y: ");
        s.append(y + ", ");
        s.append("c: ");
        s.append(c + ", ");
        s.append("visibility: ");
        s.append(visibility);
        s.append("]");
        return s.toString();
    }
}

