/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.geotools.data.dxf.entities;

import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import nl.b3p.geotools.data.GeometryType;
import nl.b3p.geotools.data.dxf.entities.DXFEntity;
import nl.b3p.geotools.data.dxf.entities.DXFLwVertex;
import nl.b3p.geotools.data.dxf.header.DXFLayer;
import nl.b3p.geotools.data.dxf.header.DXFLineType;
import nl.b3p.geotools.data.dxf.parser.DXFCodeValuePair;
import nl.b3p.geotools.data.dxf.parser.DXFGroupCode;
import nl.b3p.geotools.data.dxf.parser.DXFLineNumberReader;
import nl.b3p.geotools.data.dxf.parser.DXFParseException;
import nl.b3p.geotools.data.dxf.parser.DXFUnivers;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LinearRing;

public class DXFLwPolyline
extends DXFEntity {
    private static final Log log = LogFactory.getLog(DXFLwPolyline.class);
    public String _id = "DXFLwPolyline";
    public int _flag = 0;
    public Vector<DXFLwVertex> theVertices = new Vector();

    public DXFLwPolyline(String name, int flag, int c, DXFLayer l, Vector<DXFLwVertex> v, int visibility, DXFLineType lineType, double thickness) {
        super(c, l, visibility, lineType, thickness);
        this._id = name;
        Vector<DXFLwVertex> newV = new Vector<DXFLwVertex>();
        for (int i = 0; i < v.size(); ++i) {
            DXFLwVertex entity = (DXFLwVertex)v.get(i).clone();
            newV.add(entity);
        }
        this.theVertices = newV;
        this._flag = flag;
        this.setName("DXFLwPolyline");
    }

    public DXFLwPolyline(DXFLayer l) {
        super(-1, l, 0, null, 1.0);
        this.setName("DXFLwPolyline");
    }

    public DXFLwPolyline() {
        super(-1, null, 0, null, 1.0);
        this.setName("DXFLwPolyline");
    }

    public DXFLwPolyline(DXFLwPolyline orig) {
        super(orig.getColor(), orig.getRefLayer(), 0, orig.getLineType(), orig.getThickness());
        this._id = orig._id;
        for (int i = 0; i < orig.theVertices.size(); ++i) {
            this.theVertices.add((DXFLwVertex)orig.theVertices.elementAt(i).clone());
        }
        this._flag = orig._flag;
        this.setType(orig.getType());
        this.setStartingLineNumber(orig.getStartingLineNumber());
        this.setUnivers(orig.getUnivers());
        this.setName("DXFLwPolyline");
    }

    public static DXFLwPolyline read(DXFLineNumberReader br, DXFUnivers univers) throws IOException {
        String name = "";
        int visibility = 0;
        int flag = 0;
        int c = -1;
        DXFLineType lineType = null;
        Vector<DXFLwVertex> lv = new Vector<DXFLwVertex>();
        DXFLayer l = null;
        int sln = br.getLineNumber();
        log.debug((Object)(">>Enter at line: " + sln));
        DXFCodeValuePair cvp = null;
        DXFGroupCode gc = null;
        boolean doLoop = true;
        block13: while (doLoop) {
            cvp = new DXFCodeValuePair();
            try {
                gc = cvp.read(br);
            }
            catch (DXFParseException ex) {
                throw new IOException("DXF parse error" + ex.getLocalizedMessage());
            }
            catch (EOFException e) {
                doLoop = false;
                break;
            }
            switch (gc) {
                case TYPE: {
                    String type = cvp.getStringValue();
                    br.reset();
                    doLoop = false;
                    continue block13;
                }
                case X_1: {
                    br.reset();
                    DXFLwPolyline.readLwVertices(br, lv);
                    continue block13;
                }
                case NAME: {
                    name = cvp.getStringValue();
                    continue block13;
                }
                case LAYER_NAME: {
                    l = univers.findLayer(cvp.getStringValue());
                    continue block13;
                }
                case LINETYPE_NAME: {
                    lineType = univers.findLType(cvp.getStringValue());
                    continue block13;
                }
                case COLOR: {
                    c = cvp.getShortValue();
                    continue block13;
                }
                case INT_1: {
                    flag = cvp.getShortValue();
                    continue block13;
                }
                case VISIBILITY: {
                    visibility = cvp.getShortValue();
                    continue block13;
                }
            }
        }
        DXFLwPolyline e = new DXFLwPolyline(name, flag, c, l, lv, visibility, lineType, 1.0);
        if ((flag & 1) == 1) {
            e.setType(GeometryType.POLYGON);
        } else {
            e.setType(GeometryType.LINE);
        }
        e.setStartingLineNumber(sln);
        e.setUnivers(univers);
        log.debug((Object)e.toString(name, flag, lv.size(), c, visibility, 1.0));
        log.debug((Object)(">>Exit at line: " + br.getLineNumber()));
        return e;
    }

    public static void readLwVertices(DXFLineNumberReader br, Vector<DXFLwVertex> theVertices) throws IOException {
        double x = 0.0;
        double y = 0.0;
        double b = 0.0;
        boolean xFound = false;
        boolean yFound = false;
        int sln = br.getLineNumber();
        log.debug((Object)(">>Enter at line: " + sln));
        DXFCodeValuePair cvp = null;
        DXFGroupCode gc = null;
        boolean doLoop = true;
        block8: while (doLoop) {
            cvp = new DXFCodeValuePair();
            try {
                gc = cvp.read(br);
            }
            catch (DXFParseException ex) {
                throw new IOException("DXF parse error" + ex.getLocalizedMessage());
            }
            catch (EOFException e) {
                doLoop = false;
                break;
            }
            switch (gc) {
                case TYPE: 
                case X_1: {
                    if (xFound && yFound) {
                        DXFLwVertex e = new DXFLwVertex(x, y, b);
                        log.debug((Object)e.toString(b, x, y));
                        theVertices.add(e);
                        xFound = false;
                        yFound = false;
                        x = 0.0;
                        y = 0.0;
                        b = 0.0;
                    }
                    if (gc == DXFGroupCode.TYPE) {
                        br.reset();
                        doLoop = false;
                        continue block8;
                    }
                    x = cvp.getDoubleValue();
                    xFound = true;
                    continue block8;
                }
                case Y_1: {
                    y = cvp.getDoubleValue();
                    yFound = true;
                    continue block8;
                }
                case DOUBLE_3: {
                    b = cvp.getDoubleValue();
                    continue block8;
                }
            }
        }
        log.debug((Object)(">Exit at line: " + br.getLineNumber()));
    }

    @Override
    public Geometry getGeometry() {
        if (this.geometry == null) {
            this.updateGeometry();
        }
        return super.getGeometry();
    }

    @Override
    public void updateGeometry() {
        Coordinate[] ca = this.toCoordinateArray();
        if (ca != null && ca.length > 1) {
            if (this.getType() == GeometryType.POLYGON) {
                LinearRing lr = this.getUnivers().getGeometryFactory().createLinearRing(ca);
                this.geometry = this.getUnivers().getGeometryFactory().createPolygon(lr, null);
            } else {
                this.geometry = this.getUnivers().getGeometryFactory().createLineString(ca);
            }
        } else {
            this.addError("coordinate array faulty, size: " + (ca == null ? 0 : ca.length));
        }
    }

    public Coordinate[] toCoordinateArray() {
        if (this.theVertices == null) {
            this.addError("coordinate array can not be created.");
            return null;
        }
        Iterator<DXFLwVertex> it = this.theVertices.iterator();
        ArrayList<Coordinate> lc = new ArrayList<Coordinate>();
        Coordinate firstc = null;
        Coordinate lastc = null;
        while (it.hasNext()) {
            DXFLwVertex v = it.next();
            lastc = v.toCoordinate();
            if (firstc == null) {
                firstc = lastc;
            }
            lc.add(lastc);
        }
        if (lc.size() == 2) {
            this.setType(GeometryType.LINE);
        }
        if (this.getType() == GeometryType.POLYGON && !firstc.equals2D(lastc)) {
            lc.add(firstc);
        }
        return this.rotateAndPlace(lc.toArray(new Coordinate[0]));
    }

    public String toString(String name, int flag, int numVert, int c, int visibility, double thickness) {
        StringBuffer s = new StringBuffer();
        s.append("DXFPolyline [");
        s.append("name: ");
        s.append(name + ", ");
        s.append("flag: ");
        s.append(flag + ", ");
        s.append("numVert: ");
        s.append(numVert + ", ");
        s.append("color: ");
        s.append(c + ", ");
        s.append("visibility: ");
        s.append(visibility + ", ");
        s.append("thickness: ");
        s.append(thickness);
        s.append("]");
        return s.toString();
    }

    public String toString() {
        return this.toString(this.getName(), this._flag, this.theVertices.size(), this.getColor(), this.isVisible() ? 0 : 1, this.getThickness());
    }

    @Override
    public DXFEntity translate(double x, double y) {
        for (DXFLwVertex vertex : this.theVertices) {
            vertex._point.x += x;
            vertex._point.y += y;
        }
        return this;
    }

    @Override
    public DXFEntity clone() {
        return new DXFLwPolyline(this);
    }
}

