/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.geotools.data.dxf.entities;

import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import nl.b3p.geotools.data.GeometryType;
import nl.b3p.geotools.data.dxf.entities.DXFEntity;
import nl.b3p.geotools.data.dxf.entities.DXFPoint;
import nl.b3p.geotools.data.dxf.header.DXFLayer;
import nl.b3p.geotools.data.dxf.header.DXFLineType;
import nl.b3p.geotools.data.dxf.parser.DXFCodeValuePair;
import nl.b3p.geotools.data.dxf.parser.DXFGroupCode;
import nl.b3p.geotools.data.dxf.parser.DXFLineNumberReader;
import nl.b3p.geotools.data.dxf.parser.DXFParseException;
import nl.b3p.geotools.data.dxf.parser.DXFUnivers;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LinearRing;

public class DXFSolid
extends DXFEntity {
    private static final Log log = LogFactory.getLog(DXFSolid.class);
    public DXFPoint _p1 = new DXFPoint();
    public DXFPoint _p2 = new DXFPoint();
    public DXFPoint _p3 = new DXFPoint();
    public DXFPoint _p4 = null;

    public DXFSolid(DXFSolid newSolid) {
        this(new DXFPoint(newSolid._p1._point.x, newSolid._p1._point.y, newSolid.getColor(), null, 0, newSolid.getThickness()), new DXFPoint(newSolid._p2._point.x, newSolid._p2._point.y, newSolid.getColor(), null, 0, newSolid.getThickness()), new DXFPoint(newSolid._p3._point.x, newSolid._p3._point.y, newSolid.getColor(), null, 0, newSolid.getThickness()), new DXFPoint(newSolid._p4._point.x, newSolid._p4._point.y, newSolid.getColor(), null, 0, newSolid.getThickness()), newSolid.getThickness(), newSolid.getColor(), newSolid.getRefLayer(), 0, newSolid.getLineType());
        this.setType(newSolid.getType());
        this.setStartingLineNumber(newSolid.getStartingLineNumber());
        this.setUnivers(newSolid.getUnivers());
    }

    public DXFSolid(DXFPoint p1, DXFPoint p2, DXFPoint p3, DXFPoint p4, double thickness, int c, DXFLayer l, int visibility, DXFLineType lineType) {
        super(c, l, visibility, lineType, thickness);
        this._p1 = p1;
        this._p2 = p2;
        this._p3 = p3;
        this._p4 = p4 == null ? p3 : p4;
        this.setName("DXFSolid");
    }

    public static DXFEntity read(DXFLineNumberReader br, DXFUnivers univers) throws IOException {
        double p1_x = 0.0;
        double p2_x = 0.0;
        double p3_x = 0.0;
        double p4_x = 0.0;
        double p1_y = 0.0;
        double p2_y = 0.0;
        double p3_y = 0.0;
        double p4_y = 0.0;
        double thickness = 0.0;
        int visibility = 0;
        int c = -1;
        DXFLayer l = null;
        DXFLineType lineType = null;
        int sln = br.getLineNumber();
        log.debug((Object)(">>Enter at line: " + sln));
        DXFCodeValuePair cvp = null;
        DXFGroupCode gc = null;
        boolean doLoop = true;
        while (doLoop) {
            cvp = new DXFCodeValuePair();
            try {
                gc = cvp.read(br);
            }
            catch (DXFParseException ex) {
                throw new IOException("DXF parse error" + ex.getLocalizedMessage());
            }
            catch (EOFException e) {
                doLoop = false;
                break;
            }
            Double val = null;
            switch (gc) {
                case TYPE: {
                    String type = cvp.getStringValue();
                    br.reset();
                    doLoop = false;
                    break;
                }
                case X_1: {
                    val = cvp.getDoubleValue();
                    if (val != null && val < 0.0) {
                        val = Math.abs(val);
                    }
                    p1_x = val;
                    break;
                }
                case X_2: {
                    val = cvp.getDoubleValue();
                    if (val != null && val < 0.0) {
                        val = Math.abs(val);
                    }
                    p2_x = val;
                    break;
                }
                case X_3: {
                    val = cvp.getDoubleValue();
                    if (val != null && val < 0.0) {
                        val = Math.abs(val);
                    }
                    p3_x = val;
                    break;
                }
                case X_4: {
                    val = cvp.getDoubleValue();
                    if (val != null && val < 0.0) {
                        val = Math.abs(val);
                    }
                    p4_x = val;
                    break;
                }
                case Y_1: {
                    p1_y = cvp.getDoubleValue();
                    break;
                }
                case Y_2: {
                    p2_y = cvp.getDoubleValue();
                    break;
                }
                case Y_3: {
                    p3_y = cvp.getDoubleValue();
                    break;
                }
                case Y_4: {
                    p4_y = cvp.getDoubleValue();
                    break;
                }
                case THICKNESS: {
                    thickness = cvp.getDoubleValue();
                    break;
                }
                case LAYER_NAME: {
                    l = univers.findLayer(cvp.getStringValue());
                    break;
                }
                case COLOR: {
                    c = cvp.getShortValue();
                    break;
                }
                case LINETYPE_NAME: {
                    lineType = univers.findLType(cvp.getStringValue());
                    break;
                }
                case VISIBILITY: {
                    visibility = cvp.getShortValue();
                    break;
                }
            }
        }
        DXFSolid e = new DXFSolid(new DXFPoint(p1_x, p1_y, c, null, visibility, 1.0), new DXFPoint(p2_x, p2_y, c, null, visibility, 1.0), new DXFPoint(p3_x, p3_y, c, null, visibility, 1.0), new DXFPoint(p4_x, p4_y, c, null, visibility, 1.0), thickness, c, l, visibility, lineType);
        e.setType(GeometryType.POLYGON);
        e.setStartingLineNumber(sln);
        e.setUnivers(univers);
        log.debug((Object)e.toString(p1_x, p2_x, p3_x, p4_x, p1_y, p2_y, p3_y, p4_y, thickness, c, visibility));
        log.debug((Object)(">>Exit at line: " + br.getLineNumber()));
        return e;
    }

    public Coordinate[] toCoordinateArray() {
        DXFPoint[] points;
        ArrayList<Coordinate> lc = new ArrayList<Coordinate>();
        for (DXFPoint point : points = new DXFPoint[]{this._p1, this._p2, this._p3, this._p4}) {
            Coordinate c = new Coordinate(point.X(), point.Y());
            lc.add(c);
        }
        lc.add((Coordinate)lc.get(0));
        return this.rotateAndPlace(lc.toArray(new Coordinate[0]));
    }

    @Override
    public Geometry getGeometry() {
        if (this.geometry == null) {
            this.updateGeometry();
        }
        return super.getGeometry();
    }

    @Override
    public void updateGeometry() {
        Coordinate[] ca = this.toCoordinateArray();
        if (ca != null && ca.length > 1) {
            LinearRing lr = this.getUnivers().getGeometryFactory().createLinearRing(ca);
            this.geometry = this.getUnivers().getGeometryFactory().createPolygon(lr, null);
        } else {
            this.addError("coordinate array faulty, size: " + (ca == null ? 0 : ca.length));
        }
    }

    public String toString(double p1_x, double p2_x, double p3_x, double p4_x, double p1_y, double p2_y, double p3_y, double p4_y, double thickness, int c, int visibility) {
        StringBuffer s = new StringBuffer();
        s.append("DXFSolid [");
        s.append("p1_x: ");
        s.append(p1_x + ", ");
        s.append("p2_x: ");
        s.append(p2_x + ", ");
        s.append("p3_x: ");
        s.append(p3_x + ", ");
        s.append("p4_x: ");
        s.append(p4_x + ", ");
        s.append("p1_y: ");
        s.append(p1_y + ", ");
        s.append("p2_y: ");
        s.append(p2_y + ", ");
        s.append("p3_y: ");
        s.append(p3_y + ", ");
        s.append("p4_y: ");
        s.append(p4_y + ", ");
        s.append("thickness: ");
        s.append(thickness + ", ");
        s.append("color: ");
        s.append(c + ", ");
        s.append("visibility: ");
        s.append(visibility);
        s.append("]");
        return s.toString();
    }

    @Override
    public DXFEntity translate(double x, double y) {
        this._p1._point.x += x;
        this._p1._point.y += y;
        this._p2._point.x += x;
        this._p2._point.y += y;
        this._p3._point.x += x;
        this._p3._point.y += y;
        this._p4._point.x += x;
        this._p4._point.y += y;
        return this;
    }

    @Override
    public DXFEntity clone() {
        return new DXFSolid(this);
    }
}

