/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.geotools.data.msaccess;

import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import nl.b3p.geotools.data.msaccess.MsAccessDataStoreFactory;
import nl.b3p.geotools.data.msaccess.MsAccessFeatureReader;
import nl.b3p.geotools.data.msaccess.SpatialUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.data.AbstractFileDataStore;
import org.geotools.data.FeatureReader;
import org.opengis.feature.simple.SimpleFeatureType;

public class MsAccessDataStore
extends AbstractFileDataStore {
    private static final Log log = LogFactory.getLog(MsAccessDataStore.class);
    private URL url;
    private Connection dbConn;
    private String controlerTable = null;
    private String controlerColumnName = null;
    private String controlerColumnType = null;
    private String controlerFilter = null;
    private boolean controlerFilterReverse = false;
    private String epsg = null;
    private String[] xLabels = null;
    private String[] yLabels = null;
    private Map featureReaderMap = new HashMap();
    private Map featureTypeMap = new HashMap();

    public MsAccessDataStore(URL url) throws IOException {
        this.url = url;
        this.dbConn = this.getConnection();
    }

    protected Connection getConnection() throws IOException {
        return MsAccessDataStore.getConnection(this.url);
    }

    protected static Connection getConnection(URL url) throws IOException {
        String msaccessFile = url.getFile().toLowerCase().substring(1);
        try {
            Class.forName("sun.jdbc.odbc.JdbcOdbcDriver").newInstance();
        }
        catch (InstantiationException ex) {
            log.error((Object)"JdbcOdbcDriver not found!", (Throwable)ex);
            throw new IOException(ex.getLocalizedMessage());
        }
        catch (IllegalAccessException ex) {
            log.error((Object)"JdbcOdbcDriver not found!", (Throwable)ex);
            throw new IOException(ex.getLocalizedMessage());
        }
        catch (ClassNotFoundException ex) {
            log.error((Object)"JdbcOdbcDriver not found!", (Throwable)ex);
            throw new IOException(ex.getLocalizedMessage());
        }
        String myDB = "jdbc:odbc:Driver={Microsoft Access Driver (*.mdb)};DBQ=" + msaccessFile;
        Connection conn = null;
        try {
            conn = DriverManager.getConnection(myDB, "yuit", "tyuityu");
        }
        catch (SQLException ex) {
            log.error((Object)("Connectionstring: " + myDB));
            log.error((Object)"Connection not made!", (Throwable)ex);
            throw new IOException(ex.getLocalizedMessage());
        }
        return conn;
    }

    public MsAccessDataStore(Map dbconfig) throws IOException {
        this((URL)dbconfig.get(MsAccessDataStoreFactory.PARAM_URL.key));
        this.controlerTable = (String)dbconfig.get(MsAccessDataStoreFactory.PARAM_CONTROLER_TABLE.key);
        this.controlerColumnName = (String)dbconfig.get(MsAccessDataStoreFactory.PARAM_CONTROLER_COLUMN_NAME.key);
        this.controlerColumnType = (String)dbconfig.get(MsAccessDataStoreFactory.PARAM_CONTROLER_COLUMN_TYPE.key);
        this.controlerFilter = (String)dbconfig.get(MsAccessDataStoreFactory.PARAM_CONTROLER_FILTER.key);
        String reverse = (String)dbconfig.get(MsAccessDataStoreFactory.PARAM_CONTROLER_FILTER_REVERSE.key);
        if (reverse != null && reverse.equalsIgnoreCase("true")) {
            this.controlerFilterReverse = true;
        }
        this.epsg = (String)dbconfig.get(MsAccessDataStoreFactory.PARAM_SRS.key);
        String xlbs = (String)dbconfig.get(MsAccessDataStoreFactory.PARAM_XLABELS.key);
        String ylbs = (String)dbconfig.get(MsAccessDataStoreFactory.PARAM_YLABELS.key);
        this.xLabels = xlbs.split(",");
        this.yLabels = ylbs.split(",");
    }

    public String[] getTypeNames() throws IOException {
        try {
            if (this.controlerTable == null || this.controlerColumnName == null) {
                return SpatialUtil.getTableNameArray(this.dbConn);
            }
            return SpatialUtil.getLayerArray(this.controlerTable, this.controlerColumnName, this.controlerColumnType, this.controlerFilter, this.controlerFilterReverse, this.dbConn);
        }
        catch (SQLException ex) {
            throw new IOException(ex.getLocalizedMessage());
        }
    }

    public SimpleFeatureType getSchema(String typeName) throws IOException {
        if (this.featureTypeMap.containsKey(typeName)) {
            return (SimpleFeatureType)this.featureTypeMap.get(typeName);
        }
        try {
            if (this.dbConn.isClosed()) {
                this.dbConn = this.getConnection();
            }
            SimpleFeatureType ft = SpatialUtil.createFeatureType(typeName, this.epsg, this.dbConn);
            this.featureTypeMap.put(typeName, ft);
            return ft;
        }
        catch (Exception ex) {
            throw new IOException(ex.getLocalizedMessage());
        }
    }

    public SimpleFeatureType getSchema() throws IOException {
        return null;
    }

    public FeatureReader getFeatureReader(String typeName) throws IOException {
        if (this.featureReaderMap.containsKey(typeName)) {
            return (FeatureReader)this.featureReaderMap.get(typeName);
        }
        try {
            MsAccessFeatureReader fr = new MsAccessFeatureReader(this.getSchema(typeName), this.xLabels, this.yLabels, this.dbConn);
            this.featureReaderMap.put(typeName, fr);
            return fr;
        }
        catch (Exception ex) {
            throw new IOException(ex.getLocalizedMessage());
        }
    }

    public FeatureReader getFeatureReader() throws IOException {
        return null;
    }
}

