/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.geotools.data.msaccess;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import nl.b3p.geotools.data.msaccess.MsAccessDataStore;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.DataStore;
import org.geotools.data.FileDataStore;
import org.geotools.data.FileDataStoreFactorySpi;

public class MsAccessDataStoreFactory
implements FileDataStoreFactorySpi {
    private static final Log log = LogFactory.getLog(MsAccessDataStoreFactory.class);
    public static final DataAccessFactory.Param PARAM_URL = new DataAccessFactory.Param("url", URL.class, "url to a .dxf file");
    public static final DataAccessFactory.Param PARAM_CONTROLER_TABLE = new DataAccessFactory.Param("controlerTable", String.class, "table in mdb that holds tables names that point to layers");
    public static final DataAccessFactory.Param PARAM_CONTROLER_COLUMN_NAME = new DataAccessFactory.Param("controlerColumnName", String.class, "column name in controller tabel that holds table names");
    public static final DataAccessFactory.Param PARAM_CONTROLER_COLUMN_TYPE = new DataAccessFactory.Param("controlerColumnType", String.class, "column name in controller tabel that holds table types");
    public static final DataAccessFactory.Param PARAM_CONTROLER_FILTER = new DataAccessFactory.Param("controlerFilter", String.class, "sql like filter to apply to controler table");
    public static final DataAccessFactory.Param PARAM_CONTROLER_FILTER_REVERSE = new DataAccessFactory.Param("controlerFilterReverse", Boolean.class, "if true use not like insteadof like");
    public static final DataAccessFactory.Param PARAM_SRS = new DataAccessFactory.Param("srs", String.class, "EPSG code of projection, e.g. EPSG:28992");
    public static final DataAccessFactory.Param PARAM_XLABELS = new DataAccessFactory.Param("xlabels", String.class, "comma separated list of column names with x coordinates (one per type)");
    public static final DataAccessFactory.Param PARAM_YLABELS = new DataAccessFactory.Param("ylabels", String.class, "comma separated list of column names with y coordinates (one per type)");

    public String getDisplayName() {
        return "MS Access database";
    }

    public String getDescription() {
        return "MS Access database";
    }

    public String[] getFileExtensions() {
        return new String[]{".mdb"};
    }

    public boolean canProcess(URL f) {
        return f.getFile().toLowerCase().endsWith(".mdb");
    }

    public boolean canProcess(Map params) {
        boolean result = false;
        if (params.containsKey(MsAccessDataStoreFactory.PARAM_URL.key)) {
            try {
                URL url = (URL)PARAM_URL.lookUp(params);
                result = this.canProcess(url);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return result;
    }

    public boolean isAvailable() {
        return true;
    }

    public DataAccessFactory.Param[] getParametersInfo() {
        return new DataAccessFactory.Param[]{PARAM_URL};
    }

    public Map getImplementationHints() {
        return Collections.EMPTY_MAP;
    }

    public String getTypeName(URL url) throws IOException {
        return null;
    }

    public FileDataStore createDataStore(URL url) throws IOException {
        HashMap<String, URL> params = new HashMap<String, URL>();
        params.put(MsAccessDataStoreFactory.PARAM_URL.key, url);
        boolean isLocal = url.getProtocol().equalsIgnoreCase("file");
        if (isLocal && !new File(url.getFile()).exists()) {
            throw new UnsupportedOperationException("Specified MS Access database \"" + url + "\" does not exist, this plugin is read-only so no new file will be created");
        }
        return this.createDataStore(params);
    }

    public FileDataStore createDataStore(Map params) throws IOException {
        if (!this.canProcess(params)) {
            throw new FileNotFoundException("MS Access database not found: " + params);
        }
        return new MsAccessDataStore(params);
    }

    public DataStore createNewDataStore(Map params) throws IOException {
        throw new UnsupportedOperationException("This plugin is read-only");
    }
}

