/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.geotools.data.msaccess;

import com.vividsolutions.jts.geom.Geometry;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.feature.AttributeTypeBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.referencing.CRS;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class SpatialUtil {
    private static final Log log = LogFactory.getLog(SpatialUtil.class);

    public static AttributeDescriptor createAttributeType(String label, int sqlType) {
        Object at = null;
        AttributeTypeBuilder attributeTypeBuilder = new AttributeTypeBuilder();
        attributeTypeBuilder.setName(label);
        if (sqlType == -5 || sqlType == 4 || sqlType == 5 || sqlType == -6) {
            attributeTypeBuilder.setBinding(Long.class);
        } else if (sqlType == 91 || sqlType == 92 || sqlType == 93) {
            attributeTypeBuilder.setBinding(Timestamp.class);
        } else if (sqlType == 3 || sqlType == 8 || sqlType == 6 || sqlType == 7 || sqlType == 2) {
            attributeTypeBuilder.setBinding(Double.class);
        } else if (sqlType == 1 || sqlType == 2005 || sqlType == -1 || sqlType == 12) {
            attributeTypeBuilder.setBinding(String.class);
        } else if (sqlType == 1111 || sqlType == 2004) {
            attributeTypeBuilder.setBinding(Object.class);
        }
        return attributeTypeBuilder.buildDescriptor(label);
    }

    public static List getAttributeTypes(String typeName, Connection conn) throws Exception {
        DatabaseMetaData dbmd = conn.getMetaData();
        if (typeName == null) {
            return null;
        }
        ResultSet rs = dbmd.getColumns(null, null, typeName, null);
        ArrayList<AttributeDescriptor> attributeTypes = null;
        while (rs.next()) {
            if (attributeTypes == null) {
                attributeTypes = new ArrayList<AttributeDescriptor>();
            }
            String columnName = rs.getString("COLUMN_NAME");
            int sqlType = rs.getInt("DATA_TYPE");
            attributeTypes.add(SpatialUtil.createAttributeType(columnName, sqlType));
        }
        return attributeTypes;
    }

    public static SimpleFeatureType createFeatureType(String typeName, String epsg, Connection conn) throws Exception {
        List ats = SpatialUtil.getAttributeTypes(typeName, conn);
        if (ats == null || ats.isEmpty()) {
            return null;
        }
        CoordinateReferenceSystem crs = CRS.decode((String)epsg);
        AttributeTypeBuilder atb = new AttributeTypeBuilder();
        atb.setName("the_geom");
        atb.setCRS(crs);
        atb.setBinding(Geometry.class);
        atb.setNillable(true);
        ats.add(atb.buildDescriptor("the_geom"));
        AttributeDescriptor[] attributes = ats.toArray(new AttributeDescriptor[ats.size()]);
        SimpleFeatureTypeBuilder ftb = new SimpleFeatureTypeBuilder();
        ftb.setName(typeName);
        ftb.setAttributes(attributes);
        return ftb.buildFeatureType();
    }

    public static List getTableNames(Connection conn) throws SQLException {
        DatabaseMetaData dbmd = conn.getMetaData();
        String[] types = new String[]{"TABLE", "VIEW"};
        ResultSet rs = dbmd.getTables(null, null, null, types);
        ArrayList<String> tables = null;
        while (rs.next()) {
            String tableName = rs.getString("TABLE_NAME");
            if (tables == null) {
                tables = new ArrayList<String>();
            }
            tables.add(tableName);
        }
        if (tables != null) {
            Collections.sort(tables);
        }
        return tables;
    }

    public static String[] getTableNameArray(Connection conn) throws SQLException {
        List tableList = SpatialUtil.getTableNames(conn);
        if (tableList == null || tableList.isEmpty()) {
            return null;
        }
        return tableList.toArray(new String[tableList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map getLayerMap(String controlerTable, String controlerColumnName, String controlerColumnType, String controlerFilter, boolean controlerFilterReverse, Connection conn) throws SQLException {
        TreeMap<String, String> controlerMap = new TreeMap<String, String>();
        StringBuffer q = new StringBuffer("select ");
        q.append(controlerColumnName);
        if (controlerColumnType != null) {
            q.append(", ");
            q.append(controlerColumnType);
        }
        q.append(" from ");
        q.append(controlerTable);
        if (controlerFilter != null) {
            q.append(" ct where ct.");
            q.append(controlerColumnName);
            if (controlerFilterReverse) {
                q.append(" not");
            }
            q.append(" like '");
            q.append(controlerFilter);
            q.append("'");
        }
        q.append(" ORDER BY ");
        q.append(controlerColumnName);
        log.debug((Object)("query: " + q.toString()));
        try (PreparedStatement statement = conn.prepareStatement(q.toString());){
            ResultSet rs = statement.executeQuery();
            while (rs.next()) {
                if (controlerColumnType != null) {
                    controlerMap.put(rs.getString(controlerColumnName), rs.getString(controlerColumnType));
                    continue;
                }
                controlerMap.put(rs.getString(controlerColumnName), "");
            }
        }
        finally {
            try {
                conn.close();
            }
            catch (SQLException ex) {
                log.error((Object)"", (Throwable)ex);
            }
        }
        if (log.isDebugEnabled() && controlerMap != null) {
            for (String tableName : controlerMap.keySet()) {
                log.debug((Object)("table name:  " + tableName));
            }
        }
        return controlerMap;
    }

    public static String[] getLayerArray(String controlerTable, String controlerColumnName, String controlerColumnType, String controlerFilter, boolean controlerFilterReverse, Connection conn) throws SQLException {
        Map layerMap = SpatialUtil.getLayerMap(controlerTable, controlerColumnName, controlerColumnType, controlerFilter, controlerFilterReverse, conn);
        if (layerMap == null || layerMap.isEmpty()) {
            return null;
        }
        return layerMap.keySet().toArray(new String[layerMap.size()]);
    }
}

