/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.geotools.data.msaccess;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nl.b3p.geotools.data.msaccess.MsAccessDataStoreFactory;
import nl.b3p.geotools.data.msaccess.MsAccessFeatureReader;
import nl.b3p.geotools.data.msaccess.SpatialUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.data.DefaultServiceInfo;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureWriter;
import org.geotools.data.FileDataStore;
import org.geotools.data.LockingManager;
import org.geotools.data.Query;
import org.geotools.data.ServiceInfo;
import org.geotools.data.Transaction;
import org.geotools.data.simple.SimpleFeatureSource;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;

public class MsAccessDataStore
implements FileDataStore {
    private static final Log log = LogFactory.getLog(MsAccessDataStore.class);
    private URL url;
    private Connection dbConn;
    private String controlerTable = null;
    private String controlerColumnName = null;
    private String controlerColumnType = null;
    private String controlerFilter = null;
    private boolean controlerFilterReverse = false;
    private String epsg = null;
    private String[] xLabels = null;
    private String[] yLabels = null;
    private Map featureReaderMap = new HashMap();
    private Map featureTypeMap = new HashMap();

    public MsAccessDataStore(URL url) throws IOException {
        this.url = url;
        this.dbConn = this.getConnection();
    }

    protected Connection getConnection() throws IOException {
        return MsAccessDataStore.getConnection(this.url);
    }

    protected static Connection getConnection(URL url) throws IOException {
        String msaccessFile = url.getFile().toLowerCase().substring(1);
        try {
            Class.forName("sun.jdbc.odbc.JdbcOdbcDriver").newInstance();
        }
        catch (InstantiationException ex) {
            log.error((Object)"JdbcOdbcDriver not found!", (Throwable)ex);
            throw new IOException(ex.getLocalizedMessage());
        }
        catch (IllegalAccessException ex) {
            log.error((Object)"JdbcOdbcDriver not found!", (Throwable)ex);
            throw new IOException(ex.getLocalizedMessage());
        }
        catch (ClassNotFoundException ex) {
            log.error((Object)"JdbcOdbcDriver not found!", (Throwable)ex);
            throw new IOException(ex.getLocalizedMessage());
        }
        String myDB = "jdbc:odbc:Driver={Microsoft Access Driver (*.mdb)};DBQ=" + msaccessFile;
        Connection conn = null;
        try {
            conn = DriverManager.getConnection(myDB, "yuit", "tyuityu");
        }
        catch (SQLException ex) {
            log.error((Object)("Connectionstring: " + myDB));
            log.error((Object)"Connection not made!", (Throwable)ex);
            throw new IOException(ex.getLocalizedMessage());
        }
        return conn;
    }

    public MsAccessDataStore(Map dbconfig) throws IOException {
        this((URL)dbconfig.get(MsAccessDataStoreFactory.PARAM_URL.key));
        this.controlerTable = (String)dbconfig.get(MsAccessDataStoreFactory.PARAM_CONTROLER_TABLE.key);
        this.controlerColumnName = (String)dbconfig.get(MsAccessDataStoreFactory.PARAM_CONTROLER_COLUMN_NAME.key);
        this.controlerColumnType = (String)dbconfig.get(MsAccessDataStoreFactory.PARAM_CONTROLER_COLUMN_TYPE.key);
        this.controlerFilter = (String)dbconfig.get(MsAccessDataStoreFactory.PARAM_CONTROLER_FILTER.key);
        String reverse = (String)dbconfig.get(MsAccessDataStoreFactory.PARAM_CONTROLER_FILTER_REVERSE.key);
        if (reverse != null && reverse.equalsIgnoreCase("true")) {
            this.controlerFilterReverse = true;
        }
        this.epsg = (String)dbconfig.get(MsAccessDataStoreFactory.PARAM_SRS.key);
        String xlbs = (String)dbconfig.get(MsAccessDataStoreFactory.PARAM_XLABELS.key);
        String ylbs = (String)dbconfig.get(MsAccessDataStoreFactory.PARAM_YLABELS.key);
        this.xLabels = xlbs.split(",");
        this.yLabels = ylbs.split(",");
    }

    public String[] getTypeNames() throws IOException {
        try {
            if (this.controlerTable == null || this.controlerColumnName == null) {
                return SpatialUtil.getTableNameArray(this.dbConn);
            }
            return SpatialUtil.getLayerArray(this.controlerTable, this.controlerColumnName, this.controlerColumnType, this.controlerFilter, this.controlerFilterReverse, this.dbConn);
        }
        catch (SQLException ex) {
            throw new IOException(ex.getLocalizedMessage());
        }
    }

    public SimpleFeatureType getSchema(String typeName) throws IOException {
        if (this.featureTypeMap.containsKey(typeName)) {
            return (SimpleFeatureType)this.featureTypeMap.get(typeName);
        }
        try {
            if (this.dbConn.isClosed()) {
                this.dbConn = this.getConnection();
            }
            SimpleFeatureType ft = SpatialUtil.createFeatureType(typeName, this.epsg, this.dbConn);
            this.featureTypeMap.put(typeName, ft);
            return ft;
        }
        catch (Exception ex) {
            throw new IOException(ex.getLocalizedMessage());
        }
    }

    public SimpleFeatureType getSchema(Name name) throws IOException {
        return this.getSchema(name.getLocalPart());
    }

    public SimpleFeatureType getSchema() throws IOException {
        return null;
    }

    public List<Name> getNames() throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public FeatureReader getFeatureReader(String typeName) throws IOException {
        if (this.featureReaderMap.containsKey(typeName)) {
            return (FeatureReader)this.featureReaderMap.get(typeName);
        }
        try {
            MsAccessFeatureReader fr = new MsAccessFeatureReader(this.getSchema(typeName), this.xLabels, this.yLabels, this.dbConn);
            this.featureReaderMap.put(typeName, fr);
            return fr;
        }
        catch (Exception ex) {
            throw new IOException(ex.getLocalizedMessage());
        }
    }

    public FeatureReader getFeatureReader() throws IOException {
        return null;
    }

    public FeatureReader<SimpleFeatureType, SimpleFeature> getFeatureReader(Query query, Transaction t) throws IOException {
        return this.getFeatureReader(query.getTypeName());
    }

    public SimpleFeatureSource getFeatureSource() throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public SimpleFeatureSource getFeatureSource(String string) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public SimpleFeatureSource getFeatureSource(Name name) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void createSchema(SimpleFeatureType t) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateSchema(Name name, SimpleFeatureType t) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateSchema(SimpleFeatureType sft) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateSchema(String string, SimpleFeatureType sft) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void removeSchema(String string) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void removeSchema(Name name) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriter(Filter filter, Transaction t) throws IOException {
        throw new UnsupportedOperationException("Functie niet ondersteund voor alleen-lezen databron.");
    }

    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriter(Transaction t) throws IOException {
        throw new UnsupportedOperationException("Functie niet ondersteund voor alleen-lezen databron.");
    }

    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriterAppend(Transaction t) throws IOException {
        throw new UnsupportedOperationException("Functie niet ondersteund voor alleen-lezen databron.");
    }

    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriter(String string, Filter filter, Transaction t) throws IOException {
        throw new UnsupportedOperationException("Functie niet ondersteund voor alleen-lezen databron.");
    }

    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriter(String string, Transaction t) throws IOException {
        throw new UnsupportedOperationException("Functie niet ondersteund voor alleen-lezen databron.");
    }

    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriterAppend(String string, Transaction t) throws IOException {
        throw new UnsupportedOperationException("Functie niet ondersteund voor alleen-lezen databron.");
    }

    public LockingManager getLockingManager() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ServiceInfo getInfo() {
        DefaultServiceInfo serviceInfo = new DefaultServiceInfo();
        serviceInfo.setTitle("MSAccess DataStore");
        try {
            serviceInfo.setSource(this.url.toURI());
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return serviceInfo;
    }

    public void dispose() {
        try {
            this.dbConn.close();
        }
        catch (NullPointerException | SQLException ex) {
            log.debug((Object)"Mogelijk probleem met sluiten van DB verbinding", (Throwable)ex);
        }
        this.dbConn = null;
    }
}

