/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.geotools.data.ogr;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import nl.b3p.geotools.data.ogr.OGRProcessor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.data.AbstractFileDataStore;
import org.geotools.data.DataStore;
import org.geotools.data.FeatureReader;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.postgis.PostgisNGDataStoreFactory;
import org.opengis.feature.simple.SimpleFeatureType;

public class OGRDataStore
extends AbstractFileDataStore {
    private static final Log log = LogFactory.getLog(OGRDataStore.class);
    private URL url;
    private String strippedFile;
    private String srs;
    private DataStore postgisDataStore;
    private OGRProcessor processor;
    private Map ogr_tmp_db;

    public OGRDataStore(URL url, String srs, Map ogr_tmp_db, boolean skipFailures, Map ogr_settings, boolean noDrop) throws IOException {
        this.url = url;
        this.srs = srs;
        this.ogr_tmp_db = ogr_tmp_db;
        this.strippedFile = OGRDataStore.getTypeName(url);
        this.processor = new OGRProcessor(url, ogr_tmp_db, srs, skipFailures, this.strippedFile, ogr_settings, noDrop);
        this.processor.process();
        this.postgisDataStore = new PostgisNGDataStoreFactory().createDataStore(ogr_tmp_db);
    }

    public String[] getTypeNames() throws IOException {
        return new String[]{this.strippedFile};
    }

    public static String getTypeName(URL url) throws IOException {
        File file = new File(url.getFile());
        String strippedFile = file.getName();
        strippedFile = strippedFile.substring(0, strippedFile.indexOf("."));
        return strippedFile;
    }

    public SimpleFeatureType getSchema(String typename) throws IOException {
        return this.postgisDataStore.getSchema(typename);
    }

    public SimpleFeatureType getSchema() throws IOException {
        return this.getSchema(this.strippedFile);
    }

    public FeatureReader getFeatureReader(Query query, Transaction trans) throws IOException {
        return this.postgisDataStore.getFeatureReader(query, trans);
    }

    public FeatureReader getFeatureReader() throws IOException {
        return (FeatureReader)this.postgisDataStore.getFeatureSource(this.strippedFile);
    }

    public FeatureReader getFeatureReader(String typename) throws IOException {
        return (FeatureReader)this.postgisDataStore.getFeatureSource(typename);
    }

    public void dispose() {
        this.processor.close(this.postgisDataStore);
        this.postgisDataStore.dispose();
        super.dispose();
    }
}

