/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.geotools.data.ogr;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import nl.b3p.geotools.data.ogr.OGRProcessor;
import org.geotools.data.DataStore;
import org.geotools.data.DefaultServiceInfo;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureWriter;
import org.geotools.data.FileDataStore;
import org.geotools.data.LockingManager;
import org.geotools.data.Query;
import org.geotools.data.ServiceInfo;
import org.geotools.data.Transaction;
import org.geotools.data.postgis.PostgisNGDataStoreFactory;
import org.geotools.data.simple.SimpleFeatureSource;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;

public class OGRDataStore
implements FileDataStore {
    private final URL url;
    private final String strippedFile;
    private final DataStore postgisDataStore;
    private final OGRProcessor processor;

    public static String getTypeName(URL url) throws IOException {
        File file = new File(url.getFile());
        String strippedFile = file.getName();
        strippedFile = strippedFile.substring(0, strippedFile.indexOf("."));
        return strippedFile;
    }

    public OGRDataStore(URL url, String srs, Map ogr_tmp_db, boolean skipFailures, Map ogr_settings, boolean noDrop) throws IOException {
        this.url = url;
        this.strippedFile = OGRDataStore.getTypeName(url);
        this.processor = new OGRProcessor(url, ogr_tmp_db, srs, skipFailures, this.strippedFile, ogr_settings, noDrop);
        this.processor.process();
        this.postgisDataStore = new PostgisNGDataStoreFactory().createDataStore(ogr_tmp_db);
    }

    public String[] getTypeNames() throws IOException {
        return new String[]{this.strippedFile};
    }

    public List<Name> getNames() throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public SimpleFeatureType getSchema(Name name) throws IOException {
        return (SimpleFeatureType)this.postgisDataStore.getSchema(name);
    }

    public SimpleFeatureType getSchema(String typename) throws IOException {
        return this.postgisDataStore.getSchema(typename);
    }

    public SimpleFeatureType getSchema() throws IOException {
        return this.getSchema(this.strippedFile);
    }

    public FeatureReader getFeatureReader(Query query, Transaction trans) throws IOException {
        return this.postgisDataStore.getFeatureReader(query, trans);
    }

    public FeatureReader getFeatureReader() throws IOException {
        return (FeatureReader)this.postgisDataStore.getFeatureSource(this.strippedFile);
    }

    public FeatureReader getFeatureReader(String typename) throws IOException {
        return (FeatureReader)this.postgisDataStore.getFeatureSource(typename);
    }

    public SimpleFeatureSource getFeatureSource() throws IOException {
        return this.postgisDataStore.getFeatureSource(this.strippedFile);
    }

    public SimpleFeatureSource getFeatureSource(String string) throws IOException {
        return this.postgisDataStore.getFeatureSource(string);
    }

    public SimpleFeatureSource getFeatureSource(Name name) throws IOException {
        return this.postgisDataStore.getFeatureSource(name);
    }

    public void updateSchema(SimpleFeatureType sft) throws IOException {
        this.postgisDataStore.updateSchema(this.strippedFile, sft);
    }

    public void updateSchema(String string, SimpleFeatureType sft) throws IOException {
        this.postgisDataStore.updateSchema(string, sft);
    }

    public void updateSchema(Name name, SimpleFeatureType t) throws IOException {
        this.postgisDataStore.updateSchema(name, (FeatureType)t);
    }

    public void createSchema(SimpleFeatureType t) throws IOException {
        this.postgisDataStore.createSchema((FeatureType)t);
    }

    public void removeSchema(String string) throws IOException {
        this.postgisDataStore.removeSchema(string);
    }

    public void removeSchema(Name name) throws IOException {
        this.postgisDataStore.removeSchema(name);
    }

    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriter(Filter filter, Transaction t) throws IOException {
        return this.getFeatureWriter(this.strippedFile, filter, t);
    }

    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriter(Transaction t) throws IOException {
        return this.getFeatureWriter(this.strippedFile, t);
    }

    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriter(String string, Filter filter, Transaction t) throws IOException {
        return this.postgisDataStore.getFeatureWriter(string, filter, t);
    }

    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriter(String string, Transaction t) throws IOException {
        return this.postgisDataStore.getFeatureWriter(string, t);
    }

    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriterAppend(String string, Transaction t) throws IOException {
        return this.postgisDataStore.getFeatureWriterAppend(string, t);
    }

    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriterAppend(Transaction t) throws IOException {
        return this.getFeatureWriterAppend(this.strippedFile, t);
    }

    public LockingManager getLockingManager() {
        return this.postgisDataStore.getLockingManager();
    }

    public ServiceInfo getInfo() {
        DefaultServiceInfo serviceInfo = new DefaultServiceInfo();
        serviceInfo.setTitle("OGR DataStore");
        try {
            serviceInfo.setSource(this.url.toURI());
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return serviceInfo;
    }

    public void dispose() {
        this.processor.close(this.postgisDataStore);
        this.postgisDataStore.dispose();
    }
}

