/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.geotools.data.ogr;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import nl.b3p.geotools.data.ogr.OGRDataStore;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.data.DataStore;
import org.geotools.data.Transaction;
import org.geotools.jdbc.JDBCDataStore;

public class OGRProcessor {
    private static final Log log = LogFactory.getLog(OGRDataStore.class);
    private String file_in;
    private Map db_out;
    private String srs;
    private boolean skipFailures;
    private String typename;
    private String fwtools_dir;
    private Map<String, String> envirionment = new HashMap<String, String>();
    private boolean noDrop;

    public OGRProcessor(URL url, Map db_tmp, String srs, boolean skipFailures, String typename, Map osFWTools, boolean noDrop) throws IOException {
        this.file_in = new File(url.getFile()).getAbsolutePath();
        this.typename = typename;
        this.db_out = OGRProcessor.translateParams(db_tmp);
        this.srs = srs;
        this.skipFailures = skipFailures;
        this.noDrop = noDrop;
        this.setDirAndSetEnv(osFWTools);
    }

    public void process() throws IOException {
        String errorLine;
        ArrayList<String> commandList = new ArrayList<String>();
        commandList.add(this.fwtools_dir + "bin/ogr2ogr");
        commandList.add("-f");
        commandList.add("PostgreSQL");
        commandList.add("-a_srs");
        commandList.add(this.srs);
        commandList.add(this.mapToDBString(this.db_out));
        commandList.add(this.file_in);
        commandList.add("-nln");
        commandList.add(this.typename);
        commandList.add("-overwrite");
        if (this.skipFailures) {
            commandList.add("-skipfailures");
        }
        String[] commands = commandList.toArray(new String[commandList.size()]);
        ProcessBuilder pb = new ProcessBuilder(commands);
        pb.environment().putAll(this.envirionment);
        log.info((Object)"Starting OGR2OGR process");
        Process child = pb.start();
        BufferedReader errorReader = new BufferedReader(new InputStreamReader(child.getErrorStream()));
        String errorText = "";
        while ((errorLine = errorReader.readLine()) != null) {
            errorText = errorText + errorLine + "\n";
        }
        if (!errorText.equals("")) {
            log.error((Object)errorText);
        }
        try {
            int result = child.waitFor();
            if (result != 0) {
                if (errorText.equals("")) {
                    throw new IOException("Loading file '" + this.file_in + "' failed. No error available");
                }
                throw new IOException("Loading file '" + this.file_in + "' failed. " + errorText);
            }
        }
        catch (InterruptedException ex) {
            throw new IOException(ex.getMessage(), ex.getCause());
        }
    }

    private String mapToDBString(Map params) {
        String connect = "PG: ";
        for (String key : params.keySet()) {
            String value = (String)params.get(key);
            connect = connect + key + "=" + value + " ";
        }
        return connect.substring(0, connect.length() - 1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setDirAndSetEnv(Map osParams) throws IOException {
        String os = System.getProperty("os.name");
        if (os.toLowerCase().contains("windows")) {
            os = "windows";
        } else if (os.toLowerCase().contains("linux")) {
            os = "linux";
        } else if (os.toLowerCase().contains("mac")) {
            os = "mac";
        }
        if (osParams.containsKey(os)) {
            if (!(osParams.get(os) instanceof Map)) throw new IOException("Expected " + os + " to contain subdirs .dir and .env");
            if (!(osParams = (Map)osParams.get(os)).containsKey("dir")) throw new IOException("Property " + os + ".dir not found");
            if (!(osParams.get("dir") instanceof String)) throw new IOException("Expected " + os + ".dir to contain single value");
            this.fwtools_dir = (String)osParams.get("dir");
        }
        if (!osParams.containsKey("env") || !(osParams.get("env") instanceof Map)) return;
        Map envirionmentParameters = (Map)osParams.get("env");
        for (String key : envirionmentParameters.keySet()) {
            if (!(envirionmentParameters.get(key) instanceof String)) throw new IOException("Expected " + os + ".env." + key + " to contain single value");
            String value = (String)envirionmentParameters.get(key);
            this.envirionment.put(key, this.fwtools_dir + value);
        }
    }

    public static Map translateParams(Map map) {
        HashMap newMap = new HashMap();
        String[][] translate = new String[][]{{"passwd", "password"}, {"host", "host"}, {"user", "user"}, {"database", "dbname"}};
        for (int i = 0; i < translate.length; ++i) {
            if (!map.containsKey(translate[i][0])) continue;
            newMap.put(translate[i][1], map.get(translate[i][0]));
        }
        return newMap;
    }

    public void close(DataStore dataStore2Read) {
        if (!this.noDrop) {
            try {
                JDBCDataStore database = (JDBCDataStore)dataStore2Read;
                Connection con = database.getConnection(Transaction.AUTO_COMMIT);
                con.setAutoCommit(true);
                PreparedStatement ps = con.prepareStatement("DROP TABLE \"" + this.typename + "\"; DELETE FROM \"geometry_columns\" WHERE f_table_name = '" + this.typename + "'");
                ps.execute();
                con.close();
            }
            catch (Exception ex) {
                log.error((Object)ex.getLocalizedMessage());
            }
        }
    }
}

