/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.geotools.data.ogr;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import nl.b3p.geotools.data.ogr.OGRDataStore;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.DataStore;
import org.geotools.data.FileDataStore;
import org.geotools.data.FileDataStoreFactorySpi;
import org.geotools.referencing.CRS;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;

public class OGRDataStoreFactory
implements FileDataStoreFactorySpi {
    public static final DataAccessFactory.Param PARAM_URL = new DataAccessFactory.Param("url", URL.class, "url to a file supported by ogr2ogr");
    public static final DataAccessFactory.Param PARAM_SRS = new DataAccessFactory.Param("srs", String.class, "override srs");
    public static final DataAccessFactory.Param PARAM_OGR_TMP_DB = new DataAccessFactory.Param("ogr_tmp_db", Map.class, "PostGIS temp database");
    public static final DataAccessFactory.Param PARAM_SKIPFAILURES = new DataAccessFactory.Param("skip_failures", Boolean.class, "skip ogr2ogr failures");
    public static final DataAccessFactory.Param PARAM_OGR_SETTINGS = new DataAccessFactory.Param("ogr_settings", Map.class, "Map containing os specific values for FWTools dirs");
    public static final DataAccessFactory.Param PARAM_NO_TEMP_DROP = new DataAccessFactory.Param("no_tmp_drop", Boolean.class, "Disable drop of temp table");
    private static final String[] SUPPORTED = new String[]{"tab", "gml", "kml"};

    public String getDisplayName() {
        return "OGR File";
    }

    public String getDescription() {
        return "Load files using ogr2ogr";
    }

    public String[] getFileExtensions() {
        return SUPPORTED;
    }

    public boolean canProcess(URL f) {
        for (int i = 0; i < SUPPORTED.length; ++i) {
            if (!f.getFile().toLowerCase().endsWith("." + SUPPORTED[i])) continue;
            return true;
        }
        return false;
    }

    public boolean canProcess(String srs) throws NoSuchAuthorityCodeException, FactoryException {
        return CRS.decode((String)srs) != null;
    }

    public boolean canProcess(Map params) {
        boolean result = false;
        if (params.containsKey(OGRDataStoreFactory.PARAM_URL.key) && params.containsKey(OGRDataStoreFactory.PARAM_OGR_TMP_DB.key) && params.containsKey(OGRDataStoreFactory.PARAM_SKIPFAILURES.key) && params.containsKey(OGRDataStoreFactory.PARAM_OGR_SETTINGS.key)) {
            try {
                URL url = (URL)PARAM_URL.lookUp(params);
                result = this.canProcess(url);
            }
            catch (IOException url) {
                // empty catch block
            }
        }
        if (result && params.containsKey(OGRDataStoreFactory.PARAM_SRS.key)) {
            try {
                String srs = (String)PARAM_SRS.lookUp(params);
                result = this.canProcess(srs);
            }
            catch (NoSuchAuthorityCodeException noSuchAuthorityCodeException) {
            }
            catch (FactoryException factoryException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return result;
    }

    public boolean isAvailable() {
        return true;
    }

    public DataAccessFactory.Param[] getParametersInfo() {
        return new DataAccessFactory.Param[]{PARAM_URL};
    }

    public Map getImplementationHints() {
        return Collections.EMPTY_MAP;
    }

    public String getTypeName(URL url) throws IOException {
        return OGRDataStore.getTypeName(url);
    }

    public FileDataStore createDataStore(URL url) throws IOException {
        HashMap<String, URL> params = new HashMap<String, URL>();
        params.put(OGRDataStoreFactory.PARAM_URL.key, url);
        boolean isLocal = url.getProtocol().equalsIgnoreCase("file");
        if (isLocal && !new File(url.getFile()).exists()) {
            throw new UnsupportedOperationException("Specified file \"" + url + "\" does not exist, this plugin is read-only so no new file will be created");
        }
        return this.createDataStore(params);
    }

    public FileDataStore createDataStore(Map params) throws IOException {
        if (!this.canProcess(params)) {
            throw new FileNotFoundException("File not found: " + params);
        }
        boolean noDrop = false;
        if (params.containsKey(OGRDataStoreFactory.PARAM_NO_TEMP_DROP.key)) {
            noDrop = (Boolean)params.get(OGRDataStoreFactory.PARAM_NO_TEMP_DROP.key);
        }
        return new OGRDataStore((URL)params.get(OGRDataStoreFactory.PARAM_URL.key), (String)params.get(OGRDataStoreFactory.PARAM_SRS.key), (Map)params.get(OGRDataStoreFactory.PARAM_OGR_TMP_DB.key), (Boolean)params.get(OGRDataStoreFactory.PARAM_SKIPFAILURES.key), (Map)params.get(OGRDataStoreFactory.PARAM_OGR_SETTINGS.key), noDrop);
    }

    public DataStore createNewDataStore(Map params) throws IOException {
        throw new UnsupportedOperationException("This plugin is read-only");
    }
}

