/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.geotools.data.sdl;

import java.io.IOException;
import java.net.URL;
import nl.b3p.geotools.data.sdl.SDLFeatureReader;
import nl.b3p.geotools.data.sdl.SDLParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.data.AbstractFileDataStore;
import org.geotools.data.FeatureReader;
import org.opengis.feature.simple.SimpleFeatureType;

public class SDLDataStore
extends AbstractFileDataStore {
    private static final Log log = LogFactory.getLog(SDLDataStore.class);
    private URL url;
    private String typeName;
    private FeatureReader FeatureReader;
    private String srs;

    public SDLDataStore(URL url, String srs) throws IOException {
        this.url = url;
        this.typeName = SDLDataStore.getURLTypeName(url);
        this.srs = srs;
    }

    public String[] getTypeNames() throws IOException {
        return new String[]{SDLDataStore.getURLTypeName(this.url)};
    }

    static String getURLTypeName(URL url) throws IOException {
        String file = url.getFile();
        if (file.length() == 0) {
            return "unknown_sdl";
        }
        int i = file.lastIndexOf(47);
        if (i != -1) {
            file = file.substring(i + 1);
        }
        if (file.toLowerCase().endsWith(".sdl")) {
            file = file.substring(0, file.length() - 4);
        }
        return file;
    }

    public SimpleFeatureType getSchema(String typeName) throws IOException {
        return this.getSchema();
    }

    public SimpleFeatureType getSchema() throws IOException {
        return (SimpleFeatureType)this.getFeatureReader().getFeatureType();
    }

    public FeatureReader getFeatureReader(String typeName) throws IOException {
        return this.getFeatureReader();
    }

    public FeatureReader getFeatureReader() throws IOException {
        if (this.FeatureReader == null) {
            try {
                this.FeatureReader = new SDLFeatureReader(this.url, this.typeName, this.srs);
            }
            catch (SDLParseException e) {
                throw new IOException("SDL parse exception" + e.getLocalizedMessage());
            }
        }
        return this.FeatureReader;
    }
}

