/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.geotools.data.sdl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import nl.b3p.geotools.data.sdl.SDLDataStore;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.DataStore;
import org.geotools.data.FileDataStore;
import org.geotools.data.FileDataStoreFactorySpi;
import org.geotools.referencing.CRS;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;

public class SDLDataStoreFactory
implements FileDataStoreFactorySpi {
    public static final DataAccessFactory.Param PARAM_URL = new DataAccessFactory.Param("url", URL.class, "url to a .sdl file");
    public static final DataAccessFactory.Param PARAM_SRS = new DataAccessFactory.Param("srs", String.class, "override srs");

    public String getDisplayName() {
        return "SDL File";
    }

    public String getDescription() {
        return "Autodesk SDF Loader SDL format";
    }

    public String[] getFileExtensions() {
        return new String[]{".sdl"};
    }

    public boolean canProcess(URL f) {
        return f.getFile().toLowerCase().endsWith(".sdl");
    }

    public boolean canProcess(String srs) throws NoSuchAuthorityCodeException, FactoryException {
        return CRS.decode((String)srs) != null;
    }

    public boolean canProcess(Map params) {
        boolean result = false;
        if (params.containsKey(SDLDataStoreFactory.PARAM_URL.key)) {
            try {
                URL url = (URL)PARAM_URL.lookUp(params);
                result = this.canProcess(url);
            }
            catch (IOException url) {
                // empty catch block
            }
        }
        if (result && params.containsKey(SDLDataStoreFactory.PARAM_SRS.key)) {
            try {
                String srs = (String)PARAM_SRS.lookUp(params);
                result = this.canProcess(srs);
            }
            catch (NoSuchAuthorityCodeException noSuchAuthorityCodeException) {
            }
            catch (FactoryException factoryException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return result;
    }

    public boolean isAvailable() {
        return true;
    }

    public DataAccessFactory.Param[] getParametersInfo() {
        return new DataAccessFactory.Param[]{PARAM_URL};
    }

    public Map getImplementationHints() {
        return Collections.EMPTY_MAP;
    }

    public String getTypeName(URL url) throws IOException {
        return SDLDataStore.getURLTypeName(url);
    }

    public FileDataStore createDataStore(URL url) throws IOException {
        HashMap<String, URL> params = new HashMap<String, URL>();
        params.put(SDLDataStoreFactory.PARAM_URL.key, url);
        boolean isLocal = url.getProtocol().equalsIgnoreCase("file");
        if (isLocal && !new File(url.getFile()).exists()) {
            throw new UnsupportedOperationException("Specified SDL file \"" + url + "\" does not exist, this plugin is read-only so no new file will be created");
        }
        return this.createDataStore(params);
    }

    public FileDataStore createDataStore(Map params) throws IOException {
        if (!this.canProcess(params)) {
            throw new FileNotFoundException("SDL file not found: " + params);
        }
        return new SDLDataStore((URL)params.get(SDLDataStoreFactory.PARAM_URL.key), (String)params.get(SDLDataStoreFactory.PARAM_SRS.key));
    }

    public DataStore createNewDataStore(Map params) throws IOException {
        throw new UnsupportedOperationException("This plugin is read-only");
    }
}

