/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.geotools.data.sdl;

import java.io.EOFException;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import nl.b3p.geotools.data.sdl.SDLParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.locationtech.jts.algorithm.CGAlgorithms;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.TopologyException;

class SDLEntry {
    private static final Log log = LogFactory.getLog(SDLEntry.class);
    public static final int TYPE_POINT = 0;
    public static final int TYPE_LINE = 1;
    public static final int TYPE_POLYGON = 2;
    private final int startingLineNumber;
    private final int type;
    private final String name;
    private final String key;
    private final String urlLink;
    private boolean parseError = false;
    private String errorDescription = null;
    private final GeometryFactory geometryFactory;
    private final Geometry geometry;

    public SDLEntry(LineNumberReader input, GeometryFactory geometryFactory) throws IOException, SDLParseException {
        String header;
        do {
            if ((header = input.readLine()) != null) continue;
            throw new EOFException();
        } while (header.length() == 0 || header.charAt(0) == ';');
        this.startingLineNumber = input.getLineNumber();
        this.geometryFactory = geometryFactory;
        this.type = SDLEntry.getEntryType(input, header);
        StringBuffer nameBuf = new StringBuffer();
        StringBuffer keyBuf = new StringBuffer();
        StringBuffer urlLinkBuf = new StringBuffer();
        int pos = 2;
        try {
            pos = this.readQuotedString(header, pos, nameBuf);
            pos = this.readQuotedString(header, pos, keyBuf);
            pos = this.readQuotedString(header, pos, urlLinkBuf);
        }
        catch (IndexOutOfBoundsException e) {
            throw new SDLParseException(this, "invalid entry header");
        }
        int numPts = -1;
        try {
            numPts = Integer.parseInt(header.substring(pos + 1));
        }
        catch (Exception e) {
            throw new SDLParseException(this, "invalid entry header: can't parse NumPts");
        }
        this.name = nameBuf.toString();
        this.key = keyBuf.toString();
        this.urlLink = urlLinkBuf.toString();
        ArrayList<Coordinate> entryCoordinates = new ArrayList<Coordinate>();
        for (int i = 0; i < numPts; ++i) {
            try {
                entryCoordinates.add(this.parseCoordinate(input.readLine()));
                continue;
            }
            catch (NumberFormatException nfe) {
                throw new SDLParseException(input, "error parsing number: " + nfe.getMessage());
            }
            catch (Exception ioe) {
                throw new SDLParseException(input, ioe.getMessage());
            }
        }
        this.geometry = this.createGeometry(entryCoordinates);
    }

    private static int getEntryType(LineNumberReader lnr, String header) throws SDLParseException {
        if (header == null || header.length() == 0) {
            throw new SDLParseException(lnr, "Expected header, found empty line!");
        }
        char entryType = header.charAt(0);
        switch (entryType) {
            case 'M': {
                return 0;
            }
            case 'P': {
                return 2;
            }
            case 'L': {
                return 1;
            }
        }
        throw new SDLParseException(lnr, "Unkown entry type (expected P, L or M): " + entryType);
    }

    public int getType() {
        return this.type;
    }

    private int readQuotedString(String s, int pos, StringBuffer output) throws IndexOutOfBoundsException, SDLParseException {
        if (s.charAt(pos) == ',') {
            // empty if block
        }
        int n = ++pos;
        ++pos;
        if (s.charAt(n) != '\"') {
            throw new SDLParseException(this, "invalid entry header");
        }
        int length = s.length();
        while (true) {
            char c;
            if ((c = s.charAt(pos++)) == '\"') {
                if (pos >= length || s.charAt(pos) != '\"') break;
                output.append('\"');
                ++pos;
                continue;
            }
            output.append(c);
        }
        return pos;
    }

    private Coordinate parseCoordinate(String line) throws SDLParseException {
        if (line == null || line.trim().length() == 0) {
            throw new SDLParseException(this, "Unexpected end of input");
        }
        String[] coords = line.split(",");
        return new Coordinate(Double.parseDouble(coords[1]), Double.parseDouble(coords[0]));
    }

    public int getStartingLineNumber() {
        return this.startingLineNumber;
    }

    public String getName() {
        return this.name;
    }

    public String getKey() {
        return this.key;
    }

    public String getUrlLink() {
        return this.urlLink;
    }

    public Geometry getGeometry() {
        return this.geometry;
    }

    public boolean isParseError() {
        return this.parseError;
    }

    public String getErrorDescription() {
        return this.errorDescription;
    }

    private Geometry createGeometry(List<Coordinate> entryCoordinates) throws SDLParseException {
        if (entryCoordinates.isEmpty()) {
            return new GeometryCollection(new Geometry[0], this.geometryFactory);
        }
        try {
            switch (this.type) {
                case 0: {
                    return this.createPointGeometry(entryCoordinates);
                }
                case 1: {
                    return this.createLineGeometry(entryCoordinates);
                }
                case 2: {
                    return this.createPolygonGeometry(entryCoordinates);
                }
            }
            throw new IllegalStateException();
        }
        catch (Exception e) {
            if (e instanceof SDLParseException) {
                throw (SDLParseException)e;
            }
            throw new SDLParseException(this, "Error creating geometry", e);
        }
    }

    private Geometry createPointGeometry(List<Coordinate> entryCoordinates) throws SDLParseException {
        if (entryCoordinates.size() != 1) {
            throw new SDLParseException(this, "Point can have only one coordinate");
        }
        return this.geometryFactory.createPoint(entryCoordinates.get(0));
    }

    private Geometry createLineGeometry(List<Coordinate> entryCoordinates) throws SDLParseException {
        ArrayList<LineString> lineStrings = new ArrayList<LineString>();
        Iterator<Coordinate> coordinatesIterator = entryCoordinates.iterator();
        do {
            LineString lineString;
            if ((lineString = this.createLineString(coordinatesIterator)).isEmpty()) continue;
            lineStrings.add(lineString);
        } while (coordinatesIterator.hasNext());
        MultiLineString g = null;
        if (lineStrings.size() > 1) {
            g = this.geometryFactory.createMultiLineString(lineStrings.toArray(new LineString[0]));
        } else if (lineStrings.size() == 1) {
            g = this.geometryFactory.createLineString(((LineString)lineStrings.get(0)).getCoordinates());
        } else {
            log.error((Object)"error converting Line: linestrings[] < 1 createLineGeometry");
            g = null;
        }
        return g;
    }

    private LineString createLineString(Iterator<Coordinate> coordinatesIterator) throws SDLParseException {
        Coordinate c;
        ArrayList<Coordinate> vertices = new ArrayList<Coordinate>();
        Coordinate first = coordinatesIterator.next();
        vertices.add(first);
        if (!coordinatesIterator.hasNext()) {
            this.addError("Polyline must have at least two coordinates");
            return this.geometryFactory.createLineString((Coordinate[])null);
        }
        vertices.add(coordinatesIterator.next());
        while (coordinatesIterator.hasNext() && !(c = coordinatesIterator.next()).equals((Object)first)) {
            vertices.add(c);
        }
        return this.geometryFactory.createLineString(vertices.toArray(new Coordinate[0]));
    }

    private void addError(String msg) {
        if (!this.parseError) {
            this.parseError = true;
            this.errorDescription = "entry starting line " + this.startingLineNumber + ": " + msg;
        } else {
            this.errorDescription = this.errorDescription + "; " + msg;
        }
    }

    private Geometry createPolygonGeometry(List<Coordinate> entryCoordinates) throws SDLParseException {
        ArrayList<LinearRing> rings = new ArrayList<LinearRing>();
        int index = 0;
        int size = entryCoordinates.size();
        do {
            ArrayList<Coordinate> vertices = new ArrayList<Coordinate>(size);
            boolean closed = false;
            while (index < size) {
                Coordinate c = entryCoordinates.get(index++);
                if (vertices.size() != 0 && c.equals(vertices.get(vertices.size() - 1))) continue;
                vertices.add(c);
                if (vertices.size() <= 1 || !c.equals(vertices.get(0))) continue;
                closed = true;
                break;
            }
            if (!closed) {
                if (rings.isEmpty()) {
                    this.addError("unclosed polygon -- empty entry");
                    break;
                }
                this.addError("unclosed polygon -- entry has " + rings.size() + " valid polygons");
                break;
            }
            if (vertices.size() <= 3) {
                boolean endOfEntry = index == size;
                boolean emptyEntry = rings.isEmpty();
                String error = "polygon " + (rings.size() + 1) + " has insufficient vertices";
                if (endOfEntry) {
                    error = emptyEntry ? error + " -- empty entry" : error + " -- entry has " + rings.size() + " valid polygons";
                }
                this.addError(error);
                continue;
            }
            rings.add(this.geometryFactory.createLinearRing(vertices.toArray(new Coordinate[0])));
        } while (index < size);
        List<Polygon> polygons = this.foldHoles(rings);
        MultiPolygon g = null;
        if (polygons == null) {
            return null;
        }
        if (polygons.size() > 1) {
            g = this.geometryFactory.createMultiPolygon(GeometryFactory.toPolygonArray(polygons));
        } else if (polygons.size() == 1) {
            LinearRing[] interiorRings = new LinearRing[polygons.get(0).getNumInteriorRing()];
            for (int i = 0; i < polygons.get(0).getNumInteriorRing(); ++i) {
                interiorRings[i] = (LinearRing)polygons.get(0).getInteriorRingN(i);
            }
            g = this.geometryFactory.createPolygon((LinearRing)polygons.get(0).getExteriorRing(), interiorRings);
        } else {
            log.error((Object)"error converting Polygon: polygons[] < 1 createPolygonGeometry");
            g = null;
        }
        return g;
    }

    private List<Polygon> foldHoles(List<LinearRing> rings) {
        int i;
        ArrayList<Polygon> polygons = new ArrayList<Polygon>(rings.size());
        ArrayList<Boolean> ccwCache = new ArrayList<Boolean>(rings.size());
        for (i = 0; i < rings.size(); ++i) {
            polygons.add(this.geometryFactory.createPolygon(rings.get(i), null));
            ccwCache.add(null);
        }
        block3: for (i = 0; i < polygons.size(); ++i) {
            Polygon p = (Polygon)polygons.get(i);
            if (p.getNumInteriorRing() != 0) continue;
            for (int j = 0; j < polygons.size(); ++j) {
                if (j == i) continue;
                Polygon q = (Polygon)polygons.get(j);
                try {
                    if (!p.within((Geometry)q) || SDLEntry.ccw(p, i, ccwCache) == SDLEntry.ccw(q, j, ccwCache)) continue;
                    LinearRing[] qHoles = new LinearRing[q.getNumInteriorRing() + 1];
                    for (int k = 0; k < q.getNumInteriorRing(); ++k) {
                        qHoles[k] = (LinearRing)q.getInteriorRingN(k);
                    }
                    qHoles[qHoles.length - 1] = (LinearRing)p.getExteriorRing();
                    q = this.geometryFactory.createPolygon((LinearRing)q.getExteriorRing(), qHoles);
                    polygons.set(j, q);
                    polygons.remove(i);
                    ccwCache.remove(i);
                    --i;
                    continue block3;
                }
                catch (TopologyException te) {
                    this.addError(te.getMessage());
                }
            }
        }
        return polygons;
    }

    private static boolean ccw(Polygon p, int index, List<Boolean> ccwCacheArray) {
        Boolean cached = ccwCacheArray.get(index);
        if (cached != null) {
            return cached;
        }
        Boolean ccw = CGAlgorithms.isCCW((Coordinate[])p.getExteriorRing().getCoordinates());
        ccwCacheArray.set(index, ccw);
        return ccw;
    }
}

