/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.geotools.data.sdl;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import nl.b3p.geotools.data.sdl.SDLEntry;
import nl.b3p.geotools.data.sdl.SDLParseException;
import org.apache.commons.io.input.CountingInputStream;
import org.geotools.data.DataSourceException;
import org.geotools.data.FeatureReader;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.referencing.CRS;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.opengis.feature.IllegalAttributeException;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class SDLFeatureReader
implements FeatureReader {
    private GeometryFactory gf;
    private SimpleFeatureType ft;
    private CountingInputStream cis;
    private LineNumberReader lnr;
    private String version;
    private Map<String, String[]> metadata = new HashMap<String, String[]>();
    private static final int MARK_SIZE = 8192;
    private int featureID = 0;

    public SDLFeatureReader(URL url, String typeName, String srs) throws IOException, SDLParseException {
        this.cis = new CountingInputStream(url.openStream());
        this.lnr = new LineNumberReader(new InputStreamReader((InputStream)this.cis));
        this.parseHeader();
        this.skipCommentsCheckEOF();
        this.createFeatureType(typeName, srs);
    }

    private void parseHeader() throws IOException {
        this.skipCommentsCheckEOF();
        while (true) {
            String headerLine;
            this.lnr.mark(8192);
            String line = this.lnr.readLine();
            if (line == null) break;
            if (line.trim().length() == 0) continue;
            char firstChar = line.charAt(0);
            if (firstChar != '#') {
                this.lnr.reset();
                break;
            }
            String lcline = line.toLowerCase();
            if (lcline.startsWith("#version")) {
                this.version = line.substring(line.indexOf(61) + 1);
                continue;
            }
            if (!lcline.startsWith("#metadata_begin")) continue;
            String name = lcline.substring(line.indexOf(61) + 1);
            ArrayList<String> contents = new ArrayList<String>();
            while ((headerLine = this.lnr.readLine()) != null && !headerLine.toLowerCase().startsWith("#metadata_end")) {
                contents.add(headerLine.substring(1));
            }
            if (contents.isEmpty()) continue;
            this.metadata.put(name, contents.toArray(new String[0]));
        }
    }

    private void createFeatureType(String typeName, String srs) throws DataSourceException {
        CoordinateReferenceSystem crs = null;
        String[] csMetadata = this.metadata.get("coordinatesystem");
        if (csMetadata != null) {
            String wkt = csMetadata[0];
            try {
                CRSFactory crsFactory = ReferencingFactoryFinder.getCRSFactory(null);
                crs = crsFactory.createFromWKT(wkt);
            }
            catch (Exception e) {
                throw new DataSourceException("Error parsing CoordinateSystem WKT: \"" + wkt + "\"");
            }
        }
        if (srs != null) {
            try {
                crs = CRS.decode((String)srs);
            }
            catch (Exception e) {
                throw new DataSourceException("Error parsing CoordinateSystem srs: \"" + srs + "\"");
            }
        }
        try {
            SimpleFeatureTypeBuilder ftb = new SimpleFeatureTypeBuilder();
            ftb.setName(typeName);
            ftb.setCRS(crs);
            ftb.add("the_geom", Geometry.class);
            ftb.add("name", String.class);
            ftb.add("key", String.class);
            ftb.add("urlLink", String.class);
            ftb.add("entryLineNumber", Integer.class);
            ftb.add("parseError", Integer.class);
            ftb.add("error", String.class);
            this.ft = ftb.buildFeatureType();
            this.gf = new GeometryFactory();
        }
        catch (Exception e) {
            throw new DataSourceException("Error creating SimpleFeatureType", (Throwable)e);
        }
    }

    public SimpleFeatureType getFeatureType() {
        return this.ft;
    }

    private boolean skipCommentsCheckEOF() throws IOException {
        String line;
        do {
            this.lnr.mark(8192);
            line = this.lnr.readLine();
            if (line != null) continue;
            return true;
        } while (line.length() == 0 || line.charAt(0) == ';');
        this.lnr.reset();
        return false;
    }

    public SimpleFeature next() throws IOException, IllegalAttributeException, NoSuchElementException {
        try {
            SDLEntry entry = new SDLEntry(this.lnr, this.gf);
            Geometry g = entry.getGeometry();
            SimpleFeature f = SimpleFeatureBuilder.build((SimpleFeatureType)this.ft, (Object[])new Object[]{g, entry.getName(), entry.getKey(), entry.getUrlLink(), new Integer(entry.getStartingLineNumber()), new Integer(entry.isParseError() ? 1 : 0), entry.getErrorDescription()}, (String)Integer.toString(this.featureID++));
            return f;
        }
        catch (SDLParseException ex) {
            throw new IOException("SDL parse error" + ex.getLocalizedMessage());
        }
        catch (EOFException e) {
            return null;
        }
    }

    public boolean hasNext() throws IOException {
        return !this.skipCommentsCheckEOF();
    }

    public void close() throws IOException {
        this.lnr.close();
    }

    public long getByteCount() {
        return this.cis.getByteCount();
    }
}

